/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.embl.ebi.escience.scufl.AnnotationTemplate;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scuflui.PortComboBoxRenderer;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;

public class TemplateEditor
extends JComponent
implements ScuflUIComponent {
    Processor theProcessor;
    JPanel existingTemplates;
    JPanel defaultTemplates;
    static final PortComboBoxRenderer renderer = new PortComboBoxRenderer();

    public TemplateEditor(Processor theProcessor) {
        this.theProcessor = theProcessor;
        this.setLayout(new BoxLayout(this, 3));
        this.setPreferredSize(new Dimension(100, 100));
        JPanel addNewTemplate = new JPanel();
        addNewTemplate.setLayout(new GridLayout(3, 3));
        addNewTemplate.setMaximumSize(new Dimension(1000, 100));
        addNewTemplate.setPreferredSize(new Dimension(500, 100));
        Port[] allPorts = theProcessor.getPorts();
        final JComboBox<Port> subjects = new JComboBox<Port>(allPorts);
        subjects.setRenderer(renderer);
        final JComboBox<Port> objects = new JComboBox<Port>(allPorts);
        objects.setRenderer(renderer);
        final JTextField predicate = new JTextField();
        JButton createTemplate = new JButton("Create");
        addNewTemplate.add(new JLabel("Subject"));
        addNewTemplate.add(new JLabel("Predicate"));
        addNewTemplate.add(new JLabel("Object"));
        addNewTemplate.add(subjects);
        addNewTemplate.add(predicate);
        addNewTemplate.add(objects);
        addNewTemplate.add(createTemplate);
        createTemplate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a) {
                Port subject = (Port)subjects.getSelectedItem();
                Port object = (Port)objects.getSelectedItem();
                String verb = predicate.getText();
                if (!verb.equals("")) {
                    TemplateEditor.this.theProcessor.addAnnotationTemplate(AnnotationTemplate.standardTemplate(subject, verb, object));
                    TemplateEditor.this.populate();
                }
            }
        });
        addNewTemplate.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Create new template"));
        this.add(addNewTemplate);
        this.existingTemplates = new JPanel();
        this.existingTemplates.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Current templates"));
        this.existingTemplates.setLayout(new BoxLayout(this.existingTemplates, 3));
        this.defaultTemplates = new JPanel();
        this.defaultTemplates.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Default templates"));
        this.defaultTemplates.setLayout(new BoxLayout(this.defaultTemplates, 3));
        this.populate();
        this.add(this.existingTemplates);
        this.add(this.defaultTemplates);
        this.setVisible(true);
    }

    private JComponent makeSmall(JComponent c) {
        c.setPreferredSize(new Dimension(70, 20));
        c.setMaximumSize(c.getPreferredSize());
        return c;
    }

    void populate() {
        this.existingTemplates.removeAll();
        this.defaultTemplates.removeAll();
        AnnotationTemplate[] templates = this.theProcessor.getAnnotationTemplates();
        for (int i = 0; i < templates.length; ++i) {
            this.existingTemplates.add(new JEditorPane("text/html", templates[i].getDescription()));
        }
        if (templates.length == 0) {
            this.existingTemplates.add(new JLabel("No existing templates"));
        }
        AnnotationTemplate[] defaults = this.theProcessor.defaultAnnotationTemplates();
        for (int i = 0; i < defaults.length; ++i) {
            this.defaultTemplates.add(new JEditorPane("text/html", defaults[i].getDescription()));
        }
        if (defaults.length == 0) {
            JLabel l = new JLabel("No default templates");
            l.setPreferredSize(new Dimension(1000, 25));
            this.defaultTemplates.add(l);
        }
    }

    public void attachToModel(ScuflModel model) {
    }

    public void detachFromModel() {
    }

    public void receiveModelEvent(ScuflModelEvent event) {
    }

    public String getName() {
        return "Template editor for " + this.theProcessor.getName();
    }

    public ImageIcon getIcon() {
        return null;
    }
}

