/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scuflui.IterationStrategyEditorControl;
import org.embl.ebi.escience.scuflui.LogLevelHolder;

public class ScuflProcessorInfo
extends JDialog {
    public static LogLevelHolder[] logLevels = new LogLevelHolder[]{new LogLevelHolder(-1, "log : Inherit from model"), new LogLevelHolder(0, "log : No logging"), new LogLevelHolder(1, "log : Low logging"), new LogLevelHolder(2, "log : Medium logging"), new LogLevelHolder(3, "log : High logging")};
    private String[] columnNames = new String[]{"Property", "Value"};
    private ArrayList propertyNames = new ArrayList();
    private ArrayList propertyValues = new ArrayList();

    public ScuflProcessorInfo(Processor p) {
        super((Frame)null, "Processor information for " + p.getName(), true);
        this.setDefaultCloseOperation(0);
        final Processor theProcessor = p;
        this.getContentPane().setLayout(new BorderLayout());
        Object[] columnNames = new String[]{"Property", "Value"};
        this.addRow("Name", theProcessor.getName());
        this.addRow("Class", theProcessor.getClass().toString());
        Properties props = theProcessor.getProperties();
        Iterator<Object> i = props.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = (String)props.get(key);
            this.addRow(key, value);
        }
        Object[][] tableData = new Object[this.propertyValues.size()][2];
        for (int i2 = 0; i2 < this.propertyValues.size(); ++i2) {
            tableData[i2][0] = this.propertyNames.get(i2);
            tableData[i2][1] = this.propertyValues.get(i2);
        }
        JTable infoTable = new JTable(tableData, columnNames);
        infoTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        infoTable.getColumnModel().getColumn(1).setPreferredWidth(400);
        JScrollPane infoTablePane = new JScrollPane(infoTable);
        infoTablePane.setPreferredSize(new Dimension(500, 100));
        final JComboBox<LogLevelHolder> provenanceLevel = new JComboBox<LogLevelHolder>(logLevels);
        provenanceLevel.setSelectedItem(this.logLevelHolderForLevel(theProcessor.getRealLogLevel()));
        provenanceLevel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                LogLevelHolder level = (LogLevelHolder)provenanceLevel.getSelectedItem();
                theProcessor.setLogLevel(level.logLevel);
            }
        });
        final JTextArea description = new JTextArea(theProcessor.getDescription());
        description.setEditable(true);
        JButton updateDescription = new JButton("Update description and close");
        updateDescription.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                theProcessor.setDescription(description.getText());
                ScuflProcessorInfo.this.setVisible(false);
            }
        });
        JButton cancelUpdate = new JButton("Cancel");
        cancelUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ScuflProcessorInfo.this.setVisible(false);
            }
        });
        JScrollPane descriptionPane = new JScrollPane(description);
        descriptionPane.setPreferredSize(new Dimension(500, 150));
        JPanel dp = new JPanel(new BorderLayout());
        dp.add((Component)descriptionPane, "Center");
        TitledBorder dpBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Description");
        dp.setBorder(dpBorder);
        Container contentPane = this.getContentPane();
        if (p.getIterationStrategy() != null) {
            contentPane.add((Component)new IterationStrategyEditorControl(p.getIterationStrategy()), "Center");
        }
        contentPane.add((Component)dp, "North");
        contentPane.add((Component)updateDescription, "West");
        contentPane.add((Component)cancelUpdate, "East");
        contentPane.add((Component)infoTablePane, "South");
        this.pack();
        this.setVisible(true);
    }

    private void addRow(String key, String value) {
        this.propertyNames.add(key);
        this.propertyValues.add(value);
    }

    public LogLevelHolder logLevelHolderForLevel(int level) {
        for (int i = 0; i < logLevels.length; ++i) {
            if (level != ScuflProcessorInfo.logLevels[i].logLevel) continue;
            return logLevels[i];
        }
        return logLevels[0];
    }
}

