/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.embl.ebi.escience.scufl.AlternateProcessor;
import org.embl.ebi.escience.scufl.DataConstraint;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.ScuflModelEventListener;
import org.embl.ebi.escience.scufl.view.TreeTableModelView;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.ScuflModelExplorerPopupHandler;
import org.embl.ebi.escience.scuflui.ScuflModelExplorerRenderer;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;
import org.embl.ebi.escience.scuflui.dnd.FactorySpecFragment;
import org.embl.ebi.escience.scuflui.dnd.ProcessorSpecFragment;
import org.embl.ebi.escience.scuflui.dnd.SpecFragmentTransferable;
import org.embl.ebi.escience.scuflworkers.ProcessorHelper;
import org.embl.ebi.escience.treetable.JTreeTable;
import org.embl.ebi.escience.treetable.TreeTableModel;
import org.jdom.Content;
import org.jdom.Element;

public class ScuflModelTreeTable
extends JTreeTable
implements ScuflModelEventListener,
ScuflUIComponent,
DropTargetListener,
DragSourceListener,
DragGestureListener {
    ScuflModel model = null;
    Processor lastInterestingProcessor = null;
    TreeTableModelView treeModel = new TreeTableModelView();
    TreePath pathToSelect = null;

    public ScuflModelTreeTable() {
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        new DropTarget(this, 3, this);
        this.setModel(this.treeModel);
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn mainColumn = columnModel.getColumn(0);
        for (int i = 1; i < 5; ++i) {
            TableColumn c = columnModel.getColumn(i);
            c.setResizable(false);
            c.setMaxWidth(55);
            c.setMinWidth(55);
            c.setPreferredWidth(55);
        }
        this.setDefaultEditor(TreeTableModel.class, new ScuflModelTreeTableCellEditor());
        JCheckBox jcbox = new JCheckBox();
        jcbox.setBackground(this.getBackground());
        jcbox.setHorizontalAlignment(0);
        this.setDefaultEditor(Boolean.class, new DefaultCellEditor(jcbox));
        this.setDefaultRenderer(Boolean.class, new TableCheckbox());
        this.addMouseListener(new ScuflModelExplorerPopupHandler(this));
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        ScuflModelExplorerRenderer renderer = new ScuflModelExplorerRenderer();
        this.tree.setCellRenderer(renderer);
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        TreePath dragFromPath;
        Point p = e.getDragOrigin();
        int x = (int)p.getX();
        int y = (int)p.getY();
        for (int counter = this.getColumnCount() - 1; counter >= 0; --counter) {
            if (this.getColumnClass(counter) != (class$org$embl$ebi$escience$treetable$TreeTableModel == null ? ScuflModelTreeTable.class$("org.embl.ebi.escience.treetable.TreeTableModel") : class$org$embl$ebi$escience$treetable$TreeTableModel)) continue;
            x -= this.getCellRect((int)0, (int)counter, (boolean)true).x;
            break;
        }
        if ((dragFromPath = this.tree.getPathForLocation(x, y)) == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)dragFromPath.getLastPathComponent();
        Object o = node.getUserObject();
        if (o instanceof Processor) {
            Processor dragSource = (Processor)o;
            if (dragSource.getModel() == null) {
                return;
            }
            Element el = ProcessorHelper.elementForProcessor(dragSource);
            ProcessorSpecFragment psf = new ProcessorSpecFragment(el, dragSource.getName());
            SpecFragmentTransferable t = new SpecFragmentTransferable(psf);
            e.startDrag(DragSource.DefaultCopyDrop, t, this);
        }
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void drop(DropTargetDropEvent e) {
        try {
            DataFlavor f = SpecFragmentTransferable.factorySpecFragmentFlavor;
            Transferable t = e.getTransferable();
            if (e.isDataFlavorSupported(f)) {
                TreePath path;
                FactorySpecFragment fsf = (FactorySpecFragment)t.getTransferData(f);
                Point p = e.getLocation();
                int x = (int)p.getX();
                int y = (int)p.getY();
                for (int counter = this.getColumnCount() - 1; counter >= 0; --counter) {
                    if (this.getColumnClass(counter) != (class$org$embl$ebi$escience$treetable$TreeTableModel == null ? ScuflModelTreeTable.class$("org.embl.ebi.escience.treetable.TreeTableModel") : class$org$embl$ebi$escience$treetable$TreeTableModel)) continue;
                    x -= this.getCellRect((int)0, (int)counter, (boolean)true).x;
                    break;
                }
                if ((path = this.tree.getPathForLocation(x, y)) != null && path.getPathCount() > 2 && ((DefaultMutableTreeNode)path.getPathComponent(2)).getUserObject() instanceof Processor) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getPathComponent(2);
                    System.out.println(node.toString());
                    Processor target = (Processor)node.getUserObject();
                    Element wrapperElement = new Element("wrapper");
                    wrapperElement.addContent((Content)fsf.getElement());
                    Processor alternateProcessor = ProcessorHelper.loadProcessorFromXML(wrapperElement, null, "alternate");
                    AlternateProcessor ap = new AlternateProcessor(alternateProcessor);
                    target.addAlternate(ap);
                } else {
                    System.out.println("No node under the drop.");
                    String validName = this.model.getValidProcessorName(fsf.getFactoryNodeName());
                    Element wrapperElement = new Element("wrapper");
                    wrapperElement.addContent((Content)fsf.getElement());
                    Processor newProcessor = ProcessorHelper.loadProcessorFromXML(wrapperElement, this.model, validName);
                    this.model.addProcessor(newProcessor);
                }
                e.acceptDrop(3);
            }
        }
        catch (Exception ex) {
            e.rejectDrop();
        }
    }

    public void dragEnter(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultExpansionState() {
        TreeTableModelView treeTableModelView = this.treeModel;
        synchronized (treeTableModelView) {
            this.pathToSelect = null;
            this.expandAll(this.tree, new TreePath(this.treeModel.getRoot()), true);
            if (this.pathToSelect != null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeTableModelView treeTableModelView = this.treeModel;
        synchronized (treeTableModelView) {
            TreeNode node = (TreeNode)parent.getLastPathComponent();
            if (node.getChildCount() >= 0 && !(((DefaultMutableTreeNode)node).getUserObject() instanceof Processor)) {
                Enumeration<? extends TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeNode n = e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    if (((DefaultMutableTreeNode)n).getUserObject() instanceof Processor) {
                        Processor p = (Processor)((DefaultMutableTreeNode)n).getUserObject();
                        if (p != this.lastInterestingProcessor) continue;
                        this.pathToSelect = path;
                        this.expandAll(tree, path, expand);
                        continue;
                    }
                    this.expandAll(tree, path, expand);
                }
            }
            if (expand) {
                tree.expandPath(parent);
            } else {
                tree.collapsePath(parent);
            }
        }
    }

    public void attachToModel(ScuflModel theModel) {
        this.model = theModel;
        this.treeModel.attachToModel(theModel);
        theModel.addListener(this.treeModel);
        theModel.addListener(this);
        this.setDefaultExpansionState();
    }

    public void detachFromModel() {
        if (this.model != null) {
            this.model.removeListener(this);
            this.model.removeListener(this.treeModel);
        }
    }

    public synchronized void receiveModelEvent(ScuflModelEvent event) {
        if (event.getSource() instanceof Processor) {
            this.lastInterestingProcessor = (Processor)event.getSource();
        } else if (event.getSource() instanceof DataConstraint) {
            DataConstraint dc = (DataConstraint)event.getSource();
            Port sourcePort = dc.getSource();
            this.lastInterestingProcessor = sourcePort.getProcessor();
        }
        this.setDefaultExpansionState();
    }

    public String getName() {
        return "Scufl Model Explorer";
    }

    public ImageIcon getIcon() {
        return ScuflIcons.windowExplorer;
    }

    class TableCheckbox
    extends JCheckBox
    implements TableCellRenderer {
        TableCheckbox() {
            this.setBackground(ScuflModelTreeTable.this.getBackground());
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null) {
                this.setSelected((Boolean)value);
                return this;
            }
            JLabel label = new JLabel("");
            label.setBackground(ScuflModelTreeTable.this.getBackground());
            return label;
        }
    }

    public class ScuflModelTreeTableCellEditor
    extends DefaultCellEditor {
        public ScuflModelTreeTableCellEditor() {
            super(new JTreeTable.TreeTableTextField());
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            Component component = super.getTableCellEditorComponent(table, value, isSelected, r, c);
            JTree t = ScuflModelTreeTable.this.getTree();
            boolean rv = t.isRootVisible();
            int offsetRow = rv ? r : r - 1;
            Rectangle bounds = t.getRowBounds(offsetRow);
            int offset = bounds.x;
            TreeCellRenderer tcr = t.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                Object uo;
                boolean isLeaf;
                boolean isExpanded;
                Object node = t.getPathForRow(offsetRow).getLastPathComponent();
                Component renderer = tcr.getTreeCellRendererComponent(t, node, true, isExpanded = t.isExpanded(t.getPathForRow(offsetRow)), isLeaf = t.getModel().isLeaf(node), offsetRow, true);
                Icon icon = ((JLabel)renderer).getIcon();
                if (icon != null) {
                    offset += ((DefaultTreeCellRenderer)tcr).getIconTextGap() + icon.getIconWidth();
                }
                if ((uo = ((DefaultMutableTreeNode)node).getUserObject()) instanceof Processor) {
                    String currentName = ((Processor)uo).getName();
                    ((JTreeTable.TreeTableTextField)this.getComponent()).setText(currentName);
                }
            }
            ((JTreeTable.TreeTableTextField)this.getComponent()).offset = offset;
            return component;
        }

        public boolean isCellEditable(EventObject e) {
            MouseEvent me;
            if (e instanceof MouseEvent && (me = (MouseEvent)e).getClickCount() >= 2) {
                return true;
            }
            return e == null;
        }
    }
}

