/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.embl.ebi.escience.scufl.AlternateProcessor;
import org.embl.ebi.escience.scufl.ConcurrencyConstraint;
import org.embl.ebi.escience.scufl.DataConstraint;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflworkers.ProcessorHelper;

public class ScuflModelExplorerRenderer
extends DefaultTreeCellRenderer {
    private String pattern = null;

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public ScuflModelExplorerRenderer() {
    }

    public ScuflModelExplorerRenderer(String pattern) {
        this.pattern = pattern;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
        if (userObject instanceof AlternateProcessor) {
            userObject = ((AlternateProcessor)userObject).getProcessor();
        }
        if (userObject instanceof Processor) {
            this.setIcon(ProcessorHelper.getPreferredIcon((Processor)userObject));
        } else if (userObject instanceof ConcurrencyConstraint) {
            this.setIcon(ScuflIcons.constraintIcon);
        } else if (userObject instanceof Port) {
            Port thePort = (Port)userObject;
            ScuflModel model = thePort.getProcessor().getModel();
            if (thePort.isSource()) {
                this.setIcon(ScuflIcons.inputIcon);
            } else if (thePort.isSink()) {
                this.setIcon(ScuflIcons.outputIcon);
            } else {
                if (thePort instanceof InputPort) {
                    this.setIcon(ScuflIcons.inputPortIcon);
                } else if (thePort instanceof OutputPort) {
                    this.setIcon(ScuflIcons.outputPortIcon);
                }
                if (model == null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                    DefaultMutableTreeNode alternateProcessorNode = (DefaultMutableTreeNode)node.getParent();
                    AlternateProcessor theAlternate = (AlternateProcessor)alternateProcessorNode.getUserObject();
                    String originalPortName = theAlternate.getPortTranslation(thePort.getName());
                    if (originalPortName == null) {
                        originalPortName = "<NO MAPPING>";
                    }
                    this.setText(thePort.getName() + " == " + originalPortName);
                }
            }
        } else if (userObject instanceof DataConstraint) {
            this.setIcon(ScuflIcons.dataLinkIcon);
        } else if (((DefaultMutableTreeNode)value).isLeaf()) {
            this.setIcon(ScuflIcons.folderClosedIcon);
        } else if (expanded) {
            this.setIcon(ScuflIcons.folderOpenIcon);
        } else {
            this.setIcon(ScuflIcons.folderClosedIcon);
        }
        if (this.pattern != null && userObject.toString().toLowerCase().matches(this.pattern)) {
            this.setText("<html><font color=\"red\">" + userObject.toString() + "</font></html>");
        }
        return this;
    }
}

