/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.view.TreeModelView;
import org.embl.ebi.escience.scuflui.NoContextMenuFoundException;
import org.embl.ebi.escience.scuflui.ScuflContextMenuFactory;
import org.embl.ebi.escience.scuflui.ScuflModelExplorer;
import org.embl.ebi.escience.scuflui.ScuflModelTreeTable;
import org.embl.ebi.escience.scuflui.TemplateEditor;
import org.embl.ebi.escience.scuflui.UIUtils;

public class ScuflModelExplorerPopupHandler
extends MouseAdapter {
    JTree explorer;
    TreeModelView model;
    JComponent owner;

    public ScuflModelExplorerPopupHandler(ScuflModelExplorer theExplorer) {
        this.explorer = theExplorer;
        this.model = theExplorer.treeModel;
        this.owner = theExplorer;
    }

    public ScuflModelExplorerPopupHandler(ScuflModelTreeTable theTable) {
        this.explorer = theTable.getTree();
        this.model = theTable.treeModel;
        this.owner = theTable;
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doEvent(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doEvent(e);
        }
    }

    void doEvent(MouseEvent e) {
        DefaultMutableTreeNode node = null;
        try {
            node = (DefaultMutableTreeNode)this.explorer.getPathForLocation(e.getX(), e.getY()).getLastPathComponent();
        }
        catch (NullPointerException npe) {
            return;
        }
        Object scuflObject = node.getUserObject();
        if (scuflObject != null) {
            try {
                MouseEvent theMouseEvent = e;
                JPopupMenu theMenu = ScuflContextMenuFactory.getMenuForObject(node, scuflObject, this.model.getModel());
                if (scuflObject instanceof Processor) {
                    final Processor theProcessor = (Processor)scuflObject;
                    theMenu.addSeparator();
                    JMenuItem editTemplates = new JMenuItem("Edit templates");
                    editTemplates.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent a) {
                            UIUtils.createFrame(theProcessor.getModel(), new TemplateEditor(theProcessor), 100, 100, 300, 300);
                        }
                    });
                    theMenu.add(editTemplates);
                }
                theMenu.show(this.owner, e.getX(), e.getY());
            }
            catch (NoContextMenuFoundException ncmfe) {
                // empty catch block
            }
        }
    }
}

