/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.parser.XScuflParser;
import org.embl.ebi.escience.scuflui.ScuflModelExplorer;

public class ScuflModelExplorerDemo
extends JFrame {
    ScuflModelExplorer explorer = new ScuflModelExplorer();
    ScuflModel model = new ScuflModel();

    public ScuflModelExplorerDemo() {
        super("Scufl Model Explorer Demo Application");
        JScrollPane view = new JScrollPane(this.explorer);
        this.getContentPane().add(view);
    }

    public static void main(String[] args) throws Exception {
        ScuflModelExplorerDemo frame = new ScuflModelExplorerDemo();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        String filename = args[0];
        File inputFile = new File(filename);
        XScuflParser.populate(inputFile.toURL().openStream(), frame.model, null);
        frame.explorer.attachToModel(frame.model);
        TreeNode root = (TreeNode)frame.explorer.getModel().getRoot();
        frame.expandAll(frame.explorer, new TreePath(root), true);
        frame.pack();
        frame.setVisible(true);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0 && !(((DefaultMutableTreeNode)node).getUserObject() instanceof Processor)) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                if (((DefaultMutableTreeNode)n).getUserObject() instanceof Processor) continue;
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }
}

