/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scuflui.ExtensionFileFilter;
import org.embl.ebi.escience.scuflui.ScuflDiagram;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;

public class ScuflDiagramPanel
extends JPanel
implements ScuflUIComponent {
    String[] displayPolicyStrings = new String[]{"All ports", "Bound ports", "No ports"};
    String[] alignment = new String[]{"Vertical", "Horizontal"};
    JButton saveAsDot;
    JButton saveAsPNG;
    JButton saveAsSVG;
    JComboBox displayPolicyChooser = new JComboBox<String>(this.displayPolicyStrings);
    JComboBox alignmentChooser = new JComboBox<String>(this.alignment);
    ScuflDiagram diagram = new ScuflDiagram();
    JCheckBox typeDisplay = new JCheckBox("Show types", false);
    JCheckBox fitToWindow = new JCheckBox("Fit to window", true);
    static ImageIcon svgIcon;
    static ImageIcon pngIcon;
    static ImageIcon dotIcon;
    final JFileChooser fc;
    static /* synthetic */ Class class$org$embl$ebi$escience$scuflui$ScuflDiagramPanel;

    public ImageIcon getIcon() {
        return ScuflIcons.windowDiagram;
    }

    public ScuflDiagramPanel() {
        this.setLayout(new BorderLayout());
        JScrollPane diagramPane = new JScrollPane(this.diagram);
        this.diagram.disableMouseListener();
        diagramPane.setPreferredSize(new Dimension(0, 0));
        diagramPane.getViewport().setBackground(Color.WHITE);
        this.add((Component)diagramPane, "Center");
        this.diagram.setPortDisplay(2);
        this.diagram.setDisplayTypes(false);
        this.diagram.setFitToWindow(true);
        this.saveAsDot = new JButton(dotIcon);
        this.saveAsDot.setPreferredSize(new Dimension(25, 25));
        this.saveAsSVG = new JButton(svgIcon);
        this.saveAsSVG.setPreferredSize(new Dimension(25, 25));
        this.saveAsPNG = new JButton(pngIcon);
        this.saveAsPNG.setPreferredSize(new Dimension(25, 25));
        JToolBar toolbar = new JToolBar();
        toolbar.add(new JLabel("Save as "));
        toolbar.add(this.saveAsDot);
        toolbar.add(this.saveAsPNG);
        toolbar.add(this.saveAsSVG);
        toolbar.addSeparator();
        toolbar.add(this.typeDisplay);
        toolbar.addSeparator();
        toolbar.add(this.displayPolicyChooser);
        toolbar.add(this.alignmentChooser);
        toolbar.addSeparator();
        toolbar.add(this.fitToWindow);
        toolbar.add(Box.createHorizontalGlue());
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.setMaximumSize(new Dimension(2000, 30));
        this.displayPolicyChooser.setSelectedIndex(2);
        this.displayPolicyChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScuflDiagramPanel.this.diagram.setPortDisplay(ScuflDiagramPanel.this.displayPolicyChooser.getSelectedIndex());
                ScuflDiagramPanel.this.alignmentChooser.setSelectedIndex(ScuflDiagramPanel.this.diagram.getLRAlignment() ? 1 : 0);
                ScuflDiagramPanel.this.doLayout();
                ScuflDiagramPanel.this.repaint();
            }
        });
        this.alignmentChooser.setSelectedIndex(0);
        this.alignmentChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScuflDiagramPanel.this.diagram.setLRAlignment(ScuflDiagramPanel.this.alignmentChooser.getSelectedIndex() != 0);
                ScuflDiagramPanel.this.doLayout();
                ScuflDiagramPanel.this.repaint();
            }
        });
        this.typeDisplay.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    ScuflDiagramPanel.this.diagram.setDisplayTypes(false);
                } else {
                    ScuflDiagramPanel.this.diagram.setDisplayTypes(true);
                }
            }
        });
        this.fitToWindow.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    ScuflDiagramPanel.this.diagram.setFitToWindow(false);
                } else {
                    ScuflDiagramPanel.this.diagram.setFitToWindow(true);
                }
            }
        });
        this.saveAsDot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Preferences prefs = Preferences.userNodeForPackage(class$org$embl$ebi$escience$scuflui$ScuflDiagramPanel == null ? (class$org$embl$ebi$escience$scuflui$ScuflDiagramPanel = ScuflDiagramPanel.class$("org.embl.ebi.escience.scuflui.ScuflDiagramPanel")) : class$org$embl$ebi$escience$scuflui$ScuflDiagramPanel);
                    String curDir = prefs.get("currentDir", System.getProperty("user.home"));
                    ScuflDiagramPanel.this.fc.setCurrentDirectory(new File(curDir));
                    ScuflDiagramPanel.this.fc.resetChoosableFileFilters();
                    ScuflDiagramPanel.this.fc.setFileFilter(new ExtensionFileFilter(new String[]{"dot"}));
                    int returnVal = ScuflDiagramPanel.this.fc.showSaveDialog(ScuflDiagramPanel.this);
                    if (returnVal == 0) {
                        prefs.put("currentDir", ScuflDiagramPanel.this.fc.getCurrentDirectory().toString());
                        File file = ScuflDiagramPanel.this.fc.getSelectedFile();
                        PrintWriter out = new PrintWriter(new FileWriter(file));
                        out.println(ScuflDiagramPanel.this.diagram.getDot());
                        out.flush();
                        out.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.saveAsPNG.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Preferences prefs = Preferences.userNodeForPackage(class$org$embl$ebi$escience$scuflui$ScuflDiagramPanel == null ? (class$org$embl$ebi$escience$scuflui$ScuflDiagramPanel = ScuflDiagramPanel.class$("org.embl.ebi.escience.scuflui.ScuflDiagramPanel")) : class$org$embl$ebi$escience$scuflui$ScuflDiagramPanel);
                    String curDir = prefs.get("currentDir", System.getProperty("user.home"));
                    ScuflDiagramPanel.this.fc.setCurrentDirectory(new File(curDir));
                    ScuflDiagramPanel.this.fc.resetChoosableFileFilters();
                    ScuflDiagramPanel.this.fc.setFileFilter(new ExtensionFileFilter(new String[]{"png"}));
                    int returnVal = ScuflDiagramPanel.this.fc.showSaveDialog(ScuflDiagramPanel.this);
                    if (returnVal == 0) {
                        prefs.put("currentDir", ScuflDiagramPanel.this.fc.getCurrentDirectory().toString());
                        File file = ScuflDiagramPanel.this.fc.getSelectedFile();
                        FileOutputStream fos = new FileOutputStream(file);
                        String dotLocation = System.getProperty("taverna.dotlocation");
                        if (dotLocation == null) {
                            dotLocation = "dot";
                        }
                        Process dotProcess = Runtime.getRuntime().exec(new String[]{dotLocation, "-Tpng"});
                        OutputStream dotOut = dotProcess.getOutputStream();
                        dotOut.write(ScuflDiagramPanel.this.diagram.getDot().getBytes());
                        dotOut.flush();
                        dotOut.close();
                        new StreamCopier(dotProcess.getInputStream(), fos).start();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.saveAsSVG.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Preferences prefs = Preferences.userNodeForPackage(class$org$embl$ebi$escience$scuflui$ScuflDiagramPanel == null ? (class$org$embl$ebi$escience$scuflui$ScuflDiagramPanel = ScuflDiagramPanel.class$("org.embl.ebi.escience.scuflui.ScuflDiagramPanel")) : class$org$embl$ebi$escience$scuflui$ScuflDiagramPanel);
                    String curDir = prefs.get("currentDir", System.getProperty("user.home"));
                    ScuflDiagramPanel.this.fc.setCurrentDirectory(new File(curDir));
                    ScuflDiagramPanel.this.fc.resetChoosableFileFilters();
                    ScuflDiagramPanel.this.fc.setFileFilter(new ExtensionFileFilter(new String[]{"svg"}));
                    int returnVal = ScuflDiagramPanel.this.fc.showSaveDialog(ScuflDiagramPanel.this);
                    if (returnVal == 0) {
                        prefs.put("currentDir", ScuflDiagramPanel.this.fc.getCurrentDirectory().toString());
                        File file = ScuflDiagramPanel.this.fc.getSelectedFile();
                        FileOutputStream fos = new FileOutputStream(file);
                        String dotLocation = System.getProperty("taverna.dotlocation");
                        if (dotLocation == null) {
                            dotLocation = "dot";
                        }
                        Process dotProcess = Runtime.getRuntime().exec(new String[]{dotLocation, "-Tsvg"});
                        OutputStream dotOut = dotProcess.getOutputStream();
                        dotOut.write(ScuflDiagramPanel.this.diagram.getDot().getBytes());
                        dotOut.flush();
                        dotOut.close();
                        new StreamCopier(dotProcess.getInputStream(), fos).start();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.fc = new JFileChooser();
        this.add((Component)toolbar, "First");
    }

    public void attachToModel(ScuflModel model) {
        this.diagram.attachToModel(model);
        this.diagram.setPortDisplay(this.displayPolicyChooser.getSelectedIndex());
        this.diagram.setLRAlignment(this.alignmentChooser.getSelectedIndex() != 0);
        this.diagram.setFitToWindow(true);
        this.diagram.setDisplayTypes(false);
    }

    public void detachFromModel() {
        this.diagram.detachFromModel();
    }

    public String getName() {
        return "Workflow diagram";
    }

    static {
        try {
            Class<?> c = Class.forName("org.embl.ebi.escience.scuflui.ScuflDiagramPanel");
            svgIcon = new ImageIcon(c.getResource("icons/graphicalview/saveAsSVG.png"));
            dotIcon = new ImageIcon(c.getResource("icons/graphicalview/saveAsDot.png"));
            pngIcon = new ImageIcon(c.getResource("icons/graphicalview/saveAsPNG.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class StreamCopier
    extends Thread {
        InputStream is;
        OutputStream os;

        public StreamCopier(InputStream is, OutputStream os) {
            this.is = is;
            this.os = os;
        }

        public void run() {
            try {
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = this.is.read(buffer)) != -1) {
                    this.os.write(buffer, 0, bytesRead);
                }
                this.os.flush();
                this.os.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

