/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.baclava.factory.DataThingTreeFactory;
import org.embl.ebi.escience.baclava.factory.DataThingTreeNode;
import org.embl.ebi.escience.baclava.factory.DataThingTreeTransferHandler;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.renderers.RendererException;
import org.embl.ebi.escience.scuflui.renderers.RendererRegistry;
import org.embl.ebi.escience.scuflui.renderers.RendererSPI;

public class ResultItemPanel
extends JPanel {
    Logger LOG = Logger.getLogger((Class)ResultItemPanel.class);
    final JFileChooser fc = new JFileChooser();
    final RendererRegistry renderers;

    public ResultItemPanel(DataThing theDataThing) {
        this(theDataThing, RendererRegistry.instance());
    }

    public ResultItemPanel(DataThing theDataThing, RendererRegistry renderers) {
        super(new BorderLayout());
        this.renderers = renderers;
        final JTree structureTree = new JTree(DataThingTreeFactory.getTree(theDataThing)){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        structureTree.setRowHeight(0);
        structureTree.setCellRenderer(DataThingTreeFactory.getRenderer());
        new DataThingTreeTransferHandler(structureTree, 1);
        String viewerHelp = "<h2>Result browser</h2>Click on items in the tree to the left of this panel to select them and show their values in this area. Right clicking on an item within the tree will allow you to select different rendering options that might be available, for example displaying an XML file as text or as a navigable tree.";
        JEditorPane help = new JEditorPane("text/html", viewerHelp);
        help.setPreferredSize(new Dimension(200, 100));
        help.setEditable(false);
        JScrollPane helpPanel = new JScrollPane(help);
        helpPanel.getViewport().setBackground(Color.WHITE);
        final JSplitPane splitPane = new JSplitPane(1, new JScrollPane(structureTree), helpPanel);
        splitPane.setDividerLocation(-1);
        boolean isEmptyCollection = false;
        Object data = theDataThing.getDataObject();
        if (data instanceof Collection) {
            isEmptyCollection = ((Collection)data).isEmpty();
        }
        if (!isEmptyCollection) {
            structureTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    DataThing dataThing;
                    RendererSPI renderer;
                    DataThingTreeNode node = (DataThingTreeNode)structureTree.getLastSelectedPathComponent();
                    if (node != null && (renderer = ResultItemPanel.this.renderers.getRenderer(dataThing = node.getNodeThing())) != null) {
                        try {
                            JComponent component = renderer.getComponent(ResultItemPanel.this.renderers, dataThing);
                            if (component != null) {
                                JScrollPane foo = new JScrollPane(component);
                                foo.getViewport().setBackground(Color.WHITE);
                                foo.setPreferredSize(new Dimension(100, 100));
                                splitPane.setRightComponent(foo);
                                splitPane.setDividerLocation(-1);
                            }
                        }
                        catch (RendererException re) {
                            ResultItemPanel.this.LOG.error((Object)"Problem loading renderer", (Throwable)re);
                        }
                    }
                }
            });
        }
        structureTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.doEvent(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.doEvent(e);
                }
            }

            void doEvent(MouseEvent e) {
                DataThingTreeNode node = (DataThingTreeNode)structureTree.getPathForLocation(e.getX(), e.getY()).getLastPathComponent();
                Object theDataObject = node.getUserObject();
                JPopupMenu theMenu = new JPopupMenu();
                JMenuItem saveAction = new JMenuItem("Save to file", ScuflIcons.saveIcon);
                saveAction.addActionListener(new ActionListener(this, theDataObject){
                    private final /* synthetic */ Object val$theDataObject;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$theDataObject = val$theDataObject;
                    }

                    public void actionPerformed(ActionEvent ae) {
                        try {
                            Preferences prefs = Preferences.userNodeForPackage(class$org$embl$ebi$escience$scuflui$ResultItemPanel == null ? (class$org$embl$ebi$escience$scuflui$ResultItemPanel = ResultItemPanel.class$("org.embl.ebi.escience.scuflui.ResultItemPanel")) : class$org$embl$ebi$escience$scuflui$ResultItemPanel);
                            String curDir = prefs.get("currentDir", System.getProperty("user.home"));
                            3.access$000(this.this$1).fc.setCurrentDirectory(new File(curDir));
                            int returnVal = 3.access$000(this.this$1).fc.showSaveDialog(3.access$000(this.this$1));
                            if (returnVal == 0) {
                                prefs.put("currentDir", 3.access$000(this.this$1).fc.getCurrentDirectory().toString());
                                File file = 3.access$000(this.this$1).fc.getSelectedFile();
                                FileOutputStream fos = new FileOutputStream(file);
                                if (this.val$theDataObject instanceof byte[]) {
                                    fos.write((byte[])this.val$theDataObject);
                                    fos.flush();
                                    fos.close();
                                } else {
                                    BufferedWriter out = new BufferedWriter(new OutputStreamWriter(fos));
                                    out.write((String)this.val$theDataObject);
                                    ((Writer)out).flush();
                                    ((Writer)out).close();
                                }
                            }
                        }
                        catch (IOException ioe) {
                            JOptionPane.showMessageDialog(null, "Problem saving data : \n" + ioe.getMessage(), "Exception!", 0);
                        }
                    }
                });
                if (node.isLeaf()) {
                    theMenu.add(saveAction);
                }
                DataThing nodeThing = node.getNodeThing();
                boolean isEmptyCollection = false;
                Object data = nodeThing.getDataObject();
                if (data instanceof Collection) {
                    isEmptyCollection = ((Collection)data).isEmpty();
                }
                Iterator renderers = ResultItemPanel.this.renderers.getRenderers(nodeThing).iterator();
                if (!isEmptyCollection && renderers.hasNext()) {
                    JMenu viewers = new JMenu("Viewers");
                    while (renderers.hasNext()) {
                        RendererSPI renderer = (RendererSPI)renderers.next();
                        viewers.add(new JMenuItem(new AbstractAction(this, renderer.getName(), renderer.getIcon(ResultItemPanel.this.renderers, nodeThing), renderer, nodeThing){
                            private final /* synthetic */ RendererSPI val$renderer;
                            private final /* synthetic */ DataThing val$nodeThing;
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$renderer = val$renderer;
                                this.val$nodeThing = val$nodeThing;
                                super(x0, x1);
                            }

                            public void actionPerformed(ActionEvent e) {
                                try {
                                    JComponent component = this.val$renderer.getComponent(3.access$000(this.this$1).renderers, this.val$nodeThing);
                                    if (ResultItemPanel.access$100(3.access$000(this.this$1)) != null) {
                                        JScrollPane jp = new JScrollPane(component);
                                        jp.getViewport().setBackground(Color.WHITE);
                                        3.access$200(this.this$1).setRightComponent(jp);
                                    }
                                }
                                catch (RendererException re) {
                                    3.access$000(this.this$1).LOG.error((Object)"Unable to load renderer", (Throwable)re);
                                }
                            }
                        }));
                    }
                    theMenu.add(viewers);
                }
                theMenu.show(structureTree, e.getX(), e.getY());
            }

            static /* synthetic */ ResultItemPanel access$000(3 x0) {
                return x0.ResultItemPanel.this;
            }

            static /* synthetic */ JSplitPane access$200(3 x0) {
                return x0.splitPane;
            }
        });
        this.add((Component)splitPane, "Center");
    }

    static /* synthetic */ ComponentUI access$100(ResultItemPanel x0) {
        return x0.ui;
    }
}

