/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.embl.ebi.escience.scufl.DataConstraint;
import org.embl.ebi.escience.scufl.DataConstraintCreationException;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.ScuflSemanticMarkupEditor;
import org.embl.ebi.escience.scuflui.UIUtils;
import org.embl.ebi.escience.scuflworkers.ProcessorHelper;

public class LinkingMenus {
    public static JPopupMenu linkFrom(Port sourcePort) {
        final Port fromPort = sourcePort;
        final ScuflModel model = sourcePort.getProcessor().getModel();
        JPopupMenu theMenu = new JPopupMenu("Possible targets");
        if (fromPort.getProcessor() == model.getWorkflowSourceProcessor()) {
            JMenuItem delete = new JMenuItem("Remove from model", ScuflIcons.deleteIcon);
            delete.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    fromPort.getProcessor().removePort(fromPort);
                }
            });
            theMenu.add(delete);
            theMenu.addSeparator();
            JMenuItem edit = new JMenuItem("Edit metadata...", ScuflIcons.editIcon);
            edit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    UIUtils.createFrame(model, new ScuflSemanticMarkupEditor(fromPort.getMetadata()), 100, 100, 400, 600);
                }
            });
            theMenu.add(edit);
            theMenu.addSeparator();
        }
        JMenuItem title = new JMenuItem("Link '" + sourcePort.getName() + "' to....");
        title.setEnabled(false);
        theMenu.add(title);
        theMenu.addSeparator();
        JMenu workflowSinks = new JMenu("Workflow outputs");
        workflowSinks.setIcon(ScuflIcons.outputIcon);
        if (fromPort.getProcessor() != model.getWorkflowSourceProcessor()) {
            theMenu.add(workflowSinks);
        }
        Port[] wsp = model.getWorkflowSinkPorts();
        for (int i = 0; i < wsp.length; ++i) {
            JMenuItem wspitem = new JMenuItem(wsp[i].getName(), ScuflIcons.outputIcon);
            final Port toPort = wsp[i];
            wspitem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    try {
                        model.addDataConstraint(new DataConstraint(model, fromPort, toPort));
                    }
                    catch (DataConstraintCreationException dataConstraintCreationException) {
                        // empty catch block
                    }
                }
            });
            workflowSinks.add(wspitem);
        }
        theMenu.addSeparator();
        Processor[] processors = sourcePort.getProcessor().getModel().getProcessors();
        for (int i = 0; i < processors.length; ++i) {
            ImageIcon icon = null;
            icon = ProcessorHelper.getPreferredIcon(processors[i]);
            JMenu processorMenu = new JMenu(processors[i].getName());
            processorMenu.setIcon(icon);
            theMenu.add(processorMenu);
            InputPort[] inputs = processors[i].getInputPorts();
            int offset = 0;
            int menuSize = 15;
            JMenu currentMenu = processorMenu;
            boolean finished = false;
            while (!finished) {
                if (inputs.length > menuSize) {
                    currentMenu = new JMenu("Inputs " + (offset + 1) + " to " + (offset + menuSize > inputs.length ? inputs.length : offset + menuSize));
                    processorMenu.add(currentMenu);
                }
                for (int j = offset; j < inputs.length && j < offset + menuSize; ++j) {
                    final InputPort toPort = inputs[j];
                    JMenuItem ip = new JMenuItem(inputs[j].getName(), ScuflIcons.inputPortIcon);
                    currentMenu.add(ip);
                    ip.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent ae) {
                            try {
                                model.addDataConstraint(new DataConstraint(model, fromPort, toPort));
                            }
                            catch (DataConstraintCreationException dataConstraintCreationException) {
                                // empty catch block
                            }
                        }
                    });
                }
                if ((offset += menuSize) < inputs.length) continue;
                finished = true;
            }
        }
        return theMenu;
    }
}

