/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.embl.ebi.escience.scufl.CrossNode;
import org.embl.ebi.escience.scufl.DotNode;
import org.embl.ebi.escience.scufl.IterationStrategy;
import org.embl.ebi.escience.scufl.LeafNode;
import org.embl.ebi.escience.scuflui.IterationStrategyEditor;
import org.embl.ebi.escience.scuflui.ScuflIcons;

public class IterationStrategyEditorControl
extends JPanel {
    private IterationStrategy strategy;
    private IterationStrategyEditor tree;
    private JButton addCross;
    private JButton addDot;
    private JButton normalize;
    private JButton remove;
    private MutableTreeNode selectedNode = null;

    public IterationStrategyEditorControl(IterationStrategy strategy) {
        this.setLayout(new BoxLayout(this, 3));
        this.strategy = strategy;
        this.tree = new IterationStrategyEditor(strategy);
        this.addCross = new JButton("Add Cross", IterationStrategyEditor.joinIteratorIcon);
        this.addCross.setHorizontalAlignment(2);
        this.addDot = new JButton("Add Dot", IterationStrategyEditor.lockStepIteratorIcon);
        this.addDot.setHorizontalAlignment(2);
        this.normalize = new JButton("Normalize");
        this.normalize.setHorizontalAlignment(2);
        this.remove = new JButton("Remove node", ScuflIcons.deleteIcon);
        this.remove.setHorizontalAlignment(2);
        this.remove.setEnabled(false);
        this.addCross.setEnabled(false);
        this.addDot.setEnabled(false);
        JPanel buttonPanel = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(99999, 40);
            }
        };
        buttonPanel.setLayout(new GridLayout(2, 2));
        buttonPanel.add(this.normalize);
        buttonPanel.add(this.remove);
        buttonPanel.add(this.addCross);
        buttonPanel.add(this.addDot);
        this.normalize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IterationStrategyEditorControl.this.strategy.normalize();
                IterationStrategyEditorControl.this.tree.setAllNodesExpanded();
            }
        });
        this.addDot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DotNode newNode = new DotNode();
                DefaultTreeModel model = (DefaultTreeModel)IterationStrategyEditorControl.this.tree.getModel();
                model.insertNodeInto(newNode, IterationStrategyEditorControl.this.selectedNode, 0);
            }
        });
        this.addCross.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CrossNode newNode = new CrossNode();
                DefaultTreeModel model = (DefaultTreeModel)IterationStrategyEditorControl.this.tree.getModel();
                model.insertNodeInto(newNode, IterationStrategyEditorControl.this.selectedNode, 0);
            }
        });
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode nodeToBeRemoved = (DefaultMutableTreeNode)IterationStrategyEditorControl.this.selectedNode;
                HashSet<TreeNode> nodesToMove = new HashSet<TreeNode>();
                Enumeration<TreeNode> en = ((DefaultMutableTreeNode)IterationStrategyEditorControl.this.selectedNode).depthFirstEnumeration();
                while (en.hasMoreElements()) {
                    TreeNode candidate = en.nextElement();
                    if (!(candidate instanceof LeafNode)) continue;
                    nodesToMove.add(candidate);
                }
                DefaultTreeModel model = (DefaultTreeModel)IterationStrategyEditorControl.this.tree.getModel();
                Iterator i = nodesToMove.iterator();
                while (i.hasNext()) {
                    MutableTreeNode nodeToMove = (MutableTreeNode)i.next();
                    model.removeNodeFromParent(nodeToMove);
                    model.insertNodeInto(nodeToMove, (MutableTreeNode)model.getRoot(), 0);
                }
                model.removeNodeFromParent(nodeToBeRemoved);
                IterationStrategyEditorControl.this.remove.setEnabled(false);
                IterationStrategyEditorControl.this.addCross.setEnabled(false);
                IterationStrategyEditorControl.this.addDot.setEnabled(false);
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreePath selectedPath = e.getPath();
                MutableTreeNode selectedObject = (MutableTreeNode)selectedPath.getLastPathComponent();
                IterationStrategyEditorControl.this.selectedNode = selectedObject;
                if (selectedObject instanceof CrossNode || selectedObject instanceof DotNode) {
                    if (selectedObject.getParent() == null) {
                        IterationStrategyEditorControl.this.remove.setEnabled(false);
                    } else {
                        IterationStrategyEditorControl.this.remove.setEnabled(true);
                    }
                    IterationStrategyEditorControl.this.addCross.setEnabled(true);
                    IterationStrategyEditorControl.this.addDot.setEnabled(true);
                } else {
                    IterationStrategyEditorControl.this.remove.setEnabled(false);
                    IterationStrategyEditorControl.this.addCross.setEnabled(false);
                    IterationStrategyEditorControl.this.addDot.setEnabled(false);
                }
            }
        });
        this.add(buttonPanel);
        JScrollPane treePane = new JScrollPane(this.tree);
        treePane.setPreferredSize(new Dimension(0, 0));
        this.add(treePane);
    }
}

