/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.scuflui.FTableColumn;
import org.embl.ebi.escience.scuflui.FTableColumnModel;
import org.embl.ebi.escience.scuflui.FTableColumnModelEvent;
import org.embl.ebi.escience.scuflui.FTableColumnModelListener;
import org.embl.ebi.escience.scuflui.facets.FacetFinderRegistry;
import org.embl.ebi.escience.scuflui.facets.FacetFinderSPI;
import org.embl.ebi.escience.scuflui.renderers.RendererRegistry;
import org.embl.ebi.escience.scuflui.renderers.RendererSPI;

public class FacetsTable
extends JPanel {
    private static final Logger LOG;
    private static final int H_PAD = 2;
    private static final int V_PAD = 2;
    private final List headings;
    private final List columns;
    private int headingHeight;
    private int[] rowHeights;
    boolean isInScrollPane = false;
    private JComponent columnHeaders;
    private JComponent table;
    private final FTableColumnModelListener nsync;
    private FTableColumnModel columnModel;
    private DataThing dataThing;
    private FacetFinderRegistry finders;
    private RendererRegistry renderers;
    private int rows;
    private transient DataThing exampleThing;
    private transient List exampleRow;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void invariant() {
        if (!$assertionsDisabled && this.headings.size() != this.columns.size()) {
            throw new AssertionError((Object)("Must have the same headings and columns in the table: " + this.headings.size() + ":" + this.columns.size()));
        }
        if (!$assertionsDisabled && this.headings.size() != this.columnModel.getColumnCount()) {
            throw new AssertionError((Object)("Must have the same headings as columns in the model" + this.headings.size() + ":" + this.columnModel.getColumnCount()));
        }
        if (!$assertionsDisabled && this.exampleRow != null && this.exampleRow.size() != this.headings.size()) {
            throw new AssertionError((Object)("Must have the right number of examples" + this.exampleRow.size() + ":" + this.headings.size()));
        }
    }

    public FacetsTable() {
        super(new BorderLayout(), true);
        this.addHierarchyListener(new ScrollPaneChanger());
        this.nsync = new NSynch();
        this.headings = new ArrayList();
        this.columns = new ArrayList();
        this.columnModel = new FTableColumnModel();
        this.finders = FacetFinderRegistry.instance();
        this.renderers = RendererRegistry.instance();
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.resizeAndValidate();
    }

    public FacetsTable(DataThing theDataThing, FacetFinderRegistry finders, RendererRegistry renderers, FTableColumnModel columnModel) {
        this();
        this.dataThing = theDataThing;
        if (finders != null) {
            this.finders = finders;
        }
        if (renderers != null) {
            this.renderers = renderers;
        }
        if (columnModel != null) {
            this.setColumnModel(columnModel);
        }
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.resizeAndValidate();
    }

    public FacetsTable(DataThing theDataThing, FacetFinderRegistry finders, RendererRegistry renderers) {
        this(theDataThing, finders, renderers, null);
    }

    public FTableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public void setColumnModel(FTableColumnModel columnModel) {
        if (this.columnModel != null) {
            this.columnModel.removeFTableColumnModelListener(this.nsync);
        }
        this.columnModel = columnModel;
        this.columnModel.addFTableColumnModelListener(this.nsync);
        this.resizeAndValidate();
    }

    public DataThing getDataThing() {
        return this.dataThing;
    }

    public void setDataThing(DataThing dataThing) {
        this.dataThing = dataThing;
        this.resizeAndValidate();
    }

    public FacetFinderRegistry getFinders() {
        return this.finders;
    }

    public void setFinders(FacetFinderRegistry finders) {
        if (finders == null) {
            throw new NullPointerException("Can't set finder registry to null");
        }
        this.finders = finders;
    }

    public RendererRegistry getRenderers() {
        return this.renderers;
    }

    public void setRenderers(RendererRegistry renderers) {
        if (renderers == null) {
            throw new NullPointerException("Can't set renderer registry to null");
        }
        this.renderers = renderers;
    }

    protected void configureScrolling() {
        this.removeAll();
        if (this.isInScrollPane) {
            this.add((Component)this.table, "Center");
            JScrollPane pane = (JScrollPane)this.getParent().getParent();
            pane.getViewport().setBackground(Color.WHITE);
            pane.setViewportView(this);
            pane.setColumnHeaderView(this.columnHeaders);
        } else {
            this.add((Component)this.columnHeaders, "North");
            this.add((Component)this.table, "Center");
        }
    }

    private Iterator makeRowIterator() {
        Iterator<DataThing> rowIt = null;
        if (this.dataThing == null) {
            rowIt = Collections.EMPTY_LIST.iterator();
            this.rows = 0;
        } else if (this.dataThing.getDataObject() instanceof Collection) {
            rowIt = this.dataThing.childIterator();
            this.rows = ((Collection)this.dataThing.getDataObject()).size();
        } else {
            rowIt = Collections.singleton(this.dataThing).iterator();
            this.rows = 1;
        }
        return rowIt;
    }

    protected void resizeAndValidate() {
        LOG.info((Object)("resizeAndValidate: redoing layout: " + this.dataThing));
        this.headings.clear();
        this.columns.clear();
        this.exampleThing = null;
        this.exampleRow = null;
        this.columnHeaders = new JPanel(null);
        this.table = new JPanel(null);
        this.table.setBackground(Color.WHITE);
        Iterator ci = this.columnModel.columnIterator();
        while (ci.hasNext()) {
            FTableColumn column = (FTableColumn)ci.next();
            JComponent heading = this.makeHeading(column);
            LOG.info((Object)("heading dimensions: " + heading.getPreferredSize()));
            this.headings.add(new Header(heading, (int)heading.getPreferredSize().getWidth()));
            this.columns.add(new ArrayList());
            this.columnHeaders.add(heading);
        }
        LOG.info((Object)"resizeAndValidate: adding all data rows");
        Iterator rowIt = this.makeRowIterator();
        this.rowHeights = new int[this.rows];
        for (int r = 0; r < this.rows; ++r) {
            DataThing part = (DataThing)rowIt.next();
            ArrayList<DataThing> ex = null;
            if (this.exampleRow == null) {
                ex = new ArrayList<DataThing>();
            }
            if (this.exampleThing == null) {
                this.exampleThing = part;
            }
            for (int c = 0; c < this.columnModel.getColumnCount(); ++c) {
                FTableColumn ftCol = this.columnModel.getColumn(c);
                List col = (List)this.columns.get(c);
                DataThing dataObj = ftCol.getFinder().getFacet(part, ftCol.getColID());
                if (ex != null) {
                    ex.add(dataObj);
                }
                JComponent cmp = this.makeCell(dataObj, ftCol);
                LOG.info((Object)("cell size: " + cmp.getPreferredSize()));
                col.add(cmp);
                this.table.add(cmp);
            }
            if (ex == null) continue;
            this.exampleRow = ex;
        }
        this.redoGeometry();
        this.redoLayout();
        this.configureScrolling();
        LOG.info((Object)"resizeAndValidate: done");
    }

    private void redoGeometry() {
        int i;
        this.invariant();
        for (i = 0; i < this.rowHeights.length; ++i) {
            this.rowHeights[i] = 0;
        }
        this.headingHeight = 0;
        LOG.info((Object)("rows: " + this.rowHeights.length));
        LOG.info((Object)("columns: " + this.columnModel.getColumnCount()));
        for (i = 0; i < this.columnModel.getColumnCount(); ++i) {
            Header header = (Header)this.headings.get(i);
            List column = (List)this.columns.get(i);
            if (!$assertionsDisabled && column.size() != this.rowHeights.length) {
                throw new AssertionError((Object)"Row heights should match column size");
            }
            Dimension hd = header.heading.getPreferredSize();
            this.headingHeight = (int)Math.max((double)this.headingHeight, hd.getHeight());
            header.width = (int)hd.getWidth();
            for (int r = 0; r < column.size(); ++r) {
                JComponent cell = (JComponent)column.get(r);
                Dimension dim = cell.getPreferredSize();
                header.width = (int)Math.max((double)header.width, dim.getWidth());
                this.rowHeights[r] = (int)Math.max((double)this.rowHeights[r], dim.getHeight());
            }
        }
    }

    private void redoLayout() {
        this.invariant();
        int xPos = 2;
        int yPos = 2;
        for (int i = 0; i < this.headings.size(); ++i) {
            Header header = (Header)this.headings.get(i);
            Component cmp = header.heading;
            cmp.setSize(header.width, this.headingHeight);
            cmp.setLocation(xPos, 0);
            List col = (List)this.columns.get(i);
            if (!$assertionsDisabled && col.size() != this.rowHeights.length) {
                throw new AssertionError((Object)"Row heights should match column size");
            }
            yPos = 0;
            for (int r = 0; r < col.size(); ++r) {
                Component cell = (Component)col.get(r);
                int height = this.rowHeights[r];
                cell.setSize(header.width, height);
                cell.setLocation(xPos, yPos);
                yPos += height + 2;
            }
            xPos += header.width + 2;
        }
        Dimension headersSize = new Dimension(xPos, this.headingHeight);
        this.columnHeaders.setMinimumSize(headersSize);
        this.columnHeaders.setPreferredSize(headersSize);
        this.columnHeaders.setMaximumSize(headersSize);
        this.columnHeaders.setSize(headersSize);
        Dimension tableSize = new Dimension(xPos, yPos);
        this.table.setMinimumSize(tableSize);
        this.table.setPreferredSize(tableSize);
        this.table.setMaximumSize(tableSize);
        this.table.setSize(tableSize);
        LOG.info((Object)("set table dims to " + tableSize));
        this.validate();
        LOG.info((Object)("table size is now " + this.table.getSize()));
    }

    private JComponent makeHeading(FTableColumn col) {
        JLabel heading = new JLabel(col.getName());
        heading.addMouseListener(new ColumnListener(col, heading));
        return heading;
    }

    private JComponent makeCell(DataThing dataObj, FTableColumn ftCol) {
        JComponent cmp = null;
        if (dataObj != null) {
            RendererSPI renderer = ftCol.getRenderer();
            if (renderer != null) {
                try {
                    cmp = renderer.getComponent(this.renderers, dataObj);
                }
                catch (Exception e) {
                    LOG.error((Object)"Problem creating component from renderer", (Throwable)e);
                }
            }
            if (cmp == null) {
                Iterator ri = this.renderers.getRenderers(dataObj).iterator();
                while (cmp == null && ri.hasNext()) {
                    renderer = (RendererSPI)ri.next();
                    if (!renderer.isTerminal()) continue;
                    try {
                        cmp = renderer.getComponent(this.renderers, dataObj);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Problem creating component from renderer", (Throwable)e);
                    }
                }
            }
        }
        if (cmp == null) {
            cmp = new JLabel("No Renderer");
        }
        return cmp;
    }

    static {
        $assertionsDisabled = !FacetsTable.class.desiredAssertionStatus();
        LOG = Logger.getLogger((Class)FacetsTable.class);
    }

    private class NSynch
    implements FTableColumnModelListener {
        private NSynch() {
        }

        public void columnAdded(FTableColumnModelEvent evt) {
            int indx = evt.getToIndex();
            FTableColumn col = FacetsTable.this.columnModel.getColumn(indx);
            Header header = new Header(FacetsTable.this.makeHeading(col));
            FacetsTable.this.headings.add(indx, header);
            ArrayList<JComponent> components = new ArrayList<JComponent>();
            boolean first = true;
            Iterator rowIt = FacetsTable.this.makeRowIterator();
            while (rowIt.hasNext()) {
                DataThing item = (DataThing)rowIt.next();
                DataThing dt = col.getFinder().getFacet(item, col.getColID());
                if (first) {
                    FacetsTable.this.exampleRow.add(indx, dt);
                    first = false;
                }
                JComponent cell = FacetsTable.this.makeCell(dt, col);
                components.add(cell);
                FacetsTable.this.table.add(cell);
            }
            FacetsTable.this.columnHeaders.add(header.heading);
            FacetsTable.this.columns.add(indx, components);
            FacetsTable.this.redoGeometry();
            FacetsTable.this.redoLayout();
        }

        public void columnRemoved(FTableColumnModelEvent evt) {
            int indx = evt.getFromIndex();
            Header header = (Header)FacetsTable.this.headings.remove(indx);
            FacetsTable.this.columnHeaders.remove(header.heading);
            List column = (List)FacetsTable.this.columns.get(indx);
            Iterator i = column.iterator();
            while (i.hasNext()) {
                Component cmp = (Component)i.next();
                FacetsTable.this.table.remove(cmp);
            }
            FacetsTable.this.columns.remove(indx);
            if (FacetsTable.this.exampleRow != null) {
                FacetsTable.this.exampleRow.remove(indx);
            }
            FacetsTable.this.redoGeometry();
            FacetsTable.this.redoLayout();
        }

        public void columnMoved(FTableColumnModelEvent evt) {
            int from = evt.getFromIndex();
            int to = evt.getToIndex();
            FacetsTable.this.headings.add(to, FacetsTable.this.headings.remove(from));
            FacetsTable.this.columns.add(to, FacetsTable.this.columns.remove(from));
            if (FacetsTable.this.exampleRow != null) {
                FacetsTable.this.exampleRow.add(to, FacetsTable.this.exampleRow.remove(from));
            }
            FacetsTable.this.redoGeometry();
            FacetsTable.this.redoLayout();
        }

        public void columnChanged(FTableColumnModelEvent evt) {
            int indx = evt.getToIndex();
            FTableColumn col = FacetsTable.this.columnModel.getColumn(indx);
            PropertyChangeEvent cause = evt.getCause();
            LOG.info((Object)("change: " + cause.getPropertyName()));
            if ("name".equals(cause.getPropertyName())) {
                Header header = (Header)FacetsTable.this.headings.remove(indx);
                FacetsTable.this.columnHeaders.remove(header.heading);
                JComponent heading = FacetsTable.this.makeHeading(FacetsTable.this.columnModel.getColumn(indx));
                Header newHeader = new Header(heading);
                FacetsTable.this.headings.add(indx, newHeader);
                FacetsTable.this.columnHeaders.add(newHeader.heading);
                FacetsTable.this.redoGeometry();
                FacetsTable.this.redoLayout();
            } else {
                List column = (List)FacetsTable.this.columns.get(indx);
                Iterator i = column.iterator();
                while (i.hasNext()) {
                    Component cmp = (Component)i.next();
                    FacetsTable.this.table.remove(cmp);
                }
                if (FacetsTable.this.exampleRow != null) {
                    FacetsTable.this.exampleRow.remove(indx);
                }
                column.clear();
                boolean fixExampleRow = FacetsTable.this.exampleRow != null;
                Iterator rowIt = FacetsTable.this.makeRowIterator();
                while (rowIt.hasNext()) {
                    DataThing item = (DataThing)rowIt.next();
                    DataThing dt = col.getFinder().getFacet(item, col.getColID());
                    if (fixExampleRow) {
                        FacetsTable.this.exampleRow.add(indx, dt);
                        fixExampleRow = false;
                    }
                    JComponent cell = FacetsTable.this.makeCell(dt, col);
                    column.add(cell);
                    FacetsTable.this.table.add(cell);
                }
                FacetsTable.this.redoGeometry();
                FacetsTable.this.redoLayout();
            }
        }
    }

    private class ScrollPaneChanger
    implements HierarchyListener {
        boolean active = false;

        private ScrollPaneChanger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void hierarchyChanged(HierarchyEvent e) {
            if (!this.active) {
                try {
                    this.active = true;
                    if (e.getChangeFlags() == 1L && e.getComponent() == FacetsTable.this) {
                        boolean inSP = false;
                        Container p = FacetsTable.this.getParent();
                        if (p != null) {
                            p = p.getParent();
                        }
                        if (p instanceof JScrollPane) {
                            inSP = true;
                        }
                        if (inSP != FacetsTable.this.isInScrollPane) {
                            FacetsTable.this.isInScrollPane = inSP;
                            FacetsTable.this.configureScrolling();
                        }
                    }
                }
                finally {
                    this.active = false;
                }
            }
        }
    }

    private static final class Header {
        public int width;
        public Component heading;

        public Header(Component heading) {
            this(heading, 0);
        }

        public Header(Component heading, int width) {
            this.heading = heading;
            this.width = width;
        }
    }

    private class ColumnListener
    implements MouseListener {
        private final FTableColumn col;
        private final JComponent owner;

        public ColumnListener(FTableColumn col, JComponent owner) {
            this.col = col;
            this.owner = owner;
        }

        private DataThing getCurrent() {
            if (FacetsTable.this.exampleRow == null) {
                return null;
            }
            FacetsTable.this.invariant();
            return (DataThing)FacetsTable.this.exampleRow.get(FacetsTable.this.columnModel.getColumnIndex(this.col));
        }

        public void mouseClicked(MouseEvent e) {
            this.process(e);
        }

        public void mousePressed(MouseEvent e) {
            this.process(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.process(e);
        }

        public void mouseEntered(MouseEvent e) {
            this.process(e);
        }

        public void mouseExited(MouseEvent e) {
            this.process(e);
        }

        private void process(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JPopupMenu popup = new JPopupMenu("Edit Column " + this.col.getName());
                JMenuItem changeName = new JMenuItem(new RenameColumn());
                popup.add(changeName);
                JMenu view = new JMenu("View");
                this.populateView(view);
                popup.add(view);
                JMenuItem edit = new JMenuItem(new EditColumn());
                popup.add(edit);
                JMenu add = new JMenu("add");
                this.populateAdd(add);
                popup.add(add);
                JMenuItem remove = new JMenuItem(new RemoveColumn());
                popup.add(remove);
                popup.show(this.owner, e.getX(), e.getY());
            }
        }

        private void populateAdd(JMenu add) {
            Iterator i = FacetsTable.this.finders.getFinders(FacetsTable.this.exampleThing).iterator();
            while (i.hasNext()) {
                final FacetFinderSPI spi = (FacetFinderSPI)i.next();
                DataThing current = this.getCurrent();
                ArrayList<FacetFinderSPI.ColumnID> possibles = new ArrayList<FacetFinderSPI.ColumnID>();
                possibles.add(spi.newColumn(current));
                possibles.addAll(spi.getStandardColumns(current));
                Iterator pi = possibles.iterator();
                while (pi.hasNext()) {
                    final FacetFinderSPI.ColumnID column = (FacetFinderSPI.ColumnID)pi.next();
                    if (column == null) continue;
                    JMenuItem item = new JMenuItem(new AbstractAction(column.getName()){

                        public void actionPerformed(ActionEvent e) {
                            FacetsTable.this.columnModel.addColumn(new FTableColumn(column.getName(), spi, null, column, true, true));
                        }
                    });
                    add.add(item);
                }
            }
        }

        private void populateView(JMenu view) {
            DataThing current = this.getCurrent();
            Iterator i = FacetsTable.this.renderers.getRenderers(current).iterator();
            while (i.hasNext()) {
                RendererSPI renderer = (RendererSPI)i.next();
                JMenuItem choser = new JMenuItem(new AbstractAction(this, renderer.getName(), renderer.getIcon(FacetsTable.this.renderers, current), renderer){
                    private final /* synthetic */ RendererSPI val$renderer;
                    private final /* synthetic */ ColumnListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$renderer = val$renderer;
                        super(x0, x1);
                    }

                    public void actionPerformed(ActionEvent e) {
                        ColumnListener.access$900(this.this$1).setRenderer(this.val$renderer);
                    }
                });
                view.add(choser);
            }
        }

        private class RenameColumn
        extends AbstractAction {
            public RenameColumn() {
                super("rename");
            }

            public void actionPerformed(ActionEvent e) {
                String newName = JOptionPane.showInputDialog("New name", (Object)ColumnListener.this.col.getName());
                ColumnListener.this.col.setName(newName);
            }
        }

        private class EditColumn
        extends AbstractAction {
            public EditColumn() {
                super("edit");
            }

            public void actionPerformed(ActionEvent e) {
                DataThing current = FacetsTable.this.exampleThing;
                Component editor = ColumnListener.this.col.getColID().getCustomiser(current);
                if (editor == null) {
                    LOG.info((Object)("No editor for " + ColumnListener.this.col.getColID()));
                    return;
                }
                for (Container owner = FacetsTable.this; !(owner instanceof Frame) && !(owner instanceof Dialog) && owner != null; owner = owner.getParent()) {
                }
                JOptionPane.showMessageDialog(FacetsTable.this, editor, "Configure " + ColumnListener.this.col.getName(), -1);
            }
        }

        private class RemoveColumn
        extends AbstractAction {
            public RemoveColumn() {
                super("remove");
            }

            public void actionPerformed(ActionEvent e) {
                FacetsTable.this.getColumnModel().removeColumn(ColumnListener.this.col);
            }
        }
    }
}

