/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.scuflui.FTableColumn;
import org.embl.ebi.escience.scuflui.FTableColumnModelEvent;
import org.embl.ebi.escience.scuflui.FTableColumnModelListener;

public class FTableColumnModel {
    private static final Logger LOG = Logger.getLogger((Class)FTableColumnModel.class);
    private final List listeners = new ArrayList();
    private final PropertyChangeListener changeForwarder = new ChangeForwarder();
    private final List columns = new ArrayList();

    public void addColumn(FTableColumn col) {
        this.columns.add(col);
        col.addPropertyChangeListener(this.changeForwarder);
        this.fireColumnAdded(this.columns.size() - 1);
    }

    public void addColumn(int to, FTableColumn col) {
        this.columns.add(to, col);
        col.addPropertyChangeListener(this.changeForwarder);
        this.fireColumnAdded(to);
    }

    public void removeColumn(FTableColumn col) {
        col.removePropertyChangeListener(this.changeForwarder);
        int from = this.columns.indexOf(col);
        this.columns.remove(col);
        this.fireColumnRemoved(from);
    }

    public void removeColumn(int indx) {
        this.columns.remove(indx);
        this.fireColumnRemoved(indx);
    }

    public void moveColumn(int from, int to) {
        FTableColumn col = (FTableColumn)this.columns.remove(from);
        this.columns.add(to, col);
        this.fireColumnMoved(from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFTableColumnModelListener(FTableColumnModelListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFTableColumnModelListener(FTableColumnModelListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public Iterator columnIterator() {
        return this.columns.iterator();
    }

    public FTableColumn getColumn(int indx) {
        return (FTableColumn)this.columns.get(indx);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getColumnIndex(FTableColumn col) {
        return this.columns.indexOf(col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireColumnAdded(int to) {
        ArrayList local;
        FTableColumnModelEvent evt = new FTableColumnModelEvent(this, -1, to, null);
        List list = this.listeners;
        synchronized (list) {
            local = new ArrayList(this.listeners);
        }
        Iterator i = local.iterator();
        while (i.hasNext()) {
            FTableColumnModelListener l = (FTableColumnModelListener)i.next();
            l.columnAdded(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireColumnRemoved(int from) {
        ArrayList local;
        FTableColumnModelEvent evt = new FTableColumnModelEvent(this, from, -1, null);
        List list = this.listeners;
        synchronized (list) {
            local = new ArrayList(this.listeners);
        }
        Iterator i = local.iterator();
        while (i.hasNext()) {
            FTableColumnModelListener l = (FTableColumnModelListener)i.next();
            l.columnRemoved(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireColumnMoved(int from, int to) {
        ArrayList local;
        FTableColumnModelEvent evt = new FTableColumnModelEvent(this, from, to, null);
        List list = this.listeners;
        synchronized (list) {
            local = new ArrayList(this.listeners);
        }
        Iterator i = local.iterator();
        while (i.hasNext()) {
            FTableColumnModelListener l = (FTableColumnModelListener)i.next();
            l.columnMoved(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireColumnChanged(PropertyChangeEvent pce) {
        ArrayList local;
        FTableColumnModelEvent evt = new FTableColumnModelEvent(this, -1, this.columns.indexOf(pce.getSource()), pce);
        LOG.info((Object)("PCE: " + evt));
        if (evt.getToIndex() == -1) {
            LOG.info((Object)"The source object may be wrong");
        }
        List list = this.listeners;
        synchronized (list) {
            local = new ArrayList(this.listeners);
        }
        Iterator i = local.iterator();
        while (i.hasNext()) {
            FTableColumnModelListener l = (FTableColumnModelListener)i.next();
            l.columnChanged(evt);
        }
    }

    private class ChangeForwarder
    implements PropertyChangeListener {
        private ChangeForwarder() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            FTableColumnModel.this.fireColumnChanged(evt);
        }
    }
}

