/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.baclava.factory.DataThingFactory;
import org.embl.ebi.escience.baclava.factory.DataThingXMLFactory;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.ScuflModelEventListener;
import org.embl.ebi.escience.scufl.enactor.EnactorProxy;
import org.embl.ebi.escience.scufl.enactor.implementation.FreefluoEnactorProxy;
import org.embl.ebi.escience.scuflui.EnactorInvocation;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;
import org.embl.ebi.escience.scuflui.UIUtils;
import org.embl.ebi.escience.scuflui.WorkflowInputPanel;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class EnactorLaunchPanel
extends JPanel
implements ScuflModelEventListener,
ScuflUIComponent {
    private static EnactorProxy defaultEnactor = new FreefluoEnactorProxy();
    ScuflModel model = null;
    private JPanel inputPanel = null;
    private Map currentInputs = new HashMap();

    public EnactorLaunchPanel() {
        super(new BorderLayout());
        this.inputPanel = new JPanel();
        this.inputPanel.setLayout(new BoxLayout(this.inputPanel, 3));
        this.add((Component)this.inputPanel, "North");
        final JTextArea xmlText = new JTextArea();
        JScrollPane xmlPane = new JScrollPane(xmlText);
        xmlPane.setPreferredSize(new Dimension(100, 100));
        JPanel xmlPanel = new JPanel(new BorderLayout());
        xmlPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Preview input.xml and run"));
        xmlPanel.add((Component)xmlPane, "Center");
        JPanel actionPanel = new JPanel();
        actionPanel.setLayout(new BoxLayout(actionPanel, 3));
        xmlPanel.add((Component)actionPanel, "East");
        JButton xmlRefresh = new JButton(ScuflIcons.refreshIcon);
        xmlRefresh.setPreferredSize(new Dimension(32, 32));
        actionPanel.add(xmlRefresh);
        xmlRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                XMLOutputter xo = new XMLOutputter(Format.getPrettyFormat());
                xmlText.setText(xo.outputString(EnactorLaunchPanel.this.getInputDocument()));
            }
        });
        this.add((Component)xmlPanel, "Center");
        JButton runButton = new JButton(ScuflIcons.runIcon);
        actionPanel.add(runButton);
        runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Map inputObject = EnactorLaunchPanel.this.getDataThingMap();
                System.out.println("Created the Input object.." + inputObject.toString());
                try {
                    UIUtils.createFrame(EnactorLaunchPanel.this.model, new EnactorInvocation(FreefluoEnactorProxy.getInstance(), EnactorLaunchPanel.this.model, inputObject), 100, 100, 600, 400);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        runButton.setPreferredSize(new Dimension(32, 32));
        this.setVisible(true);
    }

    public String getName() {
        return "Enactor launch";
    }

    public boolean modelHasChanged() {
        if (this.model == null) {
            return false;
        }
        Port[] inputs = this.model.getWorkflowSourcePorts();
        int numberOfInputs = inputs.length;
        if (numberOfInputs != this.currentInputs.size()) {
            return true;
        }
        for (int i = 0; i < inputs.length; ++i) {
            String portName = inputs[i].getName();
            if (this.currentInputs.containsKey(portName)) continue;
            return true;
        }
        return false;
    }

    public synchronized void updatePanel() {
        WorkflowInputPanel wip;
        String key;
        if (!this.modelHasChanged()) {
            return;
        }
        Port[] inputs = this.model.getWorkflowSourcePorts();
        HashMap<String, Port> inputMap = new HashMap<String, Port>();
        for (int i = 0; i < inputs.length; ++i) {
            inputMap.put(inputs[i].getName(), inputs[i]);
        }
        Iterator i = this.currentInputs.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            if (inputMap.containsKey(key)) continue;
            wip = (WorkflowInputPanel)this.currentInputs.get(key);
            this.inputPanel.remove(wip);
            this.currentInputs.remove(key);
        }
        i = inputMap.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            if (this.currentInputs.containsKey(key)) continue;
            wip = new WorkflowInputPanel((Port)inputMap.get(key));
            this.currentInputs.put(key, wip);
            this.inputPanel.add(wip);
        }
    }

    public void attachToModel(ScuflModel model) {
        if (this.model == null) {
            this.model = model;
            model.addListener(this);
            this.updatePanel();
        }
    }

    public void detachFromModel() {
        if (this.model != null) {
            this.model.removeListener(this);
            this.model = null;
        }
    }

    public Document getInputDocument() {
        HashMap<String, DataThing> dataThings = new HashMap<String, DataThing>();
        Iterator i = this.currentInputs.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            WorkflowInputPanel wip = (WorkflowInputPanel)this.currentInputs.get(key);
            dataThings.put(wip.getPort().getName(), DataThingFactory.bake(wip.getText()));
        }
        return DataThingXMLFactory.getDataDocument(dataThings);
    }

    public Map getDataThingMap() {
        HashMap<String, DataThing> dataThings = new HashMap<String, DataThing>();
        Iterator i = this.currentInputs.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            WorkflowInputPanel wip = (WorkflowInputPanel)this.currentInputs.get(key);
            dataThings.put(wip.getPort().getName(), DataThingFactory.bake(wip.getText()));
        }
        return dataThings;
    }

    public void receiveModelEvent(ScuflModelEvent sme) {
        this.updatePanel();
    }

    public ImageIcon getIcon() {
        return ScuflIcons.windowInput;
    }
}

