/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scuflui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.baclava.LSIDProvider;
import org.embl.ebi.escience.scufl.IterationStrategy;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.ScuflModelEventListener;
import org.embl.ebi.escience.scufl.SemanticMarkup;
import org.embl.ebi.escience.scufl.SetOnlineException;
import org.embl.ebi.escience.scufl.WorkflowDescription;
import org.embl.ebi.escience.scufl.parser.XScuflParser;
import org.embl.ebi.escience.scufl.view.WorkflowSummaryAsHTML;
import org.embl.ebi.escience.scufl.view.XScuflView;
import org.embl.ebi.escience.scuflui.ExtensionFileFilter;
import org.embl.ebi.escience.scuflui.IterationStrategyEditorControl;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.ScuflModelTreeTable;
import org.embl.ebi.escience.scuflui.ScuflSemanticMarkupEditor;
import org.embl.ebi.escience.scuflui.ScuflUIComponent;
import org.embl.ebi.escience.scuflworkers.ProcessorHelper;
import org.embl.ebi.escience.scuflworkers.workflow.WorkflowProcessor;

public class AdvancedModelExplorer
extends JPanel
implements ScuflUIComponent {
    private ScuflModelTreeTable explorer;
    private JTabbedPane tabs;
    private JPanel propertiesPanel;
    private Object selectedObject = null;
    private ScuflModel model;
    private JButton loadWorkflow;
    private JButton loadFromWeb;
    private JButton saveWorkflow;
    private JButton resetWorkflow;
    private JButton createNested;
    protected JCheckBox workOffline;
    final JFileChooser fc = new JFileChooser();
    private ScuflModelEventListener listener = null;
    static /* synthetic */ Class class$org$embl$ebi$escience$scuflui$ScuflIcons;
    static /* synthetic */ Class class$org$embl$ebi$escience$scuflui$AdvancedModelExplorer;

    public AdvancedModelExplorer() {
        this.setLayout(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.explorer = new ScuflModelTreeTable();
        JScrollPane explorerPane = new JScrollPane(this.explorer);
        explorerPane.setPreferredSize(new Dimension(0, 0));
        explorerPane.getViewport().setBackground(Color.WHITE);
        JPanel workflowPanel = new JPanel();
        workflowPanel.setLayout(new BorderLayout());
        workflowPanel.add((Component)explorerPane, "Center");
        this.tabs.add("Workflow", workflowPanel);
        this.propertiesPanel = new JPanel();
        this.tabs.add("Object properties", this.propertiesPanel);
        this.tabs.setEnabledAt(1, false);
        this.add((Component)this.tabs, "Center");
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.setMaximumSize(new Dimension(2000, 30));
        toolbar.setBorderPainted(true);
        this.loadWorkflow = new JButton(ScuflIcons.openIcon);
        this.loadWorkflow.setPreferredSize(new Dimension(25, 25));
        this.loadFromWeb = new JButton(ScuflIcons.openurlIcon);
        this.loadFromWeb.setPreferredSize(new Dimension(25, 25));
        this.saveWorkflow = new JButton(ScuflIcons.saveIcon);
        this.saveWorkflow.setPreferredSize(new Dimension(25, 25));
        this.resetWorkflow = new JButton(ScuflIcons.deleteIcon);
        this.resetWorkflow.setPreferredSize(new Dimension(25, 25));
        this.createNested = new JButton(ScuflIcons.windowExplorer);
        this.createNested.setPreferredSize(new Dimension(25, 25));
        this.workOffline = new JCheckBox("Offline");
        this.workOffline.setSelected(false);
        this.workOffline.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ItemSelectable source = e.getItemSelectable();
                if (source == AdvancedModelExplorer.this.workOffline) {
                    try {
                        if (e.getStateChange() == 2) {
                            AdvancedModelExplorer.this.model.setOffline(false);
                        } else {
                            AdvancedModelExplorer.this.model.setOffline(true);
                        }
                    }
                    catch (SetOnlineException soe) {
                        Throwable cause = soe.getCause();
                        JOptionPane.showMessageDialog(AdvancedModelExplorer.this, "Unable to go online, correct the following errors before retrying - workflow has been set to offline mode :\n\n" + cause.getMessage(), "Error going online", 0);
                    }
                }
            }
        });
        toolbar.add(new JLabel(" Load "));
        toolbar.add(this.loadWorkflow);
        toolbar.addSeparator();
        toolbar.add(new JLabel("Load from web "));
        toolbar.add(this.loadFromWeb);
        toolbar.addSeparator();
        toolbar.add(new JLabel("Save "));
        toolbar.add(this.saveWorkflow);
        toolbar.addSeparator();
        toolbar.add(new JLabel("New subworkflow"));
        toolbar.add(this.createNested);
        toolbar.addSeparator();
        toolbar.add(this.workOffline);
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(new JLabel("Reset "));
        toolbar.add(this.resetWorkflow);
        workflowPanel.add((Component)toolbar, "First");
        this.createNested.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ScuflModel targetModel = ((AdvancedModelExplorer)AdvancedModelExplorer.this).explorer.model;
                if (targetModel != null) {
                    try {
                        String name = targetModel.getValidProcessorName("NestedWorkflow");
                        WorkflowProcessor p = new WorkflowProcessor(targetModel, name);
                        targetModel.addProcessor(p);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(AdvancedModelExplorer.this, "Unable to create blank subworkflow : \n" + ex.getMessage(), "Error", 0);
                    }
                }
            }
        });
        this.loadWorkflow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Preferences prefs = Preferences.userNodeForPackage(class$org$embl$ebi$escience$scuflui$ScuflIcons == null ? (class$org$embl$ebi$escience$scuflui$ScuflIcons = AdvancedModelExplorer.class$("org.embl.ebi.escience.scuflui.ScuflIcons")) : class$org$embl$ebi$escience$scuflui$ScuflIcons);
                String curDir = prefs.get("currentDir", System.getProperty("user.home"));
                AdvancedModelExplorer.this.fc.resetChoosableFileFilters();
                AdvancedModelExplorer.this.fc.setFileFilter(new ExtensionFileFilter(new String[]{"xml"}));
                AdvancedModelExplorer.this.fc.setCurrentDirectory(new File(curDir));
                int returnVal = AdvancedModelExplorer.this.fc.showOpenDialog(AdvancedModelExplorer.this);
                if (returnVal == 0) {
                    prefs.put("currentDir", AdvancedModelExplorer.this.fc.getCurrentDirectory().toString());
                    File file = AdvancedModelExplorer.this.fc.getSelectedFile();
                    new Thread(new Runnable(this, file){
                        private final /* synthetic */ File val$file;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$file = val$file;
                        }

                        public void run() {
                            try {
                                XScuflParser.populate(this.val$file.toURL().openStream(), AdvancedModelExplorer.access$100((AdvancedModelExplorer)3.access$200(this.this$1)).model, null);
                            }
                            catch (Exception ex) {
                                JOptionPane.showMessageDialog(3.access$200(this.this$1), "Problem opening workflow from file : \n\n" + ex.getMessage() + "\n\nTo load this workflow try setting offline mode, this will allow you to load and remove any defunct operations.", "Error", 0);
                            }
                        }
                    }).start();
                }
            }

            static /* synthetic */ AdvancedModelExplorer access$200(3 x0) {
                return x0.AdvancedModelExplorer.this;
            }
        });
        this.loadFromWeb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    String name = (String)JOptionPane.showInputDialog(AdvancedModelExplorer.this, "URL of an workflow definition to open?", "URL Required", 3, null, null, "http://");
                    if (name != null) {
                        XScuflParser.populate(new URL(name).openStream(), ((AdvancedModelExplorer)AdvancedModelExplorer.this).explorer.model, null);
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(AdvancedModelExplorer.this, "Problem opening workflow from web : \n" + ex.getMessage(), "Error!", 0);
                }
            }
        });
        this.saveWorkflow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Preferences prefs = Preferences.userNodeForPackage(class$org$embl$ebi$escience$scuflui$AdvancedModelExplorer == null ? (class$org$embl$ebi$escience$scuflui$AdvancedModelExplorer = AdvancedModelExplorer.class$("org.embl.ebi.escience.scuflui.AdvancedModelExplorer")) : class$org$embl$ebi$escience$scuflui$AdvancedModelExplorer);
                    String curDir = prefs.get("currentDir", System.getProperty("user.home"));
                    AdvancedModelExplorer.this.fc.resetChoosableFileFilters();
                    AdvancedModelExplorer.this.fc.setFileFilter(new ExtensionFileFilter(new String[]{"xml"}));
                    AdvancedModelExplorer.this.fc.setCurrentDirectory(new File(curDir));
                    int returnVal = AdvancedModelExplorer.this.fc.showSaveDialog(AdvancedModelExplorer.this);
                    if (returnVal == 0) {
                        prefs.put("currentDir", AdvancedModelExplorer.this.fc.getCurrentDirectory().toString());
                        File file = AdvancedModelExplorer.this.fc.getSelectedFile();
                        XScuflView xsv = new XScuflView(((AdvancedModelExplorer)AdvancedModelExplorer.this).explorer.model);
                        PrintWriter out = new PrintWriter(new FileWriter(file));
                        out.println(xsv.getXMLText());
                        ((AdvancedModelExplorer)AdvancedModelExplorer.this).explorer.model.removeListener(xsv);
                        out.flush();
                        out.close();
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(AdvancedModelExplorer.this, "Problem saving workflow : \n" + ex.getMessage(), "Error!", 0);
                }
            }
        });
        this.resetWorkflow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object[] options = new Object[]{"Confirm reset", "Cancel"};
                int n = JOptionPane.showOptionDialog(AdvancedModelExplorer.this, "Are you sure you want to reset the model,\nany changes you have made will be lost?", "Confirm workflow reset", 0, 3, null, options, options[1]);
                if (n == 0) {
                    ((AdvancedModelExplorer)AdvancedModelExplorer.this).explorer.model.clear();
                }
            }
        });
        this.explorer.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    AdvancedModelExplorer.this.selectedObject = null;
                    AdvancedModelExplorer.this.tabs.setEnabledAt(1, false);
                } else {
                    int selectedRow = lsm.getMinSelectionIndex();
                    JTree tree = AdvancedModelExplorer.this.explorer.getTree();
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getPathForRow(selectedRow).getLastPathComponent();
                    AdvancedModelExplorer.this.selectedObject = node.getUserObject();
                    AdvancedModelExplorer.this.updateTab();
                }
            }
        });
        this.fc.updateUI();
    }

    private void updateTab() {
        if (this.selectedObject != null && this.selectedObject instanceof Processor) {
            this.updateTabForProcessor((Processor)this.selectedObject);
        } else if (this.selectedObject != null && this.selectedObject instanceof String) {
            if (((String)this.selectedObject).equals("Workflow model")) {
                this.updateTabForWorkflow();
            } else if (((String)this.selectedObject).equals("Processors")) {
                this.updateTabForSummary();
            } else {
                this.tabs.setEnabledAt(1, false);
                this.tabs.setIconAt(1, null);
                this.tabs.setTitleAt(1, "");
            }
        } else if (this.selectedObject != null && this.selectedObject instanceof Port) {
            Port p = (Port)this.selectedObject;
            if (p.isSource() || p.isSink()) {
                SemanticMarkup m = p.getMetadata();
                this.propertiesPanel.removeAll();
                this.propertiesPanel.setLayout(new BoxLayout(this.propertiesPanel, 3));
                this.propertiesPanel.add((Component)new ScuflSemanticMarkupEditor(m), "Center");
                this.tabs.setEnabledAt(1, true);
                this.tabs.setTitleAt(1, "Metadata for '" + p.getName() + "'");
                this.tabs.setIconAt(1, p.isSource() ? ScuflIcons.inputIcon : ScuflIcons.outputIcon);
            } else {
                this.tabs.setEnabledAt(1, false);
                this.tabs.setIconAt(1, null);
                this.tabs.setTitleAt(1, "");
            }
        } else {
            this.tabs.setEnabledAt(1, false);
            this.tabs.setIconAt(1, null);
            this.tabs.setTitleAt(1, "");
        }
    }

    private void updateTabForSummary() {
        this.propertiesPanel.removeAll();
        this.propertiesPanel.setLayout(new BoxLayout(this.propertiesPanel, 3));
        final String htmlSummary = WorkflowSummaryAsHTML.getSummary(this.model);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.setMaximumSize(new Dimension(2000, 30));
        toolbar.setBorderPainted(true);
        JButton saveHTML = new JButton(ScuflIcons.saveIcon);
        saveHTML.setPreferredSize(new Dimension(25, 25));
        toolbar.add(new JLabel(" Save HTML description "));
        toolbar.add(saveHTML);
        this.propertiesPanel.add((Component)toolbar, "First");
        saveHTML.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Preferences prefs = Preferences.userNodeForPackage(class$org$embl$ebi$escience$scuflui$AdvancedModelExplorer == null ? (class$org$embl$ebi$escience$scuflui$AdvancedModelExplorer = AdvancedModelExplorer.class$("org.embl.ebi.escience.scuflui.AdvancedModelExplorer")) : class$org$embl$ebi$escience$scuflui$AdvancedModelExplorer);
                    String curDir = prefs.get("currentDir", System.getProperty("user.home"));
                    AdvancedModelExplorer.this.fc.resetChoosableFileFilters();
                    AdvancedModelExplorer.this.fc.setFileFilter(new ExtensionFileFilter(new String[]{"html", "htm"}));
                    AdvancedModelExplorer.this.fc.setCurrentDirectory(new File(curDir));
                    int returnVal = AdvancedModelExplorer.this.fc.showSaveDialog(AdvancedModelExplorer.this);
                    if (returnVal == 0) {
                        prefs.put("currentDir", AdvancedModelExplorer.this.fc.getCurrentDirectory().toString());
                        File file = AdvancedModelExplorer.this.fc.getSelectedFile();
                        PrintWriter out = new PrintWriter(new FileWriter(file));
                        out.println(htmlSummary);
                        out.flush();
                        out.close();
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(AdvancedModelExplorer.this, "Problem saving workflow : \n" + ex.getMessage(), "Error!", 0);
                }
            }
        });
        JEditorPane ed = new JEditorPane("text/html", htmlSummary);
        ed.setEditable(false);
        JScrollPane edPane = new JScrollPane(ed);
        this.propertiesPanel.add(edPane);
        edPane.setPreferredSize(new Dimension(100, 100));
        this.tabs.setEnabledAt(1, true);
        this.tabs.setIconAt(1, ScuflIcons.openurlIcon);
        this.tabs.setTitleAt(1, "Remote resource usage");
    }

    private void updateTabForWorkflow() {
        this.propertiesPanel.removeAll();
        this.propertiesPanel.setLayout(new BoxLayout(this.propertiesPanel, 3));
        JPanel descriptionPanel = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(99999, 3000);
            }
        };
        descriptionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Workflow description"));
        descriptionPanel.setLayout(new BorderLayout());
        JTextArea description = new JTextArea(this.model.getDescription().getText());
        JScrollPane descriptionPane = new JScrollPane(description);
        descriptionPane.setPreferredSize(new Dimension(100, 100));
        final WorkflowDescription wd = this.model.getDescription();
        JTextField author = new JTextField(this.model.getDescription().getAuthor());
        JPanel authorPanel = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(99999, 50);
            }
        };
        authorPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Author"));
        authorPanel.setLayout(new BorderLayout());
        authorPanel.add((Component)author, "Center");
        JTextField title = new JTextField(this.model.getDescription().getTitle());
        JPanel titlePanel = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(99999, 50);
            }
        };
        titlePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Descriptive title"));
        titlePanel.setLayout(new BorderLayout());
        titlePanel.add((Component)title, "Center");
        final JTextField lsid = new JTextField(this.model.getDescription().getLSID());
        lsid.setEditable(false);
        JPanel lsidPanel = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(99999, 50);
            }
        };
        lsidPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "LSID"));
        lsidPanel.setLayout(new BorderLayout());
        lsidPanel.add((Component)lsid, "Center");
        JButton assignNewLSID = new JButton("New", ScuflIcons.openurlIcon);
        assignNewLSID.setPreferredSize(new Dimension(80, 25));
        assignNewLSID.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WorkflowDescription wd = AdvancedModelExplorer.this.model.getDescription();
                String newLSID = DataThing.SYSTEM_DEFAULT_LSID_PROVIDER.getID(LSIDProvider.WFDEFINITION);
                wd.setLSID(newLSID);
                lsid.setText(newLSID);
            }
        });
        if (DataThing.SYSTEM_DEFAULT_LSID_PROVIDER == null) {
            assignNewLSID.setEnabled(false);
        }
        lsidPanel.add((Component)assignNewLSID, "East");
        description.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                try {
                    Document d = e.getDocument();
                    wd.setText(d.getText(0, d.getLength()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }

            public void removeUpdate(DocumentEvent e) {
                try {
                    Document d = e.getDocument();
                    wd.setText(d.getText(0, d.getLength()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }

            public void changedUpdate(DocumentEvent e) {
                try {
                    Document d = e.getDocument();
                    wd.setText(d.getText(0, d.getLength()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        author.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                try {
                    Document d = e.getDocument();
                    wd.setAuthor(d.getText(0, d.getLength()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }

            public void removeUpdate(DocumentEvent e) {
                try {
                    Document d = e.getDocument();
                    wd.setAuthor(d.getText(0, d.getLength()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }

            public void changedUpdate(DocumentEvent e) {
                try {
                    Document d = e.getDocument();
                    wd.setAuthor(d.getText(0, d.getLength()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        title.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                try {
                    Document d = e.getDocument();
                    wd.setTitle(d.getText(0, d.getLength()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }

            public void removeUpdate(DocumentEvent e) {
                try {
                    Document d = e.getDocument();
                    wd.setTitle(d.getText(0, d.getLength()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }

            public void changedUpdate(DocumentEvent e) {
                try {
                    Document d = e.getDocument();
                    wd.setTitle(d.getText(0, d.getLength()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        description.setEditable(true);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        descriptionPanel.add(descriptionPane);
        this.propertiesPanel.add(authorPanel);
        this.propertiesPanel.add(titlePanel);
        this.propertiesPanel.add(lsidPanel);
        this.propertiesPanel.add(descriptionPanel);
        this.tabs.setEnabledAt(1, true);
        this.tabs.setTitleAt(1, "Workflow metadata");
        this.tabs.setIconAt(1, ScuflIcons.windowExplorer);
    }

    private void updateTabForProcessor(Processor processor) {
        this.propertiesPanel.removeAll();
        this.propertiesPanel.setLayout(new BoxLayout(this.propertiesPanel, 3));
        final Processor p = processor;
        JPanel descriptionPanel = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(99999, 150);
            }
        };
        descriptionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Processor Description for '" + p.getName() + "'"));
        descriptionPanel.setLayout(new BorderLayout());
        JTextArea description = new JTextArea(p.getDescription(), 4, 0);
        JScrollPane descriptionPane = new JScrollPane(description);
        descriptionPane.setPreferredSize(new Dimension(100, 100));
        description.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                try {
                    Document d = e.getDocument();
                    p.setDescription(d.getText(0, d.getLength()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }

            public void removeUpdate(DocumentEvent e) {
                try {
                    Document d = e.getDocument();
                    p.setDescription(d.getText(0, d.getLength()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }

            public void changedUpdate(DocumentEvent e) {
                try {
                    Document d = e.getDocument();
                    p.setDescription(d.getText(0, d.getLength()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        description.setEditable(true);
        description.setLineWrap(true);
        description.setWrapStyleWord(true);
        descriptionPanel.add(descriptionPane);
        this.propertiesPanel.add(descriptionPanel);
        final JPanel iterationConfigPanel = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(99999, 100);
            }
        };
        iterationConfigPanel.setLayout(new BorderLayout());
        iterationConfigPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Configure Iterators"));
        final JButton createStrategy = new JButton("Create iteration strategy");
        final JButton resetStrategy = new JButton("Reset iteration strategy");
        String noIteratorMessage = "<h2>No iterator strategy</h2>If you would like to override Taverna's default strategy you need to click the '<em><font color=\"green\">create strategy</font></em>' button and then use the editing controls to manipulate the tree of iterators. Note that the iteration strategy created will only include the inputs bound at the time you press the button, if you subsequently add new input links you will have to reset and recreate the strategy; all bound inputs <font color=\"red\">must</font> be included.";
        createStrategy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                p.setIterationStrategy(new IterationStrategy(p));
                createStrategy.setEnabled(false);
                resetStrategy.setEnabled(true);
                IterationStrategyEditorControl editor = new IterationStrategyEditorControl(p.getIterationStrategy());
                iterationConfigPanel.removeAll();
                JScrollPane pane = new JScrollPane(editor);
                pane.setPreferredSize(new Dimension(100, 100));
                iterationConfigPanel.add(pane);
                AdvancedModelExplorer.this.doLayout();
                AdvancedModelExplorer.this.repaint();
            }
        });
        resetStrategy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                p.setIterationStrategy(null);
                resetStrategy.setEnabled(false);
                createStrategy.setEnabled(true);
                iterationConfigPanel.removeAll();
                JEditorPane ed = new JEditorPane("text/html", "<h2>No iterator strategy</h2>If you would like to override Taverna's default strategy you need to click the '<em><font color=\"green\">create strategy</font></em>' button and then use the editing controls to manipulate the tree of iterators. Note that the iteration strategy created will only include the inputs bound at the time you press the button, if you subsequently add new input links you will have to reset and recreate the strategy; all bound inputs <font color=\"red\">must</font> be included.");
                ed.setEditable(false);
                JScrollPane helpPane = new JScrollPane(ed);
                helpPane.setPreferredSize(new Dimension(100, 100));
                iterationConfigPanel.add(helpPane);
                iterationConfigPanel.doLayout();
                AdvancedModelExplorer.this.doLayout();
                AdvancedModelExplorer.this.repaint();
            }
        });
        JPanel buttonPanel = new JPanel(){

            public Dimension getMaximumSize() {
                return new Dimension(99999, 20);
            }
        };
        buttonPanel.setLayout(new GridLayout(0, 2));
        buttonPanel.add(createStrategy);
        buttonPanel.add(resetStrategy);
        this.propertiesPanel.add(buttonPanel);
        this.propertiesPanel.add(new JScrollPane(iterationConfigPanel));
        if (p.getIterationStrategy() == null) {
            resetStrategy.setEnabled(false);
            JEditorPane ed = new JEditorPane("text/html", "<h2>No iterator strategy</h2>If you would like to override Taverna's default strategy you need to click the '<em><font color=\"green\">create strategy</font></em>' button and then use the editing controls to manipulate the tree of iterators. Note that the iteration strategy created will only include the inputs bound at the time you press the button, if you subsequently add new input links you will have to reset and recreate the strategy; all bound inputs <font color=\"red\">must</font> be included.");
            ed.setEditable(false);
            JScrollPane helpPane = new JScrollPane(ed);
            helpPane.setPreferredSize(new Dimension(100, 100));
            iterationConfigPanel.add(helpPane);
        } else {
            createStrategy.setEnabled(false);
            IterationStrategyEditorControl editor = new IterationStrategyEditorControl(p.getIterationStrategy());
            JScrollPane pane = new JScrollPane(editor);
            pane.setPreferredSize(new Dimension(100, 100));
            iterationConfigPanel.add(pane);
        }
        this.tabs.setEnabledAt(1, true);
        this.tabs.setTitleAt(1, "Metadata for '" + p.getName() + "'");
        this.tabs.setIconAt(1, ProcessorHelper.getPreferredIcon(p));
    }

    public String getName() {
        return "Advanced model explorer";
    }

    public ImageIcon getIcon() {
        return ScuflIcons.windowExplorer;
    }

    public void attachToModel(ScuflModel theModel) {
        this.model = theModel;
        this.workOffline.setSelected(theModel.isOffline());
        this.explorer.attachToModel(theModel);
        this.listener = new ScuflModelEventListener(){

            public void receiveModelEvent(ScuflModelEvent event) {
                if (event instanceof ScuflModelEvent && event.getSource() == AdvancedModelExplorer.this.model) {
                    boolean currentOfflineStatus = AdvancedModelExplorer.this.model.isOffline();
                    AdvancedModelExplorer.this.workOffline.setSelected(currentOfflineStatus);
                }
            }
        };
        theModel.addListener(this.listener);
    }

    public void detachFromModel() {
        this.explorer.detachFromModel();
        this.model.removeListener(this.listener);
        this.model = null;
    }
}

