/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl.view;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scuflworkers.biomoby.BiomobyProcessor;
import org.embl.ebi.escience.scuflworkers.seqhound.SeqhoundProcessor;
import org.embl.ebi.escience.scuflworkers.soaplab.SoaplabProcessor;
import org.embl.ebi.escience.scuflworkers.wsdl.WSDLBasedProcessor;

public class WorkflowSummaryAsHTML {
    public static String getSummary(ScuflModel model) {
        Processor[] processors = model.getProcessors();
        HashMap resources = new HashMap();
        for (int i = 0; i < processors.length; ++i) {
            String resourceHost = processors[i].getResourceHost();
            if (resourceHost == Processor.ENACTOR) continue;
            if (!resources.containsKey(resourceHost)) {
                resources.put(resourceHost, new ArrayList());
            }
            List processorForResource = (List)resources.get(resourceHost);
            processorForResource.add(processors[i]);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<html><head><STYLE TYPE=\"text/css\">");
        sb.append("body {\n");
        sb.append("  background-color: #eeeeee;\n");
        sb.append("font-family: Helvetica, Arial, sans-serif;\n");
        sb.append("font-size: 12pt;\n");
        sb.append("}\n");
        sb.append("blockquote {\n");
        sb.append("  padding: 5px;\n");
        sb.append("  background-color: #ffffff;\n");
        sb.append("  border-width: 1px; border-style: solid; border-color: #aaaaaa;\n");
        sb.append("}\n");
        sb.append("</STYLE></head><body>");
        sb.append("<h2>Workflow information</h2>");
        String author = model.getDescription().getAuthor();
        author = author.equals("") ? "<font color=\"red\">no author</font>" : "<font color=\"green\">" + author + "</font>";
        String title = model.getDescription().getTitle();
        title = title.equals("") ? "<font color=\"red\">no title</font>" : "<font color=\"green\">" + title + "</font>";
        String lsid = model.getDescription().getLSID();
        lsid = lsid.equals("") ? "<font color=\"red\">no lsid</font>" : "<font color=\"green\">" + lsid + "</font>";
        sb.append("This report applies to the workflow titled '" + title + "' authored by '" + author + "' and with LSID '" + lsid + "'. The textual description, if any is shown below :<blockquote><em>" + model.getDescription().getText() + "</em></blockquote>");
        sb.append("<h2>Resource usage report</h2>");
        sb.append("This display shows the various external resources used by the current workflow. It does not show resources such as local operations or string constants which are run within the enactment engine. Services are categorized by resource host and type, and the name of the instance of each service shown to the right.");
        sb.append("<table border=\"1\" bgcolor=\"white\">");
        Iterator i = resources.keySet().iterator();
        while (i.hasNext()) {
            Set processorNames;
            Set processorNames2;
            Map operationToProcessorName;
            String hostName = (String)i.next();
            List usageList = (List)resources.get(hostName);
            sb.append("<tr><td valign=\"top\" bgcolor=\"#bcd2ee\"colspan=\"3\">Resources on   <code><b>" + hostName + "</b></code>, " + usageList.size() + " instance" + (usageList.size() != 1 ? "s" : "") + ".</td></tr>\n");
            HashSet<Object> temp = new HashSet<Object>();
            Iterator j = usageList.iterator();
            while (j.hasNext()) {
                Object o = j.next();
                if (!(o instanceof WSDLBasedProcessor)) continue;
                temp.add(o);
            }
            WSDLBasedProcessor[] wp = temp.toArray(new WSDLBasedProcessor[0]);
            HashMap wsLocations = new HashMap();
            for (int j2 = 0; j2 < wp.length; ++j2) {
                String operationName;
                String wsdlLocation = "";
                try {
                    URL wsdlURL = new URL(wp[j2].getWSDLLocation());
                    wsdlLocation = wsdlURL.getFile();
                }
                catch (MalformedURLException mue) {
                    // empty catch block
                }
                if (!wsLocations.containsKey(wsdlLocation)) {
                    wsLocations.put(wsdlLocation, new HashMap());
                }
                if (!(operationToProcessorName = (Map)wsLocations.get(wsdlLocation)).containsKey(operationName = wp[j2].getOperationName())) {
                    operationToProcessorName.put(operationName, new HashSet());
                }
                Set processorNames3 = (Set)operationToProcessorName.get(operationName);
                processorNames3.add(wp[j2].getName());
            }
            Iterator<Object> j3 = wsLocations.keySet().iterator();
            while (j3.hasNext()) {
                String location = (String)j3.next();
                operationToProcessorName = (Map)wsLocations.get(location);
                int rows = 2 + operationToProcessorName.size();
                sb.append("<tr>");
                sb.append("<td width=\"80\" valign=\"top\" rowspan=\"" + rows + "\" bgcolor=\"#a3cd5a\">Web&nbsp;service</td>");
                sb.append("<td colspan=\"2\" bgcolor=\"#a3cd5a\">WSDL Defined at <em>" + location + "</em></td>");
                sb.append("</tr>");
                sb.append("<tr><td bgcolor=\"#eeeedd\">Operation name</td><td bgcolor=\"#eeeedd\">Processors</td></tr>");
                Iterator k = operationToProcessorName.keySet().iterator();
                while (k.hasNext()) {
                    String operationName = (String)k.next();
                    processorNames2 = (Set)operationToProcessorName.get(operationName);
                    sb.append("<tr>");
                    sb.append("<td><font color=\"purple\">" + operationName + "</font></td>");
                    sb.append("<td>");
                    Iterator l = processorNames2.iterator();
                    while (l.hasNext()) {
                        sb.append((String)l.next());
                        if (!l.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append("</td></tr>");
                }
            }
            temp = new HashSet();
            j3 = usageList.iterator();
            while (j3.hasNext()) {
                Object o = j3.next();
                if (!(o instanceof SoaplabProcessor)) continue;
                temp.add(o);
            }
            SoaplabProcessor[] sp = temp.toArray(new SoaplabProcessor[0]);
            HashMap soaplabLocations = new HashMap();
            for (int j4 = 0; j4 < sp.length; ++j4) {
                String appName;
                Map nameToProcessorNames;
                String soaplabLocation = sp[j4].getServicePath();
                if (!soaplabLocations.containsKey(soaplabLocation)) {
                    soaplabLocations.put(soaplabLocation, new HashMap());
                }
                if (!(nameToProcessorNames = (Map)soaplabLocations.get(soaplabLocation)).containsKey(appName = sp[j4].getCategory() + "::<font color=\"purple\">" + sp[j4].getAppName() + "</font>")) {
                    nameToProcessorNames.put(appName, new HashSet());
                }
                processorNames2 = (Set)nameToProcessorNames.get(appName);
                processorNames2.add(sp[j4].getName());
            }
            Iterator<Object> j5 = soaplabLocations.keySet().iterator();
            while (j5.hasNext()) {
                String location = (String)j5.next();
                Map nameToProcessorName = (Map)soaplabLocations.get(location);
                int rows = 2 + nameToProcessorName.size();
                sb.append("<tr>");
                sb.append("<td width=\"80\" valign=\"top\" rowspan=\"" + rows + "\" bgcolor=\"#faf9d2\">Soaplab</td>");
                sb.append("<td colspan=\"2\" bgcolor=\"faf9d2\">Service rooted at <em>" + location + "</em></td>");
                sb.append("</tr>");
                sb.append("<tr><td bgcolor=\"#eeeedd\">App category and name</td><td bgcolor=\"#eeeedd\">Processors</td></tr>");
                Iterator k = nameToProcessorName.keySet().iterator();
                while (k.hasNext()) {
                    String appName = (String)k.next();
                    processorNames = (Set)nameToProcessorName.get(appName);
                    sb.append("<tr>");
                    sb.append("<td>" + appName + "</td>");
                    sb.append("<td>");
                    Iterator l = processorNames.iterator();
                    while (l.hasNext()) {
                        sb.append((String)l.next());
                        if (!l.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append("</td></tr>");
                }
            }
            temp = new HashSet();
            j5 = usageList.iterator();
            while (j5.hasNext()) {
                Object o = j5.next();
                if (!(o instanceof SeqhoundProcessor)) continue;
                temp.add(o);
            }
            SeqhoundProcessor[] sq = temp.toArray(new SeqhoundProcessor[0]);
            HashMap seqhoundLocations = new HashMap();
            for (int j6 = 0; j6 < sq.length; ++j6) {
                String methodName;
                Map nameToProcessorNames;
                String seqhoundLocation = sq[j6].getPath();
                if (!seqhoundLocations.containsKey(seqhoundLocation)) {
                    seqhoundLocations.put(seqhoundLocation, new HashMap());
                }
                if (!(nameToProcessorNames = (Map)seqhoundLocations.get(seqhoundLocation)).containsKey(methodName = "<font color=\"purple\">" + sq[j6].getMethodName() + "</font>")) {
                    nameToProcessorNames.put(methodName, new HashSet());
                }
                processorNames = (Set)nameToProcessorNames.get(methodName);
                processorNames.add(sq[j6].getName());
            }
            Iterator<Object> j7 = seqhoundLocations.keySet().iterator();
            while (j7.hasNext()) {
                String location = (String)j7.next();
                Map nameToProcessorName = (Map)seqhoundLocations.get(location);
                int rows = 2 + nameToProcessorName.size();
                sb.append("<tr>");
                sb.append("<td width=\"80\" valign=\"top\" rowspan=\"" + rows + "\" bgcolor=\"#2f25fa\">SeqHound</td>");
                sb.append("<td colspan=\"2\" bgcolor=\"2f25fa\">Service rooted at <em>" + location + "</em></td>");
                sb.append("</tr>");
                sb.append("<tr><td bgcolor=\"#eeeedd\">Method name</td><td bgcolor=\"#eeeedd\">Processors</td></tr>");
                Iterator k = nameToProcessorName.keySet().iterator();
                while (k.hasNext()) {
                    String appName = (String)k.next();
                    Set processorNames4 = (Set)nameToProcessorName.get(appName);
                    sb.append("<tr>");
                    sb.append("<td>" + appName + "</td>");
                    sb.append("<td>");
                    Iterator l = processorNames4.iterator();
                    while (l.hasNext()) {
                        sb.append((String)l.next());
                        if (!l.hasNext()) continue;
                        sb.append(", ");
                    }
                    sb.append("</td></tr>");
                }
            }
            j7 = usageList.iterator();
            while (j7.hasNext()) {
                Processor p = (Processor)j7.next();
                if (p instanceof WSDLBasedProcessor || p instanceof SoaplabProcessor || p instanceof SeqhoundProcessor) continue;
                sb.append("<tr>");
                if (p instanceof BiomobyProcessor) {
                    sb.append("<td bgcolor=\"#ffd200\">Biomoby</td>");
                    BiomobyProcessor bp = (BiomobyProcessor)p;
                    sb.append("<td><font color=\"purple\">" + bp.getServiceName() + "</font>&nbsp;in&nbsp;" + bp.getEndpoint().getFile() + "</td>");
                } else {
                    sb.append("<td colspan=\"2\">Unknown&nbsp;type</td>");
                }
                sb.append("<td>" + p.getName() + "</td>");
                sb.append("</tr>\n");
            }
        }
        sb.append("</table></body></html>");
        return sb.toString();
    }
}

