/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl.view;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.embl.ebi.escience.scufl.AlternateProcessor;
import org.embl.ebi.escience.scufl.ConcurrencyConstraint;
import org.embl.ebi.escience.scufl.DataConstraint;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.MinorScuflModelEvent;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.ScuflModelEventListener;

public class TreeModelView
extends DefaultTreeModel
implements ScuflModelEventListener {
    private ScuflModel workflow = null;
    private MutableTreeNode inputRootNode;
    private MutableTreeNode outputRootNode;
    private MutableTreeNode processorRootNode;
    private MutableTreeNode datalinkRootNode;
    private MutableTreeNode constraintRootNode;

    public TreeModelView() {
        super(new DefaultMutableTreeNode("No model available"));
    }

    public ScuflModel getModel() {
        return this.workflow;
    }

    public void attachToModel(ScuflModel theModel) {
        this.workflow = theModel;
        theModel.addListener(this);
        this.getRootNode().setUserObject("Workflow model");
        this.generateInitialModel();
    }

    public void detachFromModel() {
        if (this.workflow != null) {
            this.workflow.removeListener(this);
            this.workflow = null;
            this.getRootNode().setUserObject("No model available");
            this.clearNode(this.getRootNode());
        }
    }

    public synchronized void receiveModelEvent(ScuflModelEvent event) {
        Object source = event.getSource();
        if (source instanceof Processor) {
            if ((Processor)source == this.workflow.getWorkflowSourceProcessor()) {
                this.generateInputs();
                return;
            }
            if ((Processor)source == this.workflow.getWorkflowSinkProcessor()) {
                this.generateOutputs();
                return;
            }
            if (!(event instanceof MinorScuflModelEvent)) {
                this.updateProcessorNode((Processor)source);
            }
            return;
        }
        if (source instanceof ConcurrencyConstraint) {
            this.generateConstraints();
            return;
        }
        if (source instanceof DataConstraint) {
            this.generateLinks();
            return;
        }
        this.generateInitialModel();
    }

    private DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.getRoot();
    }

    private synchronized void generateInitialModel() {
        this.clearNode(this.getRootNode());
        this.inputRootNode = new DefaultMutableTreeNode("Workflow inputs");
        this.outputRootNode = new DefaultMutableTreeNode("Workflow outputs");
        this.processorRootNode = new DefaultMutableTreeNode("Processors");
        this.datalinkRootNode = new DefaultMutableTreeNode("Data links");
        this.constraintRootNode = new DefaultMutableTreeNode("Control links");
        this.insertNodeInto(this.inputRootNode, this.getRootNode(), 0);
        this.insertNodeInto(this.outputRootNode, this.getRootNode(), 1);
        this.insertNodeInto(this.processorRootNode, this.getRootNode(), 2);
        this.insertNodeInto(this.datalinkRootNode, this.getRootNode(), 3);
        this.insertNodeInto(this.constraintRootNode, this.getRootNode(), 4);
        this.generateInputs();
        this.generateOutputs();
        this.generateProcessors();
        this.generateLinks();
        this.generateConstraints();
    }

    private synchronized void generateInputs() {
        this.clearNode(this.inputRootNode);
        Port[] inputPorts = this.workflow.getWorkflowSourcePorts();
        for (int i = 0; i < inputPorts.length; ++i) {
            this.insertNodeInto(new DefaultMutableTreeNode(inputPorts[i]), this.inputRootNode, i);
        }
    }

    private synchronized void generateOutputs() {
        this.clearNode(this.outputRootNode);
        Port[] outputPorts = this.workflow.getWorkflowSinkPorts();
        for (int i = 0; i < outputPorts.length; ++i) {
            this.insertNodeInto(new DefaultMutableTreeNode(outputPorts[i]), this.outputRootNode, i);
        }
    }

    private synchronized void generateLinks() {
        this.clearNode(this.datalinkRootNode);
        DataConstraint[] links = this.workflow.getDataConstraints();
        for (int i = 0; i < links.length; ++i) {
            this.insertNodeInto(new DefaultMutableTreeNode(links[i]), this.datalinkRootNode, i);
        }
    }

    private synchronized void generateConstraints() {
        this.clearNode(this.constraintRootNode);
        ConcurrencyConstraint[] controls = this.workflow.getConcurrencyConstraints();
        for (int i = 0; i < controls.length; ++i) {
            this.insertNodeInto(new DefaultMutableTreeNode(controls[i]), this.constraintRootNode, i);
        }
    }

    private synchronized void generateProcessors() {
        this.clearNode(this.processorRootNode);
        Processor[] processors = this.workflow.getProcessors();
        for (int i = 0; i < processors.length; ++i) {
            this.updateProcessorNode(processors[i]);
        }
    }

    private synchronized void updateProcessorNode(Processor p) {
        MutableTreeNode processorNode = null;
        for (int i = 0; i < this.processorRootNode.getChildCount() && processorNode == null; ++i) {
            if (((DefaultMutableTreeNode)this.processorRootNode.getChildAt(i)).getUserObject() != p) continue;
            processorNode = (MutableTreeNode)this.processorRootNode.getChildAt(i);
        }
        if (processorNode == null) {
            processorNode = new DefaultMutableTreeNode(p);
            this.insertNodeInto(processorNode, this.processorRootNode, this.processorRootNode.getChildCount());
        }
        this.refreshProcessorNode((DefaultMutableTreeNode)processorNode);
    }

    private synchronized void refreshProcessorNode(DefaultMutableTreeNode processorNode) {
        int j;
        this.clearNode(processorNode);
        Processor processor = (Processor)processorNode.getUserObject();
        InputPort[] inputs = processor.getInputPorts();
        OutputPort[] outputs = processor.getOutputPorts();
        for (j = 0; j < inputs.length; ++j) {
            this.insertNodeInto(new DefaultMutableTreeNode(inputs[j]), processorNode, j);
        }
        for (j = 0; j < outputs.length; ++j) {
            this.insertNodeInto(new DefaultMutableTreeNode(outputs[j]), processorNode, j + inputs.length);
        }
        AlternateProcessor[] alternates = processor.getAlternatesArray();
        for (int j2 = 0; j2 < alternates.length; ++j2) {
            int k;
            DefaultMutableTreeNode alternateNode = new DefaultMutableTreeNode(alternates[j2]);
            this.insertNodeInto(alternateNode, processorNode, j2 + inputs.length + outputs.length);
            InputPort[] alternateInputs = alternates[j2].getProcessor().getInputPorts();
            OutputPort[] alternateOutputs = alternates[j2].getProcessor().getOutputPorts();
            for (k = 0; k < alternateInputs.length; ++k) {
                this.insertNodeInto(new DefaultMutableTreeNode(alternateInputs[k]), alternateNode, k);
            }
            for (k = 0; k < alternateOutputs.length; ++k) {
                this.insertNodeInto(new DefaultMutableTreeNode(alternateOutputs[k]), alternateNode, k + alternateInputs.length);
            }
        }
    }

    private synchronized void clearNode(MutableTreeNode parent) {
        while (parent.getChildCount() > 0) {
            this.removeNodeFromParent((MutableTreeNode)parent.getChildAt(0));
        }
    }
}

