/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl.semantics;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import org.embl.ebi.escience.scufl.semantics.RDFSClassHolder;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class RDFSParser {
    static Namespace rdfsNS = Namespace.getNamespace((String)"rdfs", (String)"http://www.w3.org/2000/01/rdf-schema#");
    static Namespace rdfNS = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    public static DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Available ontologies :");

    public static void loadRDFSDocument(InputStream docInputStream, String ontologyName) {
        try {
            HashMap<String, String[]> classToParentList = new HashMap<String, String[]>();
            HashMap classToChildList = new HashMap();
            InputStreamReader isr = new InputStreamReader(docInputStream);
            SAXBuilder builder = new SAXBuilder(false);
            Document document = builder.build((Reader)isr);
            List classElements = document.getRootElement().getChildren("Class", rdfsNS);
            Iterator<Object> i = classElements.iterator();
            while (i.hasNext()) {
                Element classElement = (Element)i.next();
                String className = classElement.getAttributeValue("about", rdfNS);
                ArrayList<String> parents = new ArrayList<String>();
                Iterator j = classElement.getChildren("subClassOf", rdfsNS).iterator();
                while (j.hasNext()) {
                    Element parent = (Element)j.next();
                    String parentClassName = parent.getAttributeValue("resource", rdfNS);
                    parents.add(parentClassName);
                }
                if (classElement.getChildren("subClassOf", rdfsNS).isEmpty()) {
                    parents.add("root:" + ontologyName);
                }
                classToParentList.put(className, parents.toArray(new String[0]));
                classToChildList.put(className, new ArrayList());
            }
            classToChildList.put("root:" + ontologyName, new ArrayList());
            classToParentList.put("root:" + ontologyName, new String[0]);
            i = classToParentList.keySet().iterator();
            while (i.hasNext()) {
                String className = (String)i.next();
                String[] parentClassNames = (String[])classToParentList.get(className);
                for (int j = 0; j < parentClassNames.length; ++j) {
                    ArrayList currentChildren = (ArrayList)classToChildList.get(parentClassNames[j]);
                    currentChildren.add(className);
                }
            }
            rootNode.add(RDFSParser.generateTree(classToChildList, "root:" + ontologyName, false));
        }
        catch (Exception ex) {
            System.out.println("Exception occured whilst loading RDFS! " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    private static DefaultMutableTreeNode generateTree(Map classToChildList, String className, boolean generateHolder) {
        DefaultMutableTreeNode theNode = null;
        theNode = generateHolder ? new DefaultMutableTreeNode(new RDFSClassHolder(className)) : new DefaultMutableTreeNode(className);
        ArrayList children = (ArrayList)classToChildList.get(className);
        Iterator i = children.iterator();
        while (i.hasNext()) {
            String childClassName = (String)i.next();
            theNode.add(RDFSParser.generateTree(classToChildList, childClassName, true));
        }
        return theNode;
    }
}

