/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl.provenance.process;

import org.embl.ebi.escience.scufl.provenance.process.ProcessEvent;
import org.jdom.Element;

public class ServiceError
extends ProcessEvent {
    private Exception underlyingException;

    public String getMessage() {
        if (this.underlyingException != null) {
            return this.underlyingException.getMessage();
        }
        return "Unknown exception";
    }

    public ServiceError(Exception ex) {
        this.underlyingException = ex;
    }

    public Element eventElement() {
        Element e = super.eventTopLevelElement();
        if (this.underlyingException != null) {
            boolean doneFullTrace = false;
            StringBuffer sb = new StringBuffer();
            Exception ex = this.underlyingException;
            while (!doneFullTrace) {
                sb.append(ex.getMessage() + "<br>");
                StackTraceElement[] stack = ex.getStackTrace();
                for (int i = 0; i < stack.length; ++i) {
                    String fileName = stack[i].getFileName();
                    if (fileName == null) {
                        fileName = "Unknown filename";
                    }
                    String className = stack[i].getClassName();
                    String methodName = stack[i].getMethodName();
                    boolean isNativeMethod = stack[i].isNativeMethod();
                    int line = stack[i].getLineNumber();
                    sb.append("   " + className + "." + methodName + "(..) : line " + line + " &lt;" + fileName + "&gt;<br>");
                }
                if (ex.getCause() != null) {
                    ex = (Exception)ex.getCause();
                    sb.append("<br>");
                    continue;
                }
                doneFullTrace = true;
            }
            e.setText(sb.toString());
        }
        return e;
    }
}

