/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.embl.ebi.escience.scufl.ConcurrencyConstraint;
import org.embl.ebi.escience.scufl.ConcurrencyConstraintCreationException;
import org.embl.ebi.escience.scufl.DataConstraint;
import org.embl.ebi.escience.scufl.DataConstraintCreationException;
import org.embl.ebi.escience.scufl.DuplicateConcurrencyConstraintNameException;
import org.embl.ebi.escience.scufl.DuplicatePortNameException;
import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.MalformedNameException;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.PortCreationException;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.UnknownPortException;
import org.embl.ebi.escience.scufl.UnknownProcessorException;
import org.embl.ebi.escience.scufl.WorkflowDescription;
import org.embl.ebi.escience.scufl.parser.ExceptionHolder;
import org.embl.ebi.escience.scufl.parser.ProcessorLoaderThread;
import org.embl.ebi.escience.scufl.parser.XScuflFormatException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class XScuflParser {
    public static void populate(String input, ScuflModel model, String prefix) throws UnknownProcessorException, UnknownPortException, ProcessorCreationException, DataConstraintCreationException, DuplicateProcessorNameException, MalformedNameException, ConcurrencyConstraintCreationException, DuplicateConcurrencyConstraintNameException, XScuflFormatException {
        try {
            SAXBuilder builder = new SAXBuilder(false);
            Document document = builder.build((Reader)new StringReader(input));
            XScuflParser.populate(document, model, prefix);
        }
        catch (JDOMException jde) {
            throw new XScuflFormatException("Unable to load XScufl file, error : " + jde.getMessage());
        }
        catch (IOException ioe) {
            throw new XScuflFormatException("Unable to load XScufl file, error : " + ioe.getMessage());
        }
    }

    public static void populate(InputStream is, ScuflModel model, String prefix) throws UnknownProcessorException, UnknownPortException, ProcessorCreationException, DataConstraintCreationException, DuplicateProcessorNameException, MalformedNameException, ConcurrencyConstraintCreationException, DuplicateConcurrencyConstraintNameException, XScuflFormatException {
        InputStreamReader isr = new InputStreamReader(is);
        SAXBuilder builder = new SAXBuilder(false);
        Document document = null;
        try {
            document = builder.build((Reader)isr);
        }
        catch (JDOMException jde) {
            throw new XScuflFormatException("Unable to load XScufl file, error : " + jde.getMessage());
        }
        catch (IOException ioe) {
            throw new XScuflFormatException("Unable to load XScufl file, error : " + ioe.getMessage());
        }
        XScuflParser.populate(document, model, prefix);
    }

    public static void populate(Document document, ScuflModel model, String prefix) throws UnknownProcessorException, UnknownPortException, ProcessorCreationException, DataConstraintCreationException, DuplicateProcessorNameException, MalformedNameException, ConcurrencyConstraintCreationException, DuplicateConcurrencyConstraintNameException, XScuflFormatException {
        Namespace namespace;
        Element descriptionElement;
        Element root;
        model.setEventStatus(false);
        boolean usePrefix = false;
        if (prefix != null) {
            usePrefix = true;
        }
        if ((root = document.getRootElement()).getAttributeValue("log") != null) {
            model.setLogLevel(Integer.parseInt(root.getAttributeValue("log")));
        }
        if ((descriptionElement = root.getChild("workflowdescription", namespace = root.getNamespace())) != null) {
            model.setDescription(WorkflowDescription.build(descriptionElement));
        } else {
            model.setDescription(new WorkflowDescription());
        }
        List processors = root.getChildren("processor", namespace);
        ExceptionHolder holder = new ExceptionHolder();
        ArrayList<ProcessorLoaderThread> threadList = new ArrayList<ProcessorLoaderThread>();
        Iterator i = processors.iterator();
        while (i.hasNext()) {
            Element processorNode = (Element)i.next();
            String name = processorNode.getAttributeValue("name");
            if (usePrefix) {
                name = prefix + "_" + name;
            }
            threadList.add(new ProcessorLoaderThread(model, processorNode, name, namespace, holder));
        }
        i = threadList.iterator();
        while (i.hasNext()) {
            Thread t = (Thread)i.next();
            try {
                t.join();
            }
            catch (InterruptedException ie) {}
        }
        if (!holder.exceptionList.isEmpty()) {
            model.setEventStatus(true);
            StringBuffer message = new StringBuffer();
            Iterator i2 = holder.exceptionList.iterator();
            while (i2.hasNext()) {
                message.append(((Exception)i2.next()).getMessage());
                if (!i2.hasNext()) continue;
                message.append("\n");
            }
            throw new ProcessorCreationException(message.toString());
        }
        try {
            List sourceList = root.getChildren("source", namespace);
            Processor sourceHolder = model.getWorkflowSourceProcessor();
            Iterator i3 = sourceList.iterator();
            while (i3.hasNext()) {
                Element sourceElement = (Element)i3.next();
                String portName = sourceElement.getAttributeValue("name");
                if (portName == null) {
                    portName = sourceElement.getTextTrim();
                }
                try {
                    if (usePrefix) {
                        portName = prefix + "_" + portName;
                    }
                    OutputPort sourcePort = new OutputPort(sourceHolder, portName);
                    Element configurationElement = sourceElement.getChild("metadata", namespace);
                    if (configurationElement != null) {
                        sourcePort.getMetadata().configureFromElement(configurationElement);
                    }
                    sourceHolder.addPort(sourcePort);
                }
                catch (DuplicatePortNameException dpne) {
                    throw new XScuflFormatException("You have a duplicate source port in your definition file, aborting.");
                }
                catch (PortCreationException pce) {
                    throw new XScuflFormatException("Unable to create source port.");
                }
            }
            List sinkList = root.getChildren("sink", namespace);
            Processor sinkHolder = model.getWorkflowSinkProcessor();
            Iterator i4 = sinkList.iterator();
            while (i4.hasNext()) {
                Element sinkElement = (Element)i4.next();
                String portName = sinkElement.getAttributeValue("name");
                if (portName == null) {
                    portName = sinkElement.getTextTrim();
                }
                try {
                    if (usePrefix) {
                        portName = prefix + "_" + portName;
                    }
                    InputPort sinkPort = new InputPort(sinkHolder, portName);
                    Element configurationElement = sinkElement.getChild("metadata", namespace);
                    if (configurationElement != null) {
                        sinkPort.getMetadata().configureFromElement(configurationElement);
                    }
                    sinkHolder.addPort(sinkPort);
                }
                catch (DuplicatePortNameException dpne) {
                    throw new XScuflFormatException("You have a duplicate sink port in your defintion file, aborting.");
                }
                catch (PortCreationException pce) {
                    throw new XScuflFormatException("Unable to create sink port.");
                }
            }
            List dataConstraintList = root.getChildren("link", namespace);
            Iterator i5 = dataConstraintList.iterator();
            while (i5.hasNext()) {
                String sinkPortName;
                String sourcePortName;
                block37: {
                    Element linkElement = (Element)i5.next();
                    sourcePortName = null;
                    sinkPortName = null;
                    try {
                        Element inputElement = linkElement.getChild("input", namespace);
                        Element outputElement = linkElement.getChild("output", namespace);
                        if (inputElement == null) {
                            throw new XScuflFormatException("A data constraint must have an input child element");
                        }
                        if (outputElement == null) {
                            throw new XScuflFormatException("A data constraint must have an output child element");
                        }
                        sinkPortName = inputElement.getTextTrim();
                        sourcePortName = outputElement.getTextTrim();
                    }
                    catch (XScuflFormatException xfe) {
                        sourcePortName = linkElement.getAttributeValue("source");
                        sinkPortName = linkElement.getAttributeValue("sink");
                        if (sourcePortName != null && sinkPortName != null) break block37;
                        throw new XScuflFormatException("Neither nested elements nor attributes found defining the link, aborting parse.");
                    }
                }
                if (usePrefix) {
                    sinkPortName = prefix + "_" + sinkPortName;
                    sourcePortName = prefix + "_" + sourcePortName;
                }
                model.addDataConstraint(new DataConstraint(model, sourcePortName, sinkPortName));
            }
            List concurrencyConstraints = root.getChildren("coordination", namespace);
            Iterator i6 = concurrencyConstraints.iterator();
            while (i6.hasNext()) {
                Element coordination = (Element)i6.next();
                String constraintName = coordination.getAttributeValue("name");
                if (usePrefix) {
                    constraintName = prefix + "_" + constraintName;
                }
                Element condition = coordination.getChild("condition", namespace);
                Element action = coordination.getChild("action", namespace);
                String controllerName = condition.getChild("target", namespace).getTextTrim();
                if (usePrefix) {
                    controllerName = prefix + "_" + controllerName;
                }
                Processor controller = model.locateProcessor(controllerName);
                int controllerStateGuard = ConcurrencyConstraint.statusStringToInt(condition.getChild("state", namespace).getTextTrim());
                String targetName = action.getChild("target", namespace).getTextTrim();
                if (usePrefix) {
                    targetName = prefix + "_" + targetName;
                }
                Processor target = model.locateProcessor(targetName);
                int targetStateTo = ConcurrencyConstraint.statusStringToInt(action.getChild("statechange", namespace).getChild("to", namespace).getTextTrim());
                int targetStateFrom = ConcurrencyConstraint.statusStringToInt(action.getChild("statechange", namespace).getChild("from", namespace).getTextTrim());
                model.addConcurrencyConstraint(new ConcurrencyConstraint(model, constraintName, controller, target, targetStateFrom, targetStateTo, controllerStateGuard));
            }
        }
        catch (XScuflFormatException xfe) {
            model.setEventStatus(true);
            throw xfe;
        }
        model.setEventStatus(true);
    }
}

