/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl.parser;

import org.embl.ebi.escience.scufl.DuplicateProcessorNameException;
import org.embl.ebi.escience.scufl.IterationStrategy;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ProcessorCreationException;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.parser.ExceptionHolder;
import org.embl.ebi.escience.scufl.parser.XScuflFormatException;
import org.embl.ebi.escience.scuflworkers.ProcessorHelper;
import org.jdom.Element;
import org.jdom.Namespace;

class ProcessorLoaderThread
extends Thread {
    private ScuflModel model;
    private Element processorNode;
    private String name;
    private Namespace namespace;
    private ExceptionHolder holder;

    protected ProcessorLoaderThread(ScuflModel model, Element processorNode, String name, Namespace namespace, ExceptionHolder holder) {
        this.model = model;
        this.namespace = namespace;
        this.processorNode = processorNode;
        this.name = name;
        this.holder = holder;
        this.start();
    }

    public void run() {
        try {
            Element iterationStrategyElement;
            Processor theProcessor;
            String logLevel = this.processorNode.getAttributeValue("log");
            int log = -1;
            if (logLevel != null) {
                log = Integer.parseInt(logLevel);
            }
            if ((theProcessor = ProcessorHelper.loadProcessorFromXML(this.processorNode, this.model, this.name)) == null) {
                throw new XScuflFormatException("Couldn't find a known specification mechanism for processor node '" + this.name + "'");
            }
            theProcessor.setLogLevel(log);
            String description = "";
            Element de = this.processorNode.getChild("description", this.namespace);
            if (de != null) {
                description = de.getTextTrim();
                theProcessor.setDescription(description);
            }
            if ((iterationStrategyElement = this.processorNode.getChild("iterationstrategy", this.namespace)) != null) {
                theProcessor.setIterationStrategy(new IterationStrategy(iterationStrategyElement));
            }
            this.model.addProcessor(theProcessor);
        }
        catch (XScuflFormatException xfe) {
            this.holder.addException(xfe);
        }
        catch (ProcessorCreationException pce) {
            this.holder.addException(pce);
        }
        catch (DuplicateProcessorNameException dpne) {
            this.holder.addException(dpne);
        }
    }
}

