/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl.enactor.implementation;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.baclava.LSIDProvider;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.UnknownProcessorException;
import org.embl.ebi.escience.scufl.enactor.UserContext;
import org.embl.ebi.escience.scufl.enactor.WorkflowInstance;
import org.embl.ebi.escience.scufl.enactor.event.WorkflowCompletionEvent;
import org.embl.ebi.escience.scufl.enactor.event.WorkflowCreationEvent;
import org.embl.ebi.escience.scufl.enactor.event.WorkflowFailureEvent;
import org.embl.ebi.escience.scufl.enactor.implementation.WorkflowEventDispatcher;
import uk.ac.soton.itinnovation.freefluo.core.flow.Flow;
import uk.ac.soton.itinnovation.freefluo.core.task.Task;
import uk.ac.soton.itinnovation.freefluo.event.WorkflowStateChangedEvent;
import uk.ac.soton.itinnovation.freefluo.event.WorkflowStateListener;
import uk.ac.soton.itinnovation.freefluo.main.Engine;
import uk.ac.soton.itinnovation.freefluo.main.EngineImpl;
import uk.ac.soton.itinnovation.freefluo.main.InvalidInputException;
import uk.ac.soton.itinnovation.freefluo.main.UnknownWorkflowInstanceException;
import uk.ac.soton.itinnovation.freefluo.main.WorkflowState;
import uk.ac.soton.itinnovation.taverna.enactor.entities.PortTask;
import uk.ac.soton.itinnovation.taverna.enactor.entities.ProcessorTask;

public class WorkflowInstanceImpl
implements WorkflowInstance {
    private Logger logger = Logger.getLogger(this.getClass());
    private EngineImpl engine;
    private String workflowInstanceId;
    private Map input;
    private WorkflowState state;
    private HashSet stateListeners = new HashSet();
    private UserContext context = null;
    private static Map internalToLSID = new HashMap();
    static Map instanceToDefinitionLSID = new HashMap();
    private ScuflModel workflowModel = null;
    private String cachedLSID = null;

    public WorkflowInstanceImpl(Engine engine, String workflowInstanceId) {
        this.engine = (EngineImpl)engine;
        this.workflowInstanceId = workflowInstanceId;
        try {
            String existingLSID;
            Object p;
            uk.ac.soton.itinnovation.freefluo.main.WorkflowInstance internalInstance = this.engine.getWorkflowInstance(workflowInstanceId);
            this.context = internalInstance.getUserContext();
            Flow flow = internalInstance.getFlow();
            Collection c = flow.getStartTasks();
            if (!c.isEmpty()) {
                Task t = (Task)c.iterator().next();
                if (t instanceof ProcessorTask) {
                    p = ((ProcessorTask)t).getProcessor();
                    this.workflowModel = ((Processor)p).getModel();
                } else if (t instanceof PortTask) {
                    p = ((PortTask)t).getScuflPort();
                    this.workflowModel = ((Port)p).getProcessor().getModel();
                }
            }
            if (DataThing.SYSTEM_DEFAULT_LSID_PROVIDER != null && (existingLSID = (String)internalToLSID.get(workflowInstanceId)) == null) {
                p = DataThing.SYSTEM_DEFAULT_LSID_PROVIDER;
                String instanceLSID = p.getID(LSIDProvider.WFINSTANCE);
                internalToLSID.put(workflowInstanceId, instanceLSID);
            }
        }
        catch (UnknownWorkflowInstanceException e) {
            String errorMsg = "Error starting to run workflow instance with id " + workflowInstanceId;
            String msg = errorMsg + ".  The workflow engine didn't recognise the workflow instance id.";
            this.logger.warn((Object)msg);
            throw new IllegalStateException(msg);
        }
    }

    public ScuflModel getWorkflowModel() {
        return this.workflowModel;
    }

    public String getID() {
        if (this.cachedLSID != null) {
            return this.cachedLSID;
        }
        String LSID = (String)internalToLSID.get(this.workflowInstanceId);
        if (LSID != null) {
            this.cachedLSID = LSID;
            return LSID;
        }
        return this.workflowInstanceId;
    }

    public String getDefinitionLSID() {
        String definitionLSID = (String)instanceToDefinitionLSID.get(this.getID());
        if (definitionLSID != null) {
            return definitionLSID;
        }
        return "";
    }

    public void addWorkflowStateListener(WorkflowStateListener listener) {
        try {
            this.engine.addWorkflowStateListener(this.workflowInstanceId, listener);
        }
        catch (UnknownWorkflowInstanceException e) {
            String errorMsg = "Cannot add listener";
            String msg = errorMsg + ".  The workflow engine didn't recognise the workflow instance id.";
            this.logger.warn((Object)msg);
            throw new IllegalStateException(msg);
        }
    }

    public void removeWorkflowStateListener(WorkflowStateListener listener) {
        try {
            this.engine.removeWorkflowStateListener(this.workflowInstanceId, listener);
        }
        catch (UnknownWorkflowInstanceException e) {
            String errorMsg = "Cannot remove listener";
            String msg = errorMsg + ".  The workflow engine didn't recognise the workflow instance id.";
            this.logger.warn((Object)msg);
            throw new IllegalStateException(msg);
        }
    }

    public void setInputs(Map inputMap) {
        this.input = inputMap;
    }

    public void run() throws InvalidInputException {
        String errorMsg = "Error starting to run workflow instance with id " + this.workflowInstanceId;
        try {
            Iterator i = this.input.keySet().iterator();
            while (i.hasNext()) {
                String inputName = (String)i.next();
                DataThing inputValue = (DataThing)this.input.get(inputName);
                inputValue.fillLSIDValues();
            }
            this.engine.run(this.workflowInstanceId, this.input);
            WorkflowEventDispatcher.DISPATCHER.fireWorkflowCreated(new WorkflowCreationEvent(this, this.input, this.getDefinitionLSID()));
            final Map lsidMap = internalToLSID;
            this.addWorkflowStateListener(new WorkflowStateListener(){

                public void workflowStateChanged(WorkflowStateChangedEvent event) {
                    WorkflowEventDispatcher dispatcher = WorkflowEventDispatcher.DISPATCHER;
                    WorkflowState state = event.getWorkflowState();
                    if (state.isFinal()) {
                        WorkflowInstanceImpl.this.getID();
                        if (state.equals(WorkflowState.CANCELLED) || state.equals(WorkflowState.FAILED)) {
                            dispatcher.fireWorkflowFailed(new WorkflowFailureEvent(WorkflowInstanceImpl.this));
                        } else if (state.equals(WorkflowState.COMPLETE)) {
                            dispatcher.fireWorkflowCompleted(new WorkflowCompletionEvent(WorkflowInstanceImpl.this));
                        }
                        instanceToDefinitionLSID.remove(lsidMap.get(WorkflowInstanceImpl.this.workflowInstanceId));
                        lsidMap.remove(WorkflowInstanceImpl.this.workflowInstanceId);
                    }
                }
            });
        }
        catch (InvalidInputException e) {
            this.logger.error((Object)(errorMsg + ".  The inputs don't map to sources in the dataflow."));
            throw e;
        }
        catch (UnknownWorkflowInstanceException e) {
            String msg = errorMsg + ".  The workflow engine didn't recognise the workflow instance id.";
            this.logger.warn((Object)msg);
            throw new IllegalStateException(msg);
        }
    }

    public String getStatus() {
        try {
            return this.engine.getStatus(this.workflowInstanceId);
        }
        catch (UnknownWorkflowInstanceException e) {
            String msg = "Error getting status for workflow instance with id " + this.workflowInstanceId + ".  The workflow engine didn't recognise the workflow isntance id";
            this.logger.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg);
        }
    }

    public Map[] getIntermediateResultsForProcessor(String processorName) throws UnknownProcessorException {
        try {
            return this.engine.getIntermediateResultsForProcessor(this.workflowInstanceId, processorName);
        }
        catch (uk.ac.soton.itinnovation.freefluo.main.UnknownProcessorException e) {
            String msg = "Error getting intermediate results for workflow instance with id " + this.workflowInstanceId + ".  The workflow engine didn't recognise in the workflow instance the processor with name " + processorName;
            this.logger.error((Object)msg, (Throwable)e);
            throw new UnknownProcessorException(msg);
        }
        catch (UnknownWorkflowInstanceException e) {
            String msg = "Error getting intermediate results for workflow instance with id " + this.workflowInstanceId + ".  The workflow engine didn't recognise the workflow isntance id";
            this.logger.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg);
        }
    }

    public String getProgressReportXMLString() {
        try {
            return this.engine.getProgressReportXML(this.workflowInstanceId);
        }
        catch (UnknownWorkflowInstanceException e) {
            String msg = "Error getting progress report xml string for workflow instance with id " + this.workflowInstanceId + ".  The workflow engine didn't recognise the workflow isntance id";
            this.logger.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg);
        }
    }

    public String getOutputXMLString() {
        try {
            return this.engine.getOutputXML(this.workflowInstanceId);
        }
        catch (UnknownWorkflowInstanceException e) {
            String msg = "Error getting output report xml string for workflow instance with id " + this.workflowInstanceId + ".  The workflow engine didn't recognise the workflow isntance id";
            this.logger.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg);
        }
    }

    public Map getOutput() {
        try {
            return this.engine.getOutput(this.workflowInstanceId);
        }
        catch (UnknownWorkflowInstanceException e) {
            String msg = "Error getting progress the output for workflow instance with id " + this.workflowInstanceId + ".  The workflow engine didn't recognise the workflow isntance id";
            this.logger.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg);
        }
    }

    public String getErrorMessage() {
        try {
            return this.engine.getErrorMessage(this.workflowInstanceId);
        }
        catch (UnknownWorkflowInstanceException e) {
            String msg = "Error getting the error message for workflow instance with id " + this.workflowInstanceId + ".  The workflow engine didn't recognise the workflow isntance id";
            this.logger.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg);
        }
    }

    public String getProvenanceXMLString() {
        try {
            return this.engine.getProvenanceXML(this.workflowInstanceId);
        }
        catch (UnknownWorkflowInstanceException e) {
            String msg = "Error getting provenance xml string for workflow instance with id " + this.workflowInstanceId + ".  The workflow engine didn't recognise the workflow isntance id";
            this.logger.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg);
        }
    }

    public boolean pauseExecution() {
        try {
            return this.engine.pauseExecution(this.workflowInstanceId);
        }
        catch (UnknownWorkflowInstanceException e) {
            String msg = "Error pausing workflow instance with id " + this.workflowInstanceId + ".  The workflow engine didn't recognise the workflow isntance id";
            this.logger.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg);
        }
    }

    public boolean resumeExecution() {
        try {
            return this.engine.resumeExecution(this.workflowInstanceId);
        }
        catch (UnknownWorkflowInstanceException e) {
            String msg = "Error resuming workflow instance with id " + this.workflowInstanceId + ".  The workflow engine didn't recognise the workflow isntance id";
            this.logger.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg);
        }
    }

    public boolean isPaused() {
        try {
            return this.engine.isPaused(this.workflowInstanceId);
        }
        catch (UnknownWorkflowInstanceException e) {
            String msg = "Error determining if the workflow is paused for workflow instance with id " + this.workflowInstanceId + ".  The workflow engine didn't recognise the workflow isntance id";
            this.logger.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg);
        }
    }

    public void cancel() {
        try {
            this.engine.cancel(this.workflowInstanceId);
        }
        catch (UnknownWorkflowInstanceException e) {
            String msg = "Error cancelling workflow instance with id " + this.workflowInstanceId + ".  The workflow engine didn't recognise the workflow isntance id";
            this.logger.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg);
        }
    }

    public void destroy() {
        try {
            this.engine.destroy(this.workflowInstanceId);
        }
        catch (UnknownWorkflowInstanceException e) {
            String msg = "Error destroying workflow instance with id " + this.workflowInstanceId + ".  The workflow engine didn't recognise the workflow isntance id";
            this.logger.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg);
        }
    }

    public UserContext getUserContext() {
        return this.context;
    }
}

