/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl.enactor.implementation;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.tools.SPInterface;
import org.apache.commons.discovery.tools.Service;
import org.embl.ebi.escience.scufl.enactor.WorkflowEventListener;
import org.embl.ebi.escience.scufl.enactor.event.CollectionConstructionEvent;
import org.embl.ebi.escience.scufl.enactor.event.IterationCompletionEvent;
import org.embl.ebi.escience.scufl.enactor.event.ProcessCompletionEvent;
import org.embl.ebi.escience.scufl.enactor.event.ProcessFailureEvent;
import org.embl.ebi.escience.scufl.enactor.event.WorkflowCompletionEvent;
import org.embl.ebi.escience.scufl.enactor.event.WorkflowCreationEvent;
import org.embl.ebi.escience.scufl.enactor.event.WorkflowFailureEvent;
import org.embl.ebi.escience.scufl.enactor.event.WorkflowInstanceEvent;

public class WorkflowEventDispatcher {
    private List eventQueue = new ArrayList();
    private List listeners = new ArrayList();
    private Thread notificationThread;
    public static WorkflowEventDispatcher DISPATCHER = new WorkflowEventDispatcher(true);

    private WorkflowEventDispatcher(boolean loadFromSPI) {
        if (loadFromSPI) {
            SPInterface spiIF = new SPInterface(WorkflowEventListener.class);
            ClassLoaders loaders = new ClassLoaders();
            loaders.put(Thread.currentThread().getContextClassLoader());
            Enumeration spe = Service.providers((SPInterface)spiIF, (ClassLoaders)loaders);
            while (spe.hasMoreElements()) {
                WorkflowEventListener wel = (WorkflowEventListener)spe.nextElement();
                this.addListener(wel);
            }
        }
        this.notificationThread = new NotifyThread();
    }

    public void fireWorkflowCreated(WorkflowCreationEvent e) {
        this.addEventToQueue(e);
    }

    public void fireWorkflowFailed(WorkflowFailureEvent e) {
        this.addEventToQueue(e);
    }

    public void fireWorkflowCompleted(WorkflowCompletionEvent e) {
        this.addEventToQueue(e);
    }

    public void fireProcessCompleted(ProcessCompletionEvent e) {
        this.addEventToQueue(e);
    }

    public void fireIterationCompleted(IterationCompletionEvent e) {
        this.addEventToQueue(e);
    }

    public void fireProcessFailed(ProcessFailureEvent e) {
        this.addEventToQueue(e);
    }

    public void fireCollectionConstructed(CollectionConstructionEvent e) {
        this.addEventToQueue(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireEvents() {
        if (!this.hasPendingEvents()) {
            return;
        }
        List list = this.listeners;
        synchronized (list) {
            WorkflowInstanceEvent[] events = this.getPendingEvents();
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                WorkflowEventListener listener = (WorkflowEventListener)i.next();
                for (int j = 0; j < events.length; ++j) {
                    try {
                        this.sendAnEvent(listener, events[j]);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(WorkflowEventListener listener) {
        List list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(WorkflowEventListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    private void sendAnEvent(WorkflowEventListener l, WorkflowInstanceEvent e) {
        if (e instanceof WorkflowCreationEvent) {
            l.workflowCreated((WorkflowCreationEvent)e);
            return;
        }
        if (e instanceof WorkflowFailureEvent) {
            l.workflowFailed((WorkflowFailureEvent)e);
            return;
        }
        if (e instanceof WorkflowCompletionEvent) {
            l.workflowCompleted((WorkflowCompletionEvent)e);
            return;
        }
        if (e instanceof ProcessCompletionEvent) {
            l.processCompleted((ProcessCompletionEvent)e);
            return;
        }
        if (e instanceof IterationCompletionEvent) {
            l.processCompletedWithIteration((IterationCompletionEvent)e);
            return;
        }
        if (e instanceof ProcessFailureEvent) {
            l.processFailed((ProcessFailureEvent)e);
            return;
        }
        if (e instanceof CollectionConstructionEvent) {
            l.collectionConstructed((CollectionConstructionEvent)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEventToQueue(WorkflowInstanceEvent e) {
        List list = this.eventQueue;
        synchronized (list) {
            this.eventQueue.add(e);
            this.notificationThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkflowInstanceEvent[] getPendingEvents() {
        List list = this.eventQueue;
        synchronized (list) {
            WorkflowInstanceEvent[] events = this.eventQueue.toArray(new WorkflowInstanceEvent[0]);
            this.eventQueue.clear();
            return events;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasPendingEvents() {
        List list = this.eventQueue;
        synchronized (list) {
            return !this.eventQueue.isEmpty();
        }
    }

    class NotifyThread
    extends Thread {
        protected NotifyThread() {
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            while (true) {
                WorkflowEventDispatcher.this.fireEvents();
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

