/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl;

import java.beans.IntrospectionException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.embl.ebi.escience.baclava.BaclavaIteratorNode;
import org.embl.ebi.escience.baclava.JoinIteratorNode;
import org.embl.ebi.escience.baclava.LockStepIteratorNode;
import org.embl.ebi.escience.baclava.ResumableIterator;
import org.embl.ebi.escience.scufl.CrossNode;
import org.embl.ebi.escience.scufl.DotNode;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.LeafNode;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.StrategyModel;
import org.embl.ebi.escience.scufl.XScufl;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class IterationStrategy {
    static final Namespace NS = Namespace.getNamespace((String)"i", (String)"http://org.embl.ebi.escience/xscufliteration/0.1beta10");
    StrategyModel strategyModel = null;

    public TreeModel getTreeModel() {
        return this.strategyModel;
    }

    public IterationStrategy(Processor p) {
        this.strategyModel = new StrategyModel(new CrossNode());
        InputPort[] inputs = p.getBoundInputPorts();
        for (int i = 0; i < inputs.length; ++i) {
            this.strategyModel.insertNodeInto(new LeafNode(inputs[i].getName()), (MutableTreeNode)this.strategyModel.getRoot(), i);
        }
        this.normalize();
    }

    public void normalize() {
        this.strategyModel.normalize();
    }

    public IterationStrategy(Element strategyElement) {
        MutableTreeNode rootNode = this.nodeForElement((Element)strategyElement.getChildren().get(0));
        this.strategyModel = new StrategyModel(rootNode);
        this.normalize();
    }

    private MutableTreeNode nodeForElement(Element element) {
        String elementName = element.getName();
        if (elementName.equals("iterator")) {
            return new LeafNode(element.getAttributeValue("name"));
        }
        DefaultMutableTreeNode combination = null;
        combination = elementName.equals("dot") ? new DotNode() : new CrossNode();
        Iterator i = element.getChildren().iterator();
        while (i.hasNext()) {
            combination.insert(this.nodeForElement((Element)i.next()), 0);
        }
        return combination;
    }

    public Element getElement() {
        Element rootElement = new Element("iterationstrategy", XScufl.XScuflNS);
        rootElement.addContent((Content)this.elementForNode((MutableTreeNode)this.strategyModel.getRoot()));
        return rootElement;
    }

    private Element elementForNode(MutableTreeNode node) {
        if (node instanceof LeafNode) {
            Element leafElement = new Element("iterator", NS);
            leafElement.setAttribute("name", (String)((LeafNode)node).getUserObject());
            return leafElement;
        }
        Element combination = null;
        combination = node instanceof DotNode ? new Element("dot", NS) : new Element("cross", NS);
        Enumeration<? extends TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            combination.addContent((Content)this.elementForNode((MutableTreeNode)en.nextElement()));
        }
        return combination;
    }

    public ResumableIterator buildIterator(Map iteratorNodes) throws IntrospectionException {
        return this.iteratorForNode((MutableTreeNode)this.strategyModel.getRoot(), iteratorNodes);
    }

    private ResumableIterator iteratorForNode(MutableTreeNode node, Map iteratorNodes) throws IntrospectionException {
        if (node instanceof LeafNode) {
            String iteratorName = (String)((LeafNode)node).getUserObject();
            BaclavaIteratorNode iteratorNode = (BaclavaIteratorNode)iteratorNodes.get(iteratorName);
            if (iteratorNode == null) {
                throw new IntrospectionException("Unable to bind leaf iterator with name '" + iteratorName + "'");
            }
            return iteratorNode;
        }
        DefaultMutableTreeNode combination = null;
        combination = node instanceof DotNode ? new LockStepIteratorNode() : new JoinIteratorNode();
        Enumeration<? extends TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            combination.add((MutableTreeNode)((Object)this.iteratorForNode((MutableTreeNode)en.nextElement(), iteratorNodes)));
        }
        return (ResumableIterator)((Object)combination);
    }
}

