/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl;

import java.io.Serializable;
import org.embl.ebi.escience.scufl.DataConstraintCreationException;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.MalformedNameException;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.ScuflModelEvent;
import org.embl.ebi.escience.scufl.UnknownPortException;
import org.embl.ebi.escience.scufl.UnknownProcessorException;

public class DataConstraint
implements Serializable {
    private ScuflModel model;
    private InputPort sink;
    private OutputPort source;

    public DataConstraint(ScuflModel model, String source_name, String sink_name) throws DataConstraintCreationException, UnknownPortException, UnknownProcessorException, MalformedNameException {
        this(model, model.locatePortOrCreate(source_name, false), model.locatePortOrCreate(sink_name, true));
    }

    public Port getSource() {
        return this.source;
    }

    public Port getSink() {
        return this.sink;
    }

    public DataConstraint(ScuflModel model, Port source, Port sink) throws DataConstraintCreationException {
        if (model == null) {
            throw new DataConstraintCreationException("Must specify a non null model for data constraint creation.");
        }
        this.model = model;
        try {
            this.sink = (InputPort)sink;
        }
        catch (ClassCastException cce) {
            throw new DataConstraintCreationException("Sink port must be an instance of InputPort");
        }
        try {
            this.source = (OutputPort)source;
        }
        catch (ClassCastException cce) {
            throw new DataConstraintCreationException("Source port must be an instance of OutputPort");
        }
        if (this.source.getProcessor() == model.getWorkflowSourceProcessor()) {
            this.source.setSyntacticType(this.sink.getSyntacticType());
        } else if (this.sink.getProcessor() == model.getWorkflowSinkProcessor()) {
            this.sink.setSyntacticType(this.source.getSyntacticType());
        }
        model.fireModelEvent(new ScuflModelEvent(this, "New data constraint created, '" + this.getName() + "'"));
    }

    public String getName() {
        String from = "";
        String to = "";
        from = this.source.getProcessor() == this.model.getWorkflowSourceProcessor() ? this.source.getName() : this.source.getProcessor().getName() + ":" + this.source.getName();
        to = this.sink.getProcessor() == this.model.getWorkflowSinkProcessor() ? this.sink.getName() : this.sink.getProcessor().getName() + ":" + this.sink.getName();
        return from + "->" + to;
    }

    public String toString() {
        return this.getName();
    }
}

