/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.XScufl;
import org.jdom.Content;
import org.jdom.Element;

public class AnnotationTemplate {
    private List templateComponents = new ArrayList();
    private static final String RDF_NS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String TAVERNA_PROVENANCE_NS = "urn:lsid:net.sf.taverna:predicates:";

    public AnnotationTemplate() {
    }

    public static AnnotationTemplate standardTemplate(Port subject, String verb, Port object) {
        AnnotationTemplate target = new AnnotationTemplate();
        target.addLiteral("<rdf:Description xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" rdf:about=\"");
        target.addPortReference(subject);
        target.addLiteral("\"><" + verb + " rdf:resource=\"");
        target.addPortReference(object);
        target.addLiteral("\"/></rdf:Description>");
        return target;
    }

    public void addLiteral(String text) {
        this.templateComponents.add(text);
    }

    public void addPortReference(Port p) {
        this.templateComponents.add(new PortReference(p.getName()));
    }

    public String getTextAnnotation(Map inputs, Map outputs) {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.templateComponents.iterator();
        while (i.hasNext()) {
            Object component = i.next();
            if (component instanceof String) {
                sb.append((String)component);
                continue;
            }
            if (!(component instanceof PortReference)) continue;
            String portName = ((PortReference)component).getName();
            if (inputs.containsKey(portName)) {
                sb.append((String)inputs.get(portName));
                continue;
            }
            if (outputs.containsKey(portName)) {
                sb.append((String)outputs.get(portName));
                continue;
            }
            return null;
        }
        return sb.toString();
    }

    public AnnotationTemplate(Element templateElement) {
        Iterator i = templateElement.getChildren().iterator();
        while (i.hasNext()) {
            Element childElement = (Element)i.next();
            String name = childElement.getName();
            if (name.equals("templateLiteral")) {
                this.addLiteral(childElement.getText());
                continue;
            }
            if (!name.equals("templatePortReference")) continue;
            this.templateComponents.add(new PortReference(childElement.getAttributeValue("name")));
        }
    }

    public Element getElement() {
        Element templateElement = new Element("template", XScufl.XScuflNS);
        Iterator i = this.templateComponents.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof String) {
                Element stringElement = new Element("templateLiteral", XScufl.XScuflNS);
                stringElement.setText((String)o);
                templateElement.addContent((Content)stringElement);
                continue;
            }
            if (!(o instanceof PortReference)) continue;
            Element portElement = new Element("templatePortReference", XScufl.XScuflNS);
            portElement.setAttribute("name", ((PortReference)o).getName());
            templateElement.addContent((Content)portElement);
        }
        return templateElement;
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        Iterator i = this.templateComponents.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof String) {
                sb.append(AnnotationTemplate.convert((String)o));
                continue;
            }
            if (!(o instanceof PortReference)) continue;
            sb.append("<font color=\"purple\">");
            sb.append(((PortReference)o).getName());
            sb.append("</font>");
        }
        sb.append("</html>");
        return sb.toString();
    }

    public static String convert(String input) {
        StringBuffer sb = new StringBuffer();
        String[] parts = input.split("<");
        for (int i = 0; i < parts.length; ++i) {
            sb.append(parts[i]);
            if (i + 1 >= parts.length) continue;
            sb.append("&lt;");
        }
        return sb.toString();
    }

    class PortReference {
        private String name;

        public PortReference(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

