/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.scufl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.Port;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.UnknownPortException;

public class AlternateProcessor
implements Serializable {
    private Processor alternate;
    private Processor original;
    private Map inputMapping = new HashMap();
    private Map outputMapping = new HashMap();

    public AlternateProcessor(Processor alternate) {
        this.alternate = alternate;
        alternate.firingEvents = true;
    }

    public Processor getProcessor() {
        return this.alternate;
    }

    public Processor getOriginalProcessor() {
        return this.original;
    }

    public void setOriginalProcessor(Processor p) {
        this.original = p;
        this.alternate.parentProcessor = p;
        Port[] ports = this.original.getPorts();
        for (int i = 0; i < ports.length; ++i) {
            if ((this.inputMapping.get(ports[i].getName()) != null || !(ports[i] instanceof InputPort)) && (this.outputMapping.get(ports[i].getName()) != null || !(ports[i] instanceof OutputPort))) continue;
            try {
                Port targetPort = this.alternate.locatePort(ports[i].getName());
                if (targetPort instanceof InputPort && ports[i] instanceof InputPort) {
                    this.inputMapping.put(targetPort.getName(), targetPort.getName());
                    continue;
                }
                if (!(targetPort instanceof OutputPort) || !(ports[i] instanceof OutputPort)) continue;
                this.outputMapping.put(targetPort.getName(), targetPort.getName());
                continue;
            }
            catch (UnknownPortException upe) {
                // empty catch block
            }
        }
    }

    public Map getInputMapping() {
        return this.inputMapping;
    }

    public Map getOutputMapping() {
        return this.outputMapping;
    }

    public String toString() {
        return this.alternate.toString();
    }

    public String getPortTranslation(String alternatePort) {
        String value;
        String key;
        Iterator i = this.inputMapping.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            value = (String)this.inputMapping.get(key);
            if (value == null || !value.equalsIgnoreCase(alternatePort)) continue;
            return key;
        }
        i = this.outputMapping.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            value = (String)this.outputMapping.get(key);
            if (value == null || !value.equalsIgnoreCase(alternatePort)) continue;
            return key;
        }
        return null;
    }
}

