/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.baclava.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.baclava.factory.DataThingXMLFactory;
import org.embl.ebi.escience.scuflui.ExtensionFileFilter;
import org.embl.ebi.escience.scuflui.ResultItemPanel;
import org.embl.ebi.escience.scuflui.ScuflIcons;
import org.embl.ebi.escience.scuflui.results.ResultMapSaveRegistry;
import org.embl.ebi.escience.scuflui.results.ResultMapSaveSPI;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;

public class DataThingViewer
extends JFrame {
    private JTabbedPane tabs;
    private JToolBar toolbar;
    private Map resultMap;
    final JFileChooser fc = new JFileChooser();
    static /* synthetic */ Class class$org$embl$ebi$escience$baclava$tools$DataThingViewer;

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        DataThingViewer viewer = new DataThingViewer();
        if (args.length == 1) {
            viewer.load(new File(args[0]));
        }
    }

    public DataThingViewer() {
        super("DataThing Viewer");
        this.setBounds(100, 100, 500, 500);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.tabs = new JTabbedPane();
        this.getContentPane().add(this.tabs);
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.toolbar.setRollover(true);
        this.toolbar.setMaximumSize(new Dimension(2000, 30));
        this.toolbar.setBorderPainted(true);
        this.getContentPane().add((Component)this.toolbar, "North");
        this.toolbar.add(Box.createHorizontalGlue());
        this.setJMenuBar(this.createMenuBar());
        this.clear();
        this.setVisible(true);
    }

    private void clear() {
        this.toolbar.removeAll();
        this.tabs.removeAll();
        this.resultMap = new HashMap();
        ResultMapSaveSPI[] savePlugins = ResultMapSaveRegistry.plugins();
        for (int i = 0; i < savePlugins.length; ++i) {
            JButton saveAction = new JButton(savePlugins[i].getName(), savePlugins[i].getIcon());
            saveAction.addActionListener(savePlugins[i].getListener(this.resultMap, null));
            saveAction.setEnabled(false);
            this.toolbar.add(saveAction);
            if (i >= savePlugins.length - 1) continue;
            this.toolbar.addSeparator();
        }
    }

    private void load(File f) throws Exception {
        FileInputStream is = new FileInputStream(f);
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((InputStream)is);
        this.tabs.removeAll();
        this.resultMap = DataThingXMLFactory.parseDataDocument(doc);
        Iterator i = this.resultMap.keySet().iterator();
        while (i.hasNext()) {
            String resultName = (String)i.next();
            DataThing resultValue = (DataThing)this.resultMap.get(resultName);
            this.tabs.add(resultName, new ResultItemPanel(resultValue));
        }
        this.toolbar.removeAll();
        ResultMapSaveSPI[] savePlugins = ResultMapSaveRegistry.plugins();
        for (int i2 = 0; i2 < savePlugins.length; ++i2) {
            JButton saveAction = new JButton(savePlugins[i2].getName(), savePlugins[i2].getIcon());
            saveAction.addActionListener(savePlugins[i2].getListener(this.resultMap, null));
            this.toolbar.add(saveAction);
            if (i2 >= savePlugins.length - 1) continue;
            this.toolbar.addSeparator();
        }
        this.toolbar.add(Box.createHorizontalGlue());
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem exit = new JMenuItem("Exit");
        exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        JMenuItem reset = new JMenuItem("Reset", ScuflIcons.deleteIcon);
        reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataThingViewer.this.clear();
            }
        });
        JMenuItem load = new JMenuItem("Load", ScuflIcons.openIcon);
        load.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Preferences prefs = Preferences.userNodeForPackage(class$org$embl$ebi$escience$baclava$tools$DataThingViewer == null ? (class$org$embl$ebi$escience$baclava$tools$DataThingViewer = DataThingViewer.class$("org.embl.ebi.escience.baclava.tools.DataThingViewer")) : class$org$embl$ebi$escience$baclava$tools$DataThingViewer);
                String curDir = prefs.get("currentDir", System.getProperty("user.home"));
                DataThingViewer.this.fc.resetChoosableFileFilters();
                DataThingViewer.this.fc.setFileFilter(new ExtensionFileFilter(new String[]{"xml"}));
                DataThingViewer.this.fc.setCurrentDirectory(new File(curDir));
                int returnVal = DataThingViewer.this.fc.showOpenDialog(DataThingViewer.this);
                if (returnVal == 0) {
                    prefs.put("currentDir", DataThingViewer.this.fc.getCurrentDirectory().toString());
                    try {
                        DataThingViewer.this.load(DataThingViewer.this.fc.getSelectedFile());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(DataThingViewer.this, "Cannot open XML : \n\n" + ex.getMessage(), "Error", 0);
                    }
                }
            }
        });
        fileMenu.add(load);
        fileMenu.add(reset);
        fileMenu.add(exit);
        menuBar.add(fileMenu);
        return menuBar;
    }
}

