/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.baclava.store;

import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.baclava.LSIDProvider;
import org.embl.ebi.escience.baclava.factory.DataThingXMLFactory;
import org.embl.ebi.escience.baclava.store.BaclavaDataService;
import org.embl.ebi.escience.baclava.store.DuplicateLSIDException;
import org.embl.ebi.escience.baclava.store.NoSuchLSIDException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class RemoteSOAPStore
implements BaclavaDataService,
LSIDProvider {
    URL serviceEndpoint = null;
    static Logger log = Logger.getLogger((String)RemoteSOAPStore.class.getName());
    private Map idMap = new HashMap();
    private int nextCounter = 0;

    public RemoteSOAPStore() {
        this(System.getProperties());
    }

    public RemoteSOAPStore(Properties props) {
        String endpointString = props.getProperty("taverna.datastore.soap.endpoint");
        if (endpointString == null) {
            log.error((Object)"Property taverna.datastore.soap.endpoint is not defined, cannot\ncreate the RemoteSOAPStore proxy object.");
            throw new RuntimeException("No store configured in properties!");
        }
        try {
            this.serviceEndpoint = new URL(endpointString);
        }
        catch (MalformedURLException mue) {
            log.error((Object)"Endpoint URL is malformed", (Throwable)mue);
            throw new RuntimeException("Malformed endpoint URL!");
        }
    }

    public void storeDataThing(DataThing theDataThing, boolean silent) throws DuplicateLSIDException {
        Document doc = new Document(DataThingXMLFactory.getElement(theDataThing));
        XMLOutputter xo = new XMLOutputter(Format.getPrettyFormat());
        String stringifiedThing = xo.outputString(doc);
        try {
            Call call = (Call)new Service().createCall();
            call.setTargetEndpointAddress(this.serviceEndpoint);
            call.setOperationName(new QName("storeDataThing"));
            Boolean operationSucceeded = (Boolean)call.invoke(new Object[]{stringifiedThing, new Boolean(silent)});
            if (!operationSucceeded.booleanValue() && !silent) {
                throw new DuplicateLSIDException();
            }
        }
        catch (RemoteException re) {
            log.error((Object)"Exception when calling remote service", (Throwable)re);
            throw new RuntimeException("Failed to store datathing in SOAP store");
        }
        catch (ServiceException se) {
            log.error((Object)"Service exception when calling remote service", (Throwable)se);
            throw new RuntimeException("Service exception creating call object!");
        }
    }

    public DataThing fetchDataThing(String LSID) throws NoSuchLSIDException {
        try {
            Call call = (Call)new Service().createCall();
            call.setTargetEndpointAddress(this.serviceEndpoint);
            call.setOperationName(new QName("fetchDataThing"));
            String stringifiedThing = (String)call.invoke(new Object[]{LSID});
            try {
                DataThing theDataThing = null;
                SAXBuilder builder = new SAXBuilder(false);
                Document doc = builder.build((Reader)new StringReader(stringifiedThing));
                theDataThing = new DataThing(doc.getRootElement());
                return theDataThing;
            }
            catch (JDOMException jde) {
                log.error((Object)"Error whilst reconstructing DataThing from XML", (Throwable)jde);
                throw new NoSuchLSIDException();
            }
        }
        catch (Exception e) {
            NoSuchLSIDException nsle = new NoSuchLSIDException();
            nsle.initCause(e);
            throw nsle;
        }
    }

    public void storeMetadata(String theMetadata) {
        try {
            Call call = (Call)new Service().createCall();
            call.setTargetEndpointAddress(this.serviceEndpoint);
            call.setOperationName(new QName("storeMetadata"));
            call.invoke(new Object[]{theMetadata});
        }
        catch (RemoteException re) {
            log.error((Object)"Remote exception when storing metadata", (Throwable)re);
            throw new RuntimeException("Cannot store metadata!");
        }
        catch (ServiceException se) {
            log.error((Object)"Service exception when calling remote service", (Throwable)se);
            throw new RuntimeException("Service exception creating call object!");
        }
    }

    public String getID(LSIDProvider.NamespaceEnumeration namespaceObject) {
        String namespace = namespaceObject.toString();
        String ID = (String)this.idMap.get(namespace);
        if (ID != null) {
            return ID + this.nextCounter++;
        }
        try {
            Call call = (Call)new Service().createCall();
            call.setTargetEndpointAddress(this.serviceEndpoint);
            call.setOperationName(new QName("getID"));
            this.idMap.put(namespace, (String)call.invoke(new Object[]{namespace}));
            return (String)this.idMap.get(namespace) + this.nextCounter++;
        }
        catch (RemoteException re) {
            log.error((Object)"Remote exception when getting identifier", (Throwable)re);
            throw new RuntimeException("Cannot fetch metadata!");
        }
        catch (ServiceException se) {
            log.error((Object)"Service exception when calling remote service", (Throwable)se);
            throw new RuntimeException("Service exception creating call object!");
        }
    }

    public boolean hasData(String LSID) {
        throw new UnsupportedOperationException();
    }

    public boolean hasMetadata(String LSID) {
        throw new UnsupportedOperationException();
    }

    public String getMetadata(String LSID) {
        throw new UnsupportedOperationException();
    }
}

