/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.baclava.store;

import java.util.Enumeration;
import java.util.Hashtable;

abstract class ObjectPool {
    private long expirationTime = 30000L;
    private Hashtable locked = new Hashtable();
    private Hashtable unlocked = new Hashtable();
    int maxObjects = 10;

    abstract Object create();

    abstract boolean validate(Object var1);

    abstract void expire(Object var1);

    ObjectPool() {
    }

    synchronized Object checkOut() {
        try {
            return this.realCheckOut();
        }
        catch (Exception e) {
            while (true) {
                try {
                    Thread.sleep(2000L);
                    return this.realCheckOut();
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }

    synchronized Object realCheckOut() throws Exception {
        int currentObjects;
        Object o;
        long now = System.currentTimeMillis();
        if (this.unlocked.size() > 0) {
            Enumeration e = this.unlocked.keys();
            while (e.hasMoreElements()) {
                o = e.nextElement();
                if (now - (Long)this.unlocked.get(o) > this.expirationTime) {
                    this.unlocked.remove(o);
                    this.expire(o);
                    o = null;
                    continue;
                }
                if (this.validate(o)) {
                    this.unlocked.remove(o);
                    this.locked.put(o, new Long(now));
                    return o;
                }
                this.unlocked.remove(o);
                this.expire(o);
                o = null;
            }
        }
        if ((currentObjects = this.locked.size()) < this.maxObjects || this.maxObjects == 0) {
            o = this.create();
            this.locked.put(o, new Long(now));
            return o;
        }
        throw new Exception("Pool too big, refusing to grow");
    }

    synchronized void checkIn(Object o) {
        this.locked.remove(o);
        this.unlocked.put(o, new Long(System.currentTimeMillis()));
    }
}

