/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.baclava.store;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.baclava.LSIDProvider;
import org.embl.ebi.escience.baclava.factory.DataThingXMLFactory;
import org.embl.ebi.escience.baclava.store.BaclavaDataService;
import org.embl.ebi.escience.baclava.store.DuplicateLSIDException;
import org.embl.ebi.escience.baclava.store.JDBCConnectionPool;
import org.embl.ebi.escience.baclava.store.NoSuchLSIDException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class JDBCBaclavaDataService
implements BaclavaDataService,
LSIDProvider {
    private String connectionURL;
    private String username;
    private String password;
    private String defaultAuthority;
    private String instanceID;
    private JDBCConnectionPool pool;
    private Object connectionSetLockObject = new Object();
    private Object writeLockObject = new Object();
    private int maxConnections = 5;
    static Logger log = Logger.getLogger((String)JDBCBaclavaDataService.class.getName());

    public JDBCBaclavaDataService() {
        this(System.getProperties());
    }

    public JDBCBaclavaDataService(Properties props) {
        try {
            Class.forName(props.getProperty("taverna.datastore.jdbc.driver")).newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.defaultAuthority = props.getProperty("taverna.lsid.providerauthority");
        if (this.defaultAuthority == null) {
            this.defaultAuthority = "net.sf.taverna";
        }
        this.connectionURL = props.getProperty("taverna.datastore.jdbc.url");
        this.username = props.getProperty("taverna.datastore.jdbc.user");
        this.password = props.getProperty("taverna.datastore.jdbc.password");
        String optionalMaxConnections = props.getProperty("taverna.datastore.jdbc.pool.max");
        if (optionalMaxConnections != null) {
            try {
                this.maxConnections = Integer.parseInt(optionalMaxConnections);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        String object_id = super.toString();
        StringTokenizer st = new StringTokenizer(object_id, "@", false);
        while (st.hasMoreTokens()) {
            this.instanceID = st.nextToken();
        }
        this.pool = new JDBCConnectionPool(props.getProperty("taverna.datastore.jdbc.driver"), this.connectionURL, this.username, this.password, this.maxConnections);
        this.createTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTables() {
        Connection con = null;
        try {
            con = this.pool.borrowConnection();
            Statement st = con.createStatement();
            st.executeUpdate("CREATE TABLE IF NOT EXISTS metadata (id INT UNSIGNED NOT NULL AUTO_INCREMENT,                                     rdfstring TEXT NOT NULL,                                     PRIMARY KEY(id)) TYPE = InnoDB;");
            st.executeUpdate("CREATE TABLE IF NOT EXISTS lsid2metadata (lsid CHAR(200) NOT NULL,                                          id INT UNSIGNED NOT NULL REFERENCES metadata(id)                                          ) TYPE = InnoDB;");
            st.executeUpdate("CREATE TABLE IF NOT EXISTS datathings (id INT UNSIGNED NOT NULL AUTO_INCREMENT,                                       thing TEXT NOT NULL,                                       PRIMARY KEY(id)) TYPE = InnoDB;");
            st.executeUpdate("CREATE TABLE IF NOT EXISTS lsid2datathings (lsid CHAR(200) NOT NULL UNIQUE,                    id INT UNSIGNED NOT NULL REFERENCES datathings(id),                    reftype ENUM(\"datathing\",\"collection\",\"leaf\"),                    mimetype CHAR(200),                    PRIMARY KEY(lsid)) TYPE = InnoDB;");
            st.executeUpdate("CREATE TABLE IF NOT EXISTS idcounter (count INT UNSIGNED NOT NULL) TYPE = InnoDB;");
            this.pool.returnConnection(con);
        }
        catch (Exception ex) {
            this.pool.returnConnection(con);
            ex.printStackTrace();
        }
    }

    public void reinit() {
        this.destroyTables();
        this.createTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyTables() {
        Connection con = null;
        try {
            log.debug((Object)"Dropping tables...");
            con = this.pool.borrowConnection();
            Statement st = con.createStatement();
            st.executeUpdate("DROP TABLE IF EXISTS datathings");
            st.executeUpdate("DROP TABLE IF EXISTS lsid2datathings");
            st.executeUpdate("DROP TABLE IF EXISTS metadata");
            st.executeUpdate("DROP TABLE IF EXISTS lsid2metadata");
            st.executeUpdate("DROP TABLE IF EXISTS idcounter");
            this.pool.returnConnection(con);
            log.debug((Object)"...finished dropping tables");
        }
        catch (Exception ex) {
            this.pool.returnConnection(con);
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getID(LSIDProvider.NamespaceEnumeration namespaceObject) {
        String namespace = namespaceObject.toString();
        String prefix = "urn:lsid:" + this.defaultAuthority + ":" + namespace + ":";
        Connection con = this.pool.borrowConnection();
        try {
            Statement s = con.createStatement();
            s.executeUpdate("UPDATE idcounter SET count = count + 1");
            ResultSet rs = s.executeQuery("SELECT count FROM idcounter");
            String suffix = "1";
            if (rs.first()) {
                suffix = rs.getString("count");
            } else {
                s.executeUpdate("INSERT INTO idcounter (count) VALUES (1)");
            }
            rs.close();
            s.close();
            con.commit();
            this.pool.returnConnection(con);
            String string = prefix + suffix + this.instanceID;
            return string;
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            try {
                con.rollback();
                this.pool.returnConnection(con);
            }
            catch (SQLException sqle2) {
                this.pool.returnConnection(con);
            }
            String string = "NO_IDENTIFIER_ASSIGNED";
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMetadata(String theMetadata) {
        String[] split = theMetadata.split("\"");
        ArrayList<String> lsidList = new ArrayList<String>();
        for (int i = 0; i < split.length; ++i) {
            if (!split[i].startsWith("urn:lsid:")) continue;
            lsidList.add(split[i]);
        }
        if (lsidList.isEmpty()) {
            return;
        }
        Connection con = this.pool.borrowConnection();
        try {
            Object object = this.writeLockObject;
            synchronized (object) {
                PreparedStatement st = con.prepareStatement("INSERT INTO metadata (rdfstring) VALUES (?)");
                st.setString(1, theMetadata);
                st.executeUpdate();
                st.close();
                PreparedStatement st2 = con.prepareStatement("INSERT INTO lsid2metadata (lsid, id) VALUES (?,LAST_INSERT_ID())");
                Iterator i = lsidList.iterator();
                while (i.hasNext()) {
                    st2.setString(1, (String)i.next());
                    st2.executeUpdate();
                }
                st2.close();
                con.commit();
                this.pool.returnConnection(con);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            try {
                con.rollback();
                this.pool.returnConnection(con);
            }
            catch (Exception e) {
                this.pool.returnConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeDataThing(DataThing theDataThing, boolean silent) throws DuplicateLSIDException {
        Document doc = new Document(DataThingXMLFactory.getElement(theDataThing));
        XMLOutputter xo = new XMLOutputter(Format.getPrettyFormat());
        String xmlRepresentation = xo.outputString(doc);
        Map lsidMap = theDataThing.getLSIDMap();
        Connection con = this.pool.borrowConnection();
        try {
            Object object = this.writeLockObject;
            synchronized (object) {
                boolean addedAtLeastOneMapping = false;
                PreparedStatement st = con.prepareStatement("INSERT INTO datathings (thing) VALUES (?)");
                st.setString(1, xmlRepresentation);
                st.executeUpdate();
                st.close();
                PreparedStatement st2 = con.prepareStatement("INSERT INTO lsid2datathings (lsid, id, reftype, mimetype) VALUES (?,LAST_INSERT_ID(),?,?)");
                Iterator i = lsidMap.keySet().iterator();
                while (i.hasNext()) {
                    Object o = i.next();
                    String type = null;
                    String mimetype = null;
                    if (o instanceof DataThing) {
                        type = "datathing";
                    } else if (o instanceof Collection) {
                        type = "collection";
                    } else {
                        type = "leaf";
                        mimetype = theDataThing.getMostInterestingMIMETypeForObject(o);
                    }
                    st2.setString(1, (String)lsidMap.get(o));
                    st2.setString(2, type);
                    st2.setString(3, mimetype);
                    try {
                        st2.executeUpdate();
                        addedAtLeastOneMapping = true;
                    }
                    catch (SQLException sqle) {
                        if (silent) continue;
                        this.pool.returnConnection(con);
                        DuplicateLSIDException dle = new DuplicateLSIDException();
                        dle.initCause(sqle);
                        throw dle;
                    }
                }
                st2.close();
                if (addedAtLeastOneMapping) {
                    con.commit();
                    this.pool.returnConnection(con);
                } else {
                    con.rollback();
                    this.pool.returnConnection(con);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                con.rollback();
                this.pool.returnConnection(con);
            }
            catch (SQLException sqle) {
                this.pool.returnConnection(con);
                sqle.printStackTrace();
            }
            if (ex instanceof DuplicateLSIDException) {
                throw (DuplicateLSIDException)ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataThing fetchDataThing(String LSID) throws NoSuchLSIDException {
        log.debug((Object)("Data request for " + LSID));
        Connection con = null;
        try {
            con = this.pool.borrowConnection();
            PreparedStatement p = con.prepareStatement("SELECT t.thing FROM datathings t, lsid2datathings l WHERE t.id=l.id AND l.lsid=?");
            p.setString(1, LSID);
            ResultSet rs = p.executeQuery();
            String thingAsXML = null;
            if (!rs.first()) {
                log.debug((Object)("No data found for " + LSID));
                this.pool.returnConnection(con);
                throw new NoSuchLSIDException();
            }
            thingAsXML = rs.getString("thing");
            log.debug((Object)("Found data object for LSID " + LSID));
            this.pool.returnConnection(con);
            SAXBuilder builder = new SAXBuilder(false);
            Document doc = builder.build((Reader)new StringReader(thingAsXML));
            DataThing theThing = new DataThing(doc.getRootElement());
            Object o = theThing.getDataObjectWithLSID(LSID);
            if (o == null) {
                log.error((Object)("LSID " + LSID + " not found in retrieved data object, index broken!"));
                throw new NoSuchLSIDException();
            }
            if (o == theThing) {
                log.debug((Object)(LSID + " is a root object, returning it"));
                return theThing;
            }
            log.debug((Object)("Extracting " + LSID + " from data object and returning"));
            return theThing.extractChild(o);
        }
        catch (SQLException sqle) {
            log.error((Object)"SQL Exception caught!", (Throwable)sqle);
            this.pool.returnConnection(con);
            sqle.printStackTrace();
            throw new NoSuchLSIDException();
        }
        catch (JDOMException jde) {
            log.error((Object)"JDOM Exception caught!", (Throwable)jde);
            this.pool.returnConnection(con);
            jde.printStackTrace();
            throw new NoSuchLSIDException();
        }
        catch (IOException iOException) {
            throw new NoSuchLSIDException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasData(String suppliedLSID) {
        Connection con;
        String LSID;
        block12: {
            String refType;
            String namespace;
            block11: {
                block10: {
                    log.debug((Object)("hasData request for LSID " + suppliedLSID));
                    String[] parts = suppliedLSID.split(":");
                    namespace = parts[3];
                    LSID = suppliedLSID;
                    if (!namespace.equals("datathing")) {
                        LSID = parts[0] + ":" + parts[1] + ":" + parts[2] + ":datathing:" + parts[4];
                        if (parts.length == 6) {
                            LSID = LSID + ":" + parts[5];
                        }
                    }
                    con = null;
                    con = this.pool.borrowConnection();
                    PreparedStatement p = con.prepareStatement("SELECT id, reftype FROM lsid2datathings WHERE lsid=?");
                    p.setString(1, LSID);
                    ResultSet rs = p.executeQuery();
                    boolean hasReference = rs.first();
                    refType = null;
                    if (hasReference) {
                        refType = rs.getString("reftype");
                    }
                    rs.close();
                    p.close();
                    this.pool.returnConnection(con);
                    if (hasReference) break block10;
                    log.debug((Object)("hasData, LSID not found therefore false for LSID " + LSID));
                    boolean bl = false;
                    return bl;
                }
                if (!namespace.equals("datathing")) break block11;
                log.debug((Object)("hasData returns true as " + LSID + " is a datathing"));
                boolean bl = true;
                return bl;
            }
            if (!namespace.equals("raw") || !refType.equals("leaf")) break block12;
            log.debug((Object)("hasData returns true, " + LSID + " is a datathing leaf node"));
            boolean bl = true;
            return bl;
        }
        try {
            log.debug((Object)("hasData returns false, " + LSID + " is a collection"));
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            log.error((Object)"Exception!", (Throwable)ex);
            this.pool.returnConnection(con);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMIMEType(String LSID) {
        ResultSet rs;
        PreparedStatement p;
        Connection con;
        block5: {
            con = null;
            con = this.pool.borrowConnection();
            p = con.prepareStatement("SELECT mimetype FROM lsid2datathings WHERE lsid = ? AND reftype='leaf'");
            p.setString(1, LSID);
            rs = p.executeQuery();
            if (rs.first()) break block5;
            String string = null;
            return string;
        }
        try {
            String result = rs.getString("mimetype");
            rs.close();
            p.close();
            this.pool.returnConnection(con);
            String string = result;
            return string;
        }
        catch (SQLException sqle) {
            log.error((Object)"SQL Exception in getMIMEType!", (Throwable)sqle);
            this.pool.returnConnection(con);
            sqle.printStackTrace();
            String string = null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMetadata(String LSID) {
        String result;
        Connection con;
        block6: {
            log.debug((Object)("Metadata requested for LSID " + LSID));
            con = null;
            con = this.pool.borrowConnection();
            PreparedStatement p = con.prepareStatement("SELECT m.rdfstring FROM metadata m, lsid2metadata l WHERE l.id = m.id AND l.lsid = ?");
            p.setString(1, LSID);
            ResultSet rs = p.executeQuery();
            StringBuffer sb = new StringBuffer();
            while (rs.next()) {
                sb.append(rs.getString("rdfstring"));
            }
            result = sb.toString();
            this.pool.returnConnection(con);
            if (!result.equals("")) break block6;
            String string = null;
            return string;
        }
        try {
            String string = result;
            return string;
        }
        catch (SQLException sqle) {
            log.error((Object)"SQLException when getting provenance!", (Throwable)sqle);
            this.pool.returnConnection(con);
            sqle.printStackTrace();
            String string = null;
            return string;
        }
    }

    public boolean hasMetadata(String LSID) {
        return this.getMetadata(LSID) != null;
    }
}

