/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.baclava;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.embl.ebi.escience.baclava.ResumableIterator;

public class JoinIterator
implements ResumableIterator {
    private boolean isEmptyIterator = false;
    private ResumableIterator[] iteratorsArray;
    private boolean nextState;
    private Object[] currentState;
    private boolean initialized = false;

    public JoinIterator() {
        this.iteratorsArray = new ResumableIterator[0];
    }

    public JoinIterator(ResumableIterator[] b) {
        this.iteratorsArray = b;
        this.nextState = true;
        if (b.length == 0) {
            this.nextState = false;
        } else {
            for (int i = 0; i < b.length; ++i) {
                if (b[i].hasNext()) continue;
                this.isEmptyIterator = true;
            }
        }
    }

    public int[] getCurrentLocation() {
        ResumableIterator[] iterators = this.iterators();
        ArrayList<int[]> temp = new ArrayList<int[]>();
        for (int i = 0; i < iterators.length; ++i) {
            temp.add(iterators[i].getCurrentLocation());
        }
        return this.concatArrays(temp);
    }

    private int[] concatArrays(List listOfArrays) {
        int totalSize = 0;
        Iterator i = listOfArrays.iterator();
        while (i.hasNext()) {
            totalSize += ((int[])i.next()).length;
        }
        int[] output = new int[totalSize];
        int currentIndex = 0;
        Iterator i2 = listOfArrays.iterator();
        while (i2.hasNext()) {
            int[] source = (int[])i2.next();
            for (int j = 0; j < source.length; ++j) {
                output[currentIndex++] = source[j];
            }
        }
        return output;
    }

    ResumableIterator[] iterators() {
        return this.iteratorsArray;
    }

    boolean emptyIterator() {
        return this.isEmptyIterator;
    }

    public synchronized boolean hasNext() {
        if (this.emptyIterator()) {
            return false;
        }
        for (int i = 0; i < this.iterators().length; ++i) {
            if (!this.iterators()[i].hasNext()) continue;
            return true;
        }
        return false;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Remove operation not allowed in a JoinIterator.");
    }

    public Object next() throws NoSuchElementException {
        if (!this.initialized) {
            this.currentState = new Object[this.iterators().length];
            for (int i = 0; i < this.iterators().length; ++i) {
                this.currentState[i] = this.iterators()[i].next();
            }
            this.initialized = true;
            return this.currentState;
        }
        int iteratorNumber = this.iterators().length - 1;
        boolean doneRolling = false;
        while (!doneRolling && iteratorNumber >= 0) {
            if (this.iterators()[iteratorNumber].hasNext()) {
                this.currentState[iteratorNumber] = this.iterators()[iteratorNumber].next();
                doneRolling = true;
                continue;
            }
            this.iterators()[iteratorNumber].reset();
            this.currentState[iteratorNumber] = this.iterators()[iteratorNumber].next();
            --iteratorNumber;
        }
        if (!doneRolling) {
            throw new NoSuchElementException("Reached end of join iterator");
        }
        return this.currentState;
    }

    public int size() {
        int size = 1;
        for (int i = 0; i < this.iterators().length; ++i) {
            size *= this.iterators()[i].size();
        }
        return size;
    }

    public void reset() {
        for (int i = 0; i < this.iterators().length; ++i) {
            this.iterators()[i].reset();
        }
        this.initialized = false;
    }
}

