/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.baclava;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.embl.ebi.escience.baclava.BaclavaIteratorNode;
import org.embl.ebi.escience.baclava.DataThing;
import org.embl.ebi.escience.baclava.JoinIteratorNode;
import org.embl.ebi.escience.baclava.LockStepIteratorNode;
import org.embl.ebi.escience.baclava.ResumableIterator;

public class IteratorNodeTests {
    public static List colours = new ArrayList();
    public static List shapes;
    public static List animals;

    public static void main(String[] args) {
        try {
            System.out.println("\nBasic iterator node test");
            DataThing coloursThing = new DataThing(colours);
            DataThing animalsThing = new DataThing(animals);
            DataThing shapesThing = new DataThing(shapes);
            IteratorNodeTests.printIterator(new BaclavaIteratorNode(coloursThing.iterator("''"), "Colour"));
            System.out.println("\nCross product test (colour*shape)");
            DefaultMutableTreeNode t = new JoinIteratorNode();
            t.insert(new BaclavaIteratorNode(coloursThing.iterator("''"), "Colour"), 0);
            t.insert(new BaclavaIteratorNode(shapesThing.iterator("''"), "Shape"), 0);
            IteratorNodeTests.printIterator((ResumableIterator)((Object)t));
            System.out.println("\nAdding another iterator to that lot (colour*animal*shape)");
            t.insert(new BaclavaIteratorNode(animalsThing.iterator("''"), "Animal"), 0);
            IteratorNodeTests.printIterator((ResumableIterator)((Object)t));
            System.out.println("\nDot product test (colour.animal)");
            t = new LockStepIteratorNode();
            t.insert(new BaclavaIteratorNode(coloursThing.iterator("''"), "Colour"), 0);
            t.insert(new BaclavaIteratorNode(animalsThing.iterator("''"), "Animal"), 0);
            IteratorNodeTests.printIterator((ResumableIterator)((Object)t));
            System.out.println("\nCombined ((colour.animal)*shape)");
            JoinIteratorNode t2 = new JoinIteratorNode();
            t2.insert(t, 0);
            t2.insert(new BaclavaIteratorNode(shapesThing.iterator("''"), "Shape"), 0);
            IteratorNodeTests.printIterator(t2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void printIterator(ResumableIterator i) {
        System.out.println("Iterator is of class " + i.getClass().toString().split("\\.")[5] + ", " + i.size() + " elements, " + ((TreeNode)((Object)i)).getChildCount() + " children.");
        while (i.hasNext()) {
            HashMap display = new HashMap();
            Map current = (Map)i.next();
            Iterator k = current.keySet().iterator();
            while (k.hasNext()) {
                Object key = k.next();
                if (current.get(key) instanceof DataThing) {
                    DataThing thing = (DataThing)current.get(key);
                    display.put(key, thing.getDataObject());
                    continue;
                }
                display.put(key, current.get(key));
            }
            int[] location = i.getCurrentLocation();
            StringBuffer sb = new StringBuffer("[");
            for (int j = 0; j < location.length; ++j) {
                if (j != 0) {
                    sb.append(",");
                }
                sb.append("" + location[j]);
            }
            sb.append("]");
            System.out.println(display + " at location " + sb.toString());
        }
    }

    static {
        colours.add("Red");
        colours.add("Green");
        shapes = new ArrayList();
        shapes.add("Square");
        shapes.add("Triangle");
        animals = new ArrayList();
        animals.add("Cat");
        animals.add("Mouse");
    }
}

