/*
 * Decompiled with CFR 0.152.
 */
package org.embl.ebi.escience.baclava;

import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import org.embl.ebi.escience.baclava.BaclavaIterator;
import org.embl.ebi.escience.baclava.LSIDProvider;
import org.embl.ebi.escience.baclava.NoMetadataFoundException;
import org.embl.ebi.escience.baclava.factory.DataThingFactory;
import org.embl.ebi.escience.baclava.factory.DataThingXMLFactory;
import org.embl.ebi.escience.scufl.SemanticMarkup;
import org.jdom.Element;

public class DataThing {
    protected Object theDataObject;
    protected HashMap metadataMap = new HashMap();
    protected SemanticMarkup myMarkup;
    protected HashMap lsid = new HashMap();
    public static LSIDProvider SYSTEM_DEFAULT_LSID_PROVIDER = null;
    private static String[] interestingTypes = new String[]{"text/html", "text/xml", "text/rtf", "text/x-graphviz", "image/png", "image/jpeg", "image/gif", "application/zip", "text/plain"};
    static char sep;

    public DataThing(DataThing other) {
        this.theDataObject = other.theDataObject;
        this.metadataMap.putAll(other.metadataMap);
        this.myMarkup = new SemanticMarkup(other.myMarkup);
        this.lsid.putAll(other.lsid);
    }

    public DataThing(Element e) {
        this.myMarkup = new SemanticMarkup(this);
        this.theDataObject = DataThingXMLFactory.configureDataThing(e, this);
    }

    public Map getLSIDMap() {
        return this.lsid;
    }

    public void fillLSIDValues() {
        if (SYSTEM_DEFAULT_LSID_PROVIDER != null) {
            try {
                this.fillLSIDValues(SYSTEM_DEFAULT_LSID_PROVIDER);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    public void fillLSIDValues(LSIDProvider provider) {
        String selfValue = (String)this.lsid.get(this);
        if (selfValue == null || selfValue.equals("")) {
            // empty if block
        }
        this.doInternalLSIDFill(this.theDataObject, provider);
    }

    private void doInternalLSIDFill(Object o, LSIDProvider provider) {
        String lsidValue = (String)this.lsid.get(o);
        if (lsidValue == null || lsidValue.equals("")) {
            if (o instanceof Collection) {
                this.lsid.put(o, provider.getID(LSIDProvider.DATATHINGCOLLECTION));
            } else {
                this.lsid.put(o, provider.getID(LSIDProvider.DATATHINGLEAF));
            }
        }
        if (o instanceof Collection) {
            Iterator i = ((Collection)o).iterator();
            while (i.hasNext()) {
                this.doInternalLSIDFill(i.next(), provider);
            }
        } else {
            return;
        }
    }

    public void setLSID(Object target, String id) {
        if (id != null) {
            this.lsid.put(target, id);
        }
    }

    public String getLSID(Object target) {
        return this.lsid.get(target) != null ? (String)this.lsid.get(target) : "";
    }

    public Object getDataObjectWithLSID(String LSID) {
        Iterator i = this.lsid.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = this.lsid.get(key);
            if (!((String)value).equals(LSID)) continue;
            return key;
        }
        return null;
    }

    public String[] getAllLSIDs() {
        return this.lsid.values().toArray(new String[0]);
    }

    public DataThing(Object o) {
        if (o == null) {
            throw new RuntimeException("Attempt to create a null data object, definitely not allowed!");
        }
        this.theDataObject = DataThingFactory.convertObject(o);
        this.myMarkup = new SemanticMarkup(this);
    }

    public ImageIcon getIcon() {
        String baseMIMEType = this.getSyntacticType().split("'")[1].toLowerCase().split("/")[0];
        return new ImageIcon(ClassLoader.getSystemResource("org/embl/ebi/escience/baclava/icons/" + baseMIMEType + ".png"));
    }

    public SemanticMarkup getMetadata() {
        return this.myMarkup;
    }

    public Object getDataObject() {
        return this.theDataObject;
    }

    public String getSyntacticType() {
        return this.getSyntacticTypeForObject(this.theDataObject);
    }

    public String getMostInterestingMIMETypeForObject(Object o) {
        String typeString = this.getSyntacticTypeForObject(o);
        String mimeTypes = typeString.split("'")[1].toLowerCase();
        for (int i = 0; i < interestingTypes.length; ++i) {
            if (!mimeTypes.matches(".*" + interestingTypes[i] + ".*")) continue;
            return interestingTypes[i];
        }
        try {
            return mimeTypes.split(",")[0];
        }
        catch (Exception ex) {
            return "null";
        }
    }

    public String getSyntacticTypeForObject(Object o) {
        if (o instanceof Collection) {
            if (((Collection)o).isEmpty()) {
                if (o instanceof Set) {
                    return "s('null')";
                }
                return "l('null')";
            }
            Object innerObject = ((Collection)o).iterator().next();
            if (o instanceof Set) {
                return "s(" + this.getSyntacticTypeForObject(innerObject) + ")";
            }
            if (o instanceof List) {
                return "l(" + this.getSyntacticTypeForObject(innerObject) + ")";
            }
            return "p(" + this.getSyntacticTypeForObject(innerObject) + ")";
        }
        try {
            SemanticMarkup markup = this.getMetadataForObject(o, false);
            List mimeTypeList = markup.getMIMETypeList();
            if (mimeTypeList.isEmpty()) {
                throw new NoMetadataFoundException();
            }
            StringBuffer sb = new StringBuffer();
            sb.append("'");
            Iterator i = mimeTypeList.iterator();
            while (i.hasNext()) {
                String mimeType = (String)i.next();
                sb.append(mimeType);
                if (!i.hasNext()) continue;
                sb.append(",");
            }
            sb.append("'");
            return sb.toString();
        }
        catch (NoMetadataFoundException nmfe) {
            StringBuffer sb = new StringBuffer();
            if (o instanceof String) {
                this.getMetadata().addMIMEType("text/plain");
            } else if (o instanceof byte[]) {
                this.getMetadata().addMIMEType("application/octet-stream");
            } else {
                this.getMetadata().addMIMEType("application/X-UNKNOWN-JAVA-TYPE-" + o.getClass().getName());
            }
            Iterator i = this.getMetadata().getMIMETypeList().iterator();
            while (i.hasNext()) {
                sb.append((String)i.next());
                if (!i.hasNext()) continue;
                sb.append(",");
            }
            String specifiedMIMETypes = sb.toString();
            return "'" + specifiedMIMETypes + "'";
        }
    }

    public void copyMetadataFrom(DataThing source) {
        this.lsid.putAll(source.lsid);
        this.metadataMap.putAll(source.metadataMap);
    }

    public SemanticMarkup getMetadataForObject(Object theObject, boolean supplyDefault) throws NoMetadataFoundException {
        WeakReference ref = (WeakReference)this.metadataMap.get(theObject);
        if (ref != null) {
            return (SemanticMarkup)ref.get();
        }
        if (!supplyDefault) {
            throw new NoMetadataFoundException("No metadata available");
        }
        SemanticMarkup theMarkup = new SemanticMarkup(theObject);
        this.metadataMap.put(theObject, new WeakReference<SemanticMarkup>(theMarkup));
        return theMarkup;
    }

    public Element getElement() {
        return DataThingXMLFactory.getElement(this);
    }

    public DataThing extractChild(Object child) {
        DataThing result = new DataThing(this);
        result.theDataObject = child;
        return result;
    }

    public Iterator childIterator() {
        if (this.theDataObject instanceof Collection) {
            ArrayList<DataThing> dataThingList = new ArrayList<DataThing>();
            Iterator i = ((Collection)this.theDataObject).iterator();
            while (i.hasNext()) {
                dataThingList.add(this.extractChild(i.next()));
            }
            return dataThingList.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public BaclavaIterator iterator(String desiredType) throws IntrospectionException {
        String type = null;
        String currentType = null;
        try {
            type = desiredType.split("\\'")[0];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            type = "";
        }
        try {
            currentType = this.getSyntacticType().split("\\'")[0];
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            currentType = "";
        }
        if (type.equals(currentType)) {
            ArrayList<DataThing> dataThingList = new ArrayList<DataThing>();
            dataThingList.add(this);
            return new BaclavaIterator(dataThingList);
        }
        if (type.equals("") || currentType.endsWith(type)) {
            int iterationDepth = (currentType.length() - type.length()) / 2;
            ArrayList targetList = new ArrayList();
            ArrayList indexList = new ArrayList();
            this.drill(iterationDepth, targetList, indexList, new int[0], (Collection)this.theDataObject);
            ArrayList<DataThing> dataThingList = new ArrayList<DataThing>();
            Iterator i = targetList.iterator();
            while (i.hasNext()) {
                DataThing newThing = new DataThing(i.next());
                newThing.metadataMap.putAll(this.metadataMap);
                newThing.lsid.putAll(this.lsid);
                dataThingList.add(newThing);
            }
            return new BaclavaIterator(dataThingList, indexList);
        }
        throw new IntrospectionException("Incompatible types for iterator, cannot extract " + type + " from " + this.getSyntacticType());
    }

    private void drill(int iterationDepth, List targetList, List indexList, int[] currentIndex, Collection theDataObject) {
        if (iterationDepth == 1) {
            int localIndex = 0;
            Iterator i = theDataObject.iterator();
            while (i.hasNext()) {
                targetList.add(i.next());
                indexList.add(this.append(currentIndex, localIndex++));
            }
        } else {
            int localIndex = 0;
            Iterator i = theDataObject.iterator();
            while (i.hasNext()) {
                Collection theCollection = (Collection)i.next();
                this.drill(iterationDepth - 1, targetList, indexList, this.append(currentIndex, localIndex++), theCollection);
            }
        }
    }

    private int[] append(int[] list, int head) {
        int[] newlist = new int[list.length + 1];
        for (int i = 0; i < list.length; ++i) {
            newlist[i] = list[i];
        }
        newlist[list.length] = head;
        return newlist;
    }

    public String toString() {
        String datStr = this.theDataObject.toString();
        boolean trimmed = false;
        int nl = datStr.indexOf(10);
        if (nl > -1) {
            datStr = datStr.substring(0, nl);
            trimmed = true;
        }
        if (datStr.length() > 30) {
            datStr = datStr.substring(0, 27);
            trimmed = true;
        }
        if (trimmed) {
            datStr = datStr + "...";
        }
        return super.toString() + "\n\tValue=" + datStr + "\n\tLSID=" + this.getLSID(this.theDataObject) + "\n";
    }

    public File writeToFileSystem(File destination, String name) throws IOException {
        String lastPart;
        String interestingType = this.getMostInterestingMIMETypeForObject(this.theDataObject);
        String fileExtension = ".text";
        if (interestingType != null && !interestingType.equals("text/plain") && !(lastPart = interestingType.split("/")[1]).startsWith("x-")) {
            fileExtension = "." + lastPart;
        }
        File writtenFile = DataThing.writeObjectToFileSystem(destination, name, this.theDataObject, fileExtension);
        return writtenFile;
    }

    public static File writeObjectToFileSystem(File destination, String name, Object o, String defaultExtension) throws IOException {
        if (destination.exists() && destination.isFile()) {
            name = destination.getName();
            destination = destination.getParentFile();
        }
        if (!destination.exists()) {
            destination.mkdirs();
        }
        File writtenFile = DataThing.writeDataObject(destination, name, o, defaultExtension);
        return writtenFile;
    }

    private static File writeDataObject(File destination, String name, Object o, String defaultExtension) throws IOException {
        if (o instanceof Collection) {
            File targetDir = new File(destination.toString() + sep + name);
            targetDir.mkdir();
            int count = 0;
            Collection c = (Collection)o;
            Iterator i = c.iterator();
            while (i.hasNext()) {
                DataThing.writeDataObject(targetDir, "" + count++, i.next(), defaultExtension);
            }
            return targetDir;
        }
        if (o instanceof String && defaultExtension == null) {
            name = name + ".text";
        } else if (defaultExtension != null) {
            name = name + defaultExtension;
        }
        File targetFile = new File(destination.toString() + sep + name);
        FileOutputStream fos = new FileOutputStream(targetFile);
        if (o instanceof byte[]) {
            fos.write((byte[])o);
            fos.flush();
            fos.close();
        } else if (o instanceof String) {
            PrintWriter out = new PrintWriter(new OutputStreamWriter(fos));
            out.print((String)o);
            out.flush();
            out.close();
        }
        return targetFile;
    }

    static {
        String providerClassName = System.getProperty("taverna.lsid.providerclass");
        if (providerClassName != null) {
            try {
                Class<?> providerClass = Class.forName(providerClassName);
                SYSTEM_DEFAULT_LSID_PROVIDER = (LSIDProvider)providerClass.newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        sep = File.separatorChar;
    }
}

