/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.HashMap;

public final class Type {
    public static final short A = 1;
    public static final short NS = 2;
    public static final short MD = 3;
    public static final short MF = 4;
    public static final short CNAME = 5;
    public static final short SOA = 6;
    public static final short MB = 7;
    public static final short MG = 8;
    public static final short MR = 9;
    public static final short NULL = 10;
    public static final short WKS = 11;
    public static final short PTR = 12;
    public static final short HINFO = 13;
    public static final short MINFO = 14;
    public static final short MX = 15;
    public static final short TXT = 16;
    public static final short RP = 17;
    public static final short AFSDB = 18;
    public static final short X25 = 19;
    public static final short ISDN = 20;
    public static final short RT = 21;
    public static final short NSAP = 22;
    public static final short NSAP_PTR = 23;
    public static final short SIG = 24;
    public static final short KEY = 25;
    public static final short PX = 26;
    public static final short GPOS = 27;
    public static final short AAAA = 28;
    public static final short LOC = 29;
    public static final short NXT = 30;
    public static final short EID = 31;
    public static final short NIMLOC = 32;
    public static final short SRV = 33;
    public static final short ATMA = 34;
    public static final short NAPTR = 35;
    public static final short KX = 36;
    public static final short CERT = 37;
    public static final short A6 = 38;
    public static final short DNAME = 39;
    public static final short OPT = 41;
    public static final short APL = 42;
    public static final short DS = 43;
    public static final short TKEY = 249;
    public static final short TSIG = 250;
    public static final short IXFR = 251;
    public static final short AXFR = 252;
    public static final short MAILB = 253;
    public static final short MAILA = 254;
    public static final short ANY = 255;
    private static DoubleHashMap types = new DoubleHashMap();
    private static Short[] typecache = new Short[44];

    private Type() {
    }

    public static String string(short i) {
        String s = types.getString(i);
        return s != null ? s : "TYPE" + i;
    }

    public static short value(String s) {
        Short val = types.getValue(s.toUpperCase());
        if (val != null) {
            return val;
        }
        try {
            if (s.toUpperCase().startsWith("TYPE")) {
                return Short.parseShort(s.substring(4));
            }
            return Short.parseShort(s);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static boolean isRR(int type) {
        switch (type) {
            case 41: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: {
                return false;
            }
        }
        return true;
    }

    static Short toShort(short type) {
        if (type < typecache.length) {
            return typecache[type];
        }
        return new Short(type);
    }

    static {
        short i = 0;
        while (i < typecache.length) {
            Type.typecache[i] = new Short(i);
            i = (short)(i + 1);
        }
        types.put((short)1, "A");
        types.put((short)2, "NS");
        types.put((short)3, "MD");
        types.put((short)4, "MF");
        types.put((short)5, "CNAME");
        types.put((short)6, "SOA");
        types.put((short)7, "MB");
        types.put((short)8, "MG");
        types.put((short)9, "MR");
        types.put((short)10, "NULL");
        types.put((short)11, "WKS");
        types.put((short)12, "PTR");
        types.put((short)13, "HINFO");
        types.put((short)14, "MINFO");
        types.put((short)15, "MX");
        types.put((short)16, "TXT");
        types.put((short)17, "RP");
        types.put((short)18, "AFSDB");
        types.put((short)19, "X25");
        types.put((short)20, "ISDN");
        types.put((short)21, "RT");
        types.put((short)22, "NSAP");
        types.put((short)23, "NSAP_PTR");
        types.put((short)24, "SIG");
        types.put((short)25, "KEY");
        types.put((short)26, "PX");
        types.put((short)27, "GPOS");
        types.put((short)28, "AAAA");
        types.put((short)29, "LOC");
        types.put((short)30, "NXT");
        types.put((short)31, "EID");
        types.put((short)32, "NIMLOC");
        types.put((short)33, "SRV");
        types.put((short)34, "ATMA");
        types.put((short)35, "NAPTR");
        types.put((short)36, "KX");
        types.put((short)37, "CERT");
        types.put((short)38, "A6");
        types.put((short)39, "DNAME");
        types.put((short)41, "OPT");
        types.put((short)42, "APL");
        types.put((short)43, "DS");
        types.put((short)249, "TKEY");
        types.put((short)250, "TSIG");
        types.put((short)251, "IXFR");
        types.put((short)252, "AXFR");
        types.put((short)253, "MAILB");
        types.put((short)254, "MAILA");
        types.put((short)255, "ANY");
    }

    private static class DoubleHashMap {
        private HashMap v2s = new HashMap();
        private HashMap s2v = new HashMap();

        public void put(short value, String string) {
            Short s = Type.toShort(value);
            this.v2s.put(s, string);
            this.s2v.put(string, s);
        }

        public Short getValue(String string) {
            return (Short)this.s2v.get(string);
        }

        public String getString(short value) {
            return (String)this.v2s.get(Type.toShort(value));
        }
    }
}

