/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class NAPTRRecord
extends Record {
    private static NAPTRRecord member = new NAPTRRecord();
    private short order;
    private short preference;
    private String flags;
    private String service;
    private String regexp;
    private Name replacement;

    private NAPTRRecord() {
    }

    private NAPTRRecord(Name name, short dclass, int ttl) {
        super(name, (short)35, dclass, ttl);
    }

    static NAPTRRecord getMember() {
        return member;
    }

    public NAPTRRecord(Name name, short dclass, int ttl, int order, int preference, String flags, String service, String regexp, Name replacement) {
        this(name, dclass, ttl);
        this.order = (short)order;
        this.preference = (short)preference;
        this.flags = flags;
        this.service = service;
        this.regexp = regexp;
        this.replacement = replacement;
    }

    Record rrFromWire(Name name, short type, short dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        NAPTRRecord rec = new NAPTRRecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        rec.order = (short)in.readUnsignedShort();
        rec.preference = (short)in.readUnsignedShort();
        rec.flags = in.readString();
        rec.service = in.readString();
        rec.regexp = in.readString();
        rec.replacement = new Name(in);
        return rec;
    }

    Record rdataFromString(Name name, short dclass, int ttl, MyStringTokenizer st, Name origin) throws TextParseException {
        NAPTRRecord rec = new NAPTRRecord(name, dclass, ttl);
        rec.order = Short.parseShort(st.nextToken());
        rec.preference = Short.parseShort(st.nextToken());
        rec.flags = st.nextToken();
        rec.service = st.nextToken();
        rec.regexp = st.nextToken();
        rec.replacement = Name.fromString(st.nextToken(), origin);
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.replacement != null) {
            sb.append(this.order);
            sb.append(" ");
            sb.append(this.preference);
            sb.append(" ");
            sb.append(this.flags);
            sb.append(" ");
            sb.append(this.service);
            sb.append(" ");
            sb.append(this.regexp);
            sb.append(" ");
            sb.append(this.replacement);
        }
        return sb.toString();
    }

    public short getOrder() {
        return this.order;
    }

    public short getPreference() {
        return this.preference;
    }

    public String getFlags() {
        return this.flags;
    }

    public String getService() {
        return this.service;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public Name getReplacement() {
        return this.replacement;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.replacement == null && this.regexp == null) {
            return;
        }
        out.writeShort(this.order);
        out.writeShort(this.preference);
        out.writeString(this.flags);
        out.writeString(this.service);
        out.writeString(this.regexp);
        this.replacement.toWire(out, null, canonical);
    }

    public Name getAdditionalName() {
        return this.replacement;
    }
}

