/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.rdf.converters;

import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.IURIGenerator;
import edu.mit.lcs.haystack.rdf.LocalRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;
import edu.mit.lcs.haystack.rdf.converters.IParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;

public abstract class TextParser
implements IParser {
    URL parseURL;
    private Charset charset;

    protected static void parseFile(String[] args, TextParser parser) throws Exception {
        File file = new File(args[0]);
        if (!file.exists()) {
            System.out.println("Usage: ...Parser filename");
            System.exit(-1);
        }
        System.out.print("Parsing...");
        URL url = file.toURL();
        LocalRDFContainer rdf = new LocalRDFContainer();
        Resource result = parser.parse(url, (IRDFContainer)rdf);
        System.out.println("Finished. Parser returned URI: " + result);
        System.out.print("Writing...");
        file = new File(String.valueOf(args[0].substring(0, args[0].lastIndexOf("."))) + ".rdf");
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        Utilities.generateRDF((IRDFContainer)rdf, out);
        ((Writer)out).close();
        System.out.println("finished writing file: " + file);
    }

    public TextParser() {
    }

    public TextParser(Charset charset) {
        this.charset = charset;
    }

    public Resource parse(Resource res, IRDFContainer target) throws RDFException, IOException {
        return this.parse(new URL(res.getURI()), target);
    }

    public Resource parse(URL url, IRDFContainer target) throws RDFException, IOException {
        this.parseURL = url;
        URLConnection connection = url.openConnection();
        if (this.charset == null) {
            this.charset = Charset.forName("UTF-8");
        }
        InputStreamReader reader = new InputStreamReader(connection.getInputStream(), this.charset);
        return this.internalParse(reader, target);
    }

    public Resource parse(InputStream is, IRDFContainer target) throws RDFException, IOException {
        return this.internalParse(new InputStreamReader(is), target);
    }

    public Resource parse(Reader r, IRDFContainer target) throws RDFException, IOException {
        return this.internalParse(r, target);
    }

    public Resource parse(String s, IRDFContainer target) throws RDFException, IOException {
        return this.internalParse(new StringReader(s), target);
    }

    public void parse(Resource res, InputStream is, IRDFContainer target, IURIGenerator uirg) throws RDFException, IOException {
        this.internalParse(new InputStreamReader(is), target);
    }

    protected Resource internalParse(Reader reader, IRDFContainer target) throws RDFException, IOException {
        return null;
    }
}

