/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.rdf;

import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class LocalRDFContainer
implements IRDFContainer,
Serializable {
    Set data = new HashSet();

    public LocalRDFContainer() {
    }

    public LocalRDFContainer(Statement[] statements) {
        try {
            int i = 0;
            while (i < statements.length) {
                this.add(statements[i]);
                ++i;
            }
        }
        catch (RDFException rDFException) {
            // empty catch block
        }
    }

    public void add(Statement s) throws RDFException {
        this.data.add(s);
    }

    public void add(Resource subject, Resource predicate, RDFNode object) throws RDFException {
        this.data.add(new Statement(subject, predicate, object));
    }

    public String toString() {
        return this.getClass() + " - " + this.size() + " statements";
    }

    public void add(IRDFContainer c) throws RDFException {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.add((Statement)i.next());
        }
    }

    public void remove(Statement pattern, Resource[] existentials) throws RDFException {
        Iterator i = this.data.iterator();
        HashSet<Statement> toRemove = new HashSet<Statement>();
        while (i.hasNext()) {
            Statement s = (Statement)i.next();
            if (!this.matchStatement(s, pattern, existentials)) continue;
            toRemove.add(s);
        }
        this.data.removeAll(toRemove);
    }

    public RDFNode extract(Resource subject, Resource predicate, RDFNode object) throws RDFException {
        boolean nullObj;
        boolean nullPred;
        boolean nullSubj = subject == null;
        if ((nullSubj ? 1 : 0) + ((nullPred = predicate == null) ? 1 : 0) + ((nullObj = object == null) ? 1 : 0) != 1) {
            throw new RDFException("extract expects exactly one null parameter");
        }
        Iterator i = this.data.iterator();
        while (i.hasNext()) {
            Statement s = (Statement)i.next();
            if (!nullSubj && !s.getSubject().equals(subject) || !nullPred && !s.getPredicate().equals(predicate) || !nullObj && !s.getObject().equals(object)) continue;
            return nullSubj ? s.getSubject() : (nullPred ? s.getPredicate() : s.getObject());
        }
        return null;
    }

    public Set query(Statement[] query, Resource[] variables, Resource[] existentials) throws RDFException {
        existentials = Utilities.combineResourceArrays(variables, existentials);
        Set currentResults = new HashSet();
        ArrayList currentVariables = new ArrayList();
        int i = 0;
        while (i < query.length) {
            Statement pattern = query[i];
            Set newResults = this.queryInternal(pattern, existentials);
            ArrayList<RDFNode> currentQueryVars = new ArrayList<RDFNode>();
            if (Utilities.containsResource(existentials, pattern.getSubject())) {
                currentQueryVars.add(pattern.getSubject());
            }
            if (Utilities.containsResource(existentials, pattern.getPredicate()) && !currentQueryVars.contains(pattern.getPredicate())) {
                currentQueryVars.add(pattern.getPredicate());
            }
            if (Utilities.containsResource(existentials, pattern.getObject()) && !currentQueryVars.contains(pattern.getObject())) {
                currentQueryVars.add(pattern.getObject());
            }
            if (currentVariables.isEmpty()) {
                currentVariables = currentQueryVars;
                currentResults = newResults;
            } else {
                HashSet<RDFNode> s2 = new HashSet<RDFNode>();
                s2.addAll(currentQueryVars);
                s2.addAll(currentVariables);
                ArrayList<RDFNode> newVariables = new ArrayList<RDFNode>();
                newVariables.addAll(s2);
                HashSet<RDFNode[]> newResults2 = new HashSet<RDFNode[]>();
                Iterator j = newResults.iterator();
                while (j.hasNext()) {
                    RDFNode[] datum1 = (RDFNode[])j.next();
                    Iterator k = currentResults.iterator();
                    block2: while (k.hasNext()) {
                        RDFNode[] datum2 = (RDFNode[])k.next();
                        RDFNode[] newDatum = new RDFNode[newVariables.size()];
                        int l = 0;
                        while (l < newVariables.size()) {
                            Resource var = (Resource)newVariables.get(l);
                            int newIndex = currentQueryVars.indexOf(var);
                            int oldIndex = currentVariables.indexOf(var);
                            if (newIndex == -1 && oldIndex >= 0) {
                                newDatum[l] = datum2[oldIndex];
                            } else if (oldIndex == -1 && newIndex >= 0) {
                                newDatum[l] = datum1[newIndex];
                            } else if (oldIndex >= 0 && newIndex >= 0) {
                                if (!datum1[newIndex].equals(datum2[oldIndex])) continue block2;
                                newDatum[l] = datum1[newIndex];
                            }
                            ++l;
                        }
                        newResults2.add(newDatum);
                    }
                }
                currentResults = newResults2;
                currentVariables = newVariables;
            }
            ++i;
        }
        HashSet<RDFNode[]> results = new HashSet<RDFNode[]>();
        Iterator l = currentResults.iterator();
        while (l.hasNext()) {
            RDFNode[] datum1 = (RDFNode[])l.next();
            RDFNode[] datum2 = new RDFNode[variables.length];
            int j = 0;
            while (j < variables.length) {
                int k = currentVariables.indexOf(variables[j]);
                datum2[j] = k == -1 ? null : datum1[k];
                ++j;
            }
            results.add(datum2);
        }
        return results;
    }

    protected boolean matchStatement(Statement s, Statement pattern, Resource[] existentials) {
        boolean anonSubject = Utilities.containsResource(existentials, pattern.getSubject());
        if (!anonSubject && !pattern.getSubject().equals(s.getSubject())) {
            return false;
        }
        boolean anonPredicate = Utilities.containsResource(existentials, pattern.getPredicate());
        if (!anonPredicate && !pattern.getPredicate().equals(s.getPredicate())) {
            return false;
        }
        boolean anonObject = Utilities.containsResource(existentials, pattern.getObject());
        if (!anonObject && !pattern.getObject().equals(s.getObject())) {
            return false;
        }
        if (anonSubject) {
            if (anonPredicate && pattern.getSubject().equals(pattern.getPredicate()) && !s.getSubject().equals(s.getPredicate())) {
                return false;
            }
            if (anonObject && pattern.getSubject().equals(pattern.getObject()) && !s.getSubject().equals(s.getObject())) {
                return false;
            }
        }
        return !anonPredicate || !anonObject || !pattern.getPredicate().equals(pattern.getObject()) || s.getPredicate().equals(s.getObject());
    }

    public Set query(Statement s, Resource[] existentials) throws RDFException {
        return this.query(new Statement[]{s}, existentials, existentials);
    }

    protected Set queryInternal(Statement pattern, Resource[] existentials) throws RDFException {
        int c;
        Iterator i = this.data.iterator();
        HashSet<RDFNode> variables = new HashSet<RDFNode>();
        boolean anonSubject = Utilities.containsResource(existentials, pattern.getSubject());
        boolean anonPredicate = Utilities.containsResource(existentials, pattern.getPredicate());
        boolean anonObject = Utilities.containsResource(existentials, pattern.getObject());
        if (anonSubject) {
            variables.add(pattern.getSubject());
        }
        if (anonPredicate) {
            variables.add(pattern.getPredicate());
        }
        if (anonObject) {
            variables.add(pattern.getObject());
        }
        if ((c = variables.size()) == 0) {
            return new HashSet();
        }
        HashSet<RDFNode[]> results = new HashSet<RDFNode[]>();
        while (i.hasNext()) {
            Statement s = (Statement)i.next();
            if (!this.matchStatement(s, pattern, existentials)) continue;
            RDFNode[] row = new RDFNode[c];
            int j = 0;
            HashSet<Resource> s0 = new HashSet<Resource>();
            if (anonSubject) {
                row[j++] = s.getSubject();
                s0.add(pattern.getSubject());
            }
            if (anonPredicate && !s0.contains(pattern.getPredicate())) {
                row[j++] = s.getPredicate();
                s0.add(pattern.getPredicate());
            }
            if (anonObject && !s0.contains(pattern.getObject())) {
                row[j++] = s.getObject();
            }
            results.add(row);
        }
        return results;
    }

    public int size() {
        return this.data.size();
    }

    public Iterator iterator() {
        return this.data.iterator();
    }

    public boolean contains(Statement s) throws RDFException {
        return this.data.contains(s);
    }

    public Resource[] getAuthoredStatementIDs(Resource author) throws RDFException {
        return null;
    }

    public Statement[] getAuthoredStatements(Resource author) throws RDFException {
        return null;
    }

    public Resource[] getAuthors(Resource id) throws RDFException {
        return null;
    }

    public Resource[] getAuthors(Statement s) throws RDFException {
        return null;
    }

    public Statement getStatement(Resource id) throws RDFException {
        return null;
    }

    public Resource getStatementID(Statement s) throws RDFException {
        return null;
    }

    public boolean supportsAuthoring() {
        return false;
    }

    public boolean supportsEnumeration() {
        return true;
    }

    public RDFNode[] queryExtract(Statement[] query, Resource[] variables, Resource[] existentials) throws RDFException {
        Set s = this.query(query, variables, existentials);
        if (s.isEmpty()) {
            return null;
        }
        return (RDFNode[])s.iterator().next();
    }

    public Set queryMulti(Statement s, Resource[] existentials, RDFNode[][] hints) throws RDFException {
        throw new UnsupportedOperationException();
    }

    public Set queryMulti(Statement[] query, Resource[] variables, Resource[] existentials, RDFNode[][] hints) throws RDFException {
        throw new UnsupportedOperationException();
    }

    public void replace(Resource subject, Resource predicate, RDFNode object, RDFNode newValue) throws RDFException {
        boolean nullObj;
        boolean nullPred;
        boolean nullSubj = subject == null;
        if ((nullSubj ? 1 : 0) + ((nullPred = predicate == null) ? 1 : 0) + ((nullObj = object == null) ? 1 : 0) != 1) {
            throw new RDFException("replace expects exactly one null parameter");
        }
        Resource wildcard = Utilities.generateWildcardResource(1);
        this.remove(new Statement(nullSubj ? wildcard : subject, nullPred ? wildcard : predicate, nullObj ? wildcard : object), new Resource[]{wildcard});
        this.add(new Statement(nullSubj ? (Resource)newValue : subject, nullPred ? (Resource)newValue : predicate, nullObj ? newValue : object));
    }

    public int querySize(Statement[] query, Resource[] variables, Resource[] existentials) throws RDFException {
        return this.query(query, variables, existentials).size();
    }
}

