/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.rdf;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Selector;
import com.hp.hpl.jena.rdf.model.SimpleSelector;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryResults;
import com.hp.hpl.jena.rdql.ResultBinding;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;
import edu.mit.lcs.haystack.rdf.Var;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class JenaRDFContainer
implements IRDFContainer {
    protected Model m_model;

    public JenaRDFContainer() {
        this.m_model = ModelFactory.createMemModelMaker().createModel("");
    }

    public JenaRDFContainer(Model model) {
        this.m_model = model;
    }

    protected RDFNode convertNode(com.hp.hpl.jena.rdf.model.RDFNode node) throws RDFException {
        try {
            if (node instanceof com.hp.hpl.jena.rdf.model.Resource) {
                return new Resource(((com.hp.hpl.jena.rdf.model.Resource)node).getURI());
            }
            return new Literal(((com.hp.hpl.jena.rdf.model.Literal)node).getString());
        }
        catch (com.hp.hpl.jena.rdf.model.RDFException e) {
            throw new RDFException("Jena error", (Exception)((Object)e));
        }
    }

    protected com.hp.hpl.jena.rdf.model.RDFNode convertNode(RDFNode rdfn, boolean property) throws RDFException {
        try {
            if (rdfn instanceof Literal) {
                return this.m_model.createLiteral(rdfn.getContent());
            }
            if (property) {
                return this.m_model.createProperty("", rdfn.getContent());
            }
            return this.m_model.createResource(rdfn.getContent());
        }
        catch (com.hp.hpl.jena.rdf.model.RDFException e) {
            throw new RDFException("Jena error", (Exception)((Object)e));
        }
    }

    protected Node makeGraphNode(RDFNode rdfn, boolean property, Resource[] existentials, Var[] vars) throws RDFException {
        try {
            Node node = null;
            int i = Utilities.indexOfResource(existentials, rdfn);
            node = i != -1 ? Node.createVariable((String)vars[i].getVarName()) : (rdfn instanceof Literal ? Node.createLiteral((String)rdfn.getContent(), (String)"", (boolean)false) : (property ? Node.createURI((String)rdfn.getContent()) : Node.createURI((String)rdfn.getContent())));
            return node;
        }
        catch (com.hp.hpl.jena.rdf.model.RDFException e) {
            throw new RDFException("Jena error", (Exception)((Object)e));
        }
    }

    protected com.hp.hpl.jena.rdf.model.Statement convertStatement(Statement s) throws RDFException {
        try {
            return this.m_model.createStatement((com.hp.hpl.jena.rdf.model.Resource)this.convertNode(s.getSubject(), false), (Property)this.convertNode(s.getPredicate(), true), this.convertNode(s.getObject(), false));
        }
        catch (com.hp.hpl.jena.rdf.model.RDFException e) {
            throw new RDFException("Jena error", (Exception)((Object)e));
        }
    }

    protected Statement convertStatement(com.hp.hpl.jena.rdf.model.Statement s) throws RDFException {
        return new Statement((Resource)this.convertNode((com.hp.hpl.jena.rdf.model.RDFNode)s.getSubject()), (Resource)this.convertNode((com.hp.hpl.jena.rdf.model.RDFNode)s.getPredicate()), this.convertNode(s.getObject()));
    }

    protected Selector makeSelector(Statement s, Resource[] existentials) throws RDFException {
        Resource subj = s.getSubject();
        Resource pred = s.getPredicate();
        RDFNode obj = s.getObject();
        return new SimpleSelector(Utilities.containsResource(existentials, subj) ? null : (com.hp.hpl.jena.rdf.model.Resource)this.convertNode(subj, false), Utilities.containsResource(existentials, pred) ? null : (Property)this.convertNode(pred, true), Utilities.containsResource(existentials, obj) ? null : this.convertNode(obj, false));
    }

    protected Selector makeSelector(Statement s, Resource[] existentials, RDFNode[][] hints) throws RDFException {
        Resource subj = s.getSubject();
        Resource pred = s.getPredicate();
        RDFNode obj = s.getObject();
        return new SimpleSelector(Utilities.containsResource(existentials, subj) ? null : (com.hp.hpl.jena.rdf.model.Resource)this.convertNode(subj, false), Utilities.containsResource(existentials, pred) ? null : (Property)this.convertNode(pred, true), Utilities.containsResource(existentials, obj) ? null : this.convertNode(obj, false)){
            RDFNode[] m_subjectHints = null;
            RDFNode[] m_predicateHints = null;
            RDFNode[] m_objectHints = null;

            SimpleSelector init(Resource subj, Resource pred, RDFNode obj, Resource[] existentials, RDFNode[][] hints0) {
                int i = Utilities.indexOfResource(existentials, subj);
                if (i != -1) {
                    this.m_subjectHints = hints0[i];
                }
                if ((i = Utilities.indexOfResource(existentials, pred)) != -1) {
                    this.m_predicateHints = hints0[i];
                }
                if ((i = Utilities.indexOfResource(existentials, obj)) != -1) {
                    this.m_objectHints = hints0[i];
                }
                return this;
            }

            public boolean tests(com.hp.hpl.jena.rdf.model.Statement arg0) {
                try {
                    Statement s = JenaRDFContainer.this.convertStatement(arg0);
                    if (this.m_subjectHints != null && !Utilities.containsRDFNode(this.m_subjectHints, s.getSubject())) {
                        return false;
                    }
                    if (this.m_predicateHints != null && !Utilities.containsRDFNode(this.m_predicateHints, s.getPredicate())) {
                        return false;
                    }
                    if (this.m_objectHints != null && !Utilities.containsRDFNode(this.m_objectHints, s.getObject())) {
                        return false;
                    }
                    return super.selects(arg0);
                }
                catch (RDFException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.init(subj, pred, obj, existentials, hints);
    }

    protected Selector makeSelector(Resource subject, Resource predicate, RDFNode object) throws RDFException {
        boolean nullSubject = subject == null;
        boolean nullPredicate = predicate == null;
        boolean nullObject = object == null;
        return new SimpleSelector(nullSubject ? null : (com.hp.hpl.jena.rdf.model.Resource)this.convertNode(subject, false), nullPredicate ? null : (Property)this.convertNode(predicate, true), nullObject ? null : this.convertNode(object, false));
    }

    public void add(Statement s) throws RDFException {
        try {
            this.m_model.add(this.convertStatement(s));
        }
        catch (com.hp.hpl.jena.rdf.model.RDFException e) {
            throw new RDFException("Jena error", (Exception)((Object)e));
        }
    }

    public void add(Resource subject, Resource predicate, RDFNode object) throws RDFException {
        this.add(new Statement(subject, predicate, object));
    }

    public void add(IRDFContainer c) throws RDFException {
        Iterator i = c.iterator();
        try {
            while (i.hasNext()) {
                Statement s = (Statement)i.next();
                this.m_model.add(this.convertStatement(s));
            }
        }
        catch (com.hp.hpl.jena.rdf.model.RDFException e) {
            throw new RDFException("Jena error", (Exception)((Object)e));
        }
    }

    public void remove(Statement pattern, Resource[] existentials) throws RDFException {
        try {
            this.m_model.remove(this.m_model.listStatements(this.makeSelector(pattern, existentials)));
        }
        catch (com.hp.hpl.jena.rdf.model.RDFException e) {
            throw new RDFException("Jena error", (Exception)((Object)e));
        }
    }

    protected QueryEngine prepareQuery(Statement[] query, Resource[] variables, Resource[] existentials) throws RDFException {
        existentials = Utilities.combineResourceArrays(variables, existentials);
        Var[] newExistentials = new Var[existentials.length];
        int i = 0;
        while (i < existentials.length) {
            newExistentials[i] = new Var(existentials[i].getURI());
            ++i;
        }
        Query q = new Query();
        int i2 = 0;
        while (i2 < query.length) {
            Statement s = query[i2];
            Node s1 = this.makeGraphNode(s.getSubject(), false, existentials, newExistentials);
            Node s2 = this.makeGraphNode(s.getPredicate(), true, existentials, newExistentials);
            Node s3 = this.makeGraphNode(s.getObject(), false, existentials, newExistentials);
            q.addTriplePattern(s1, s2, s3);
            ++i2;
        }
        i2 = 0;
        while (i2 < variables.length) {
            q.addResultVar(variables[i2].getURI());
            ++i2;
        }
        q.setSource(this.m_model);
        return new QueryEngine(q);
    }

    public Set query(Statement[] query, Resource[] variables, Resource[] existentials) throws RDFException {
        QueryEngine qe = this.prepareQuery(query, variables, existentials);
        QueryResults qr = qe.exec();
        HashSet<RDFNode[]> set = new HashSet<RDFNode[]>();
        while (qr.hasNext()) {
            ResultBinding rb = (ResultBinding)qr.next();
            RDFNode[] datum = new RDFNode[variables.length];
            int i = 0;
            while (i < datum.length) {
                Object o = rb.get(variables[i].getURI());
                datum[i] = o instanceof com.hp.hpl.jena.rdf.model.Literal ? new Literal(((com.hp.hpl.jena.rdf.model.Literal)o).getString()) : this.convertNode((com.hp.hpl.jena.rdf.model.RDFNode)o);
                ++i;
            }
            set.add(datum);
        }
        qe.close();
        return set;
    }

    public int querySize(Statement[] query, Resource[] variables, Resource[] existentials) throws RDFException {
        return this.query(query, variables, existentials).size();
    }

    public Set queryMulti(Statement[] query, Resource[] variables, Resource[] existentials, RDFNode[][] hints) throws RDFException {
        throw new UnsupportedOperationException();
    }

    public Set query(Statement s, Resource[] existentials) throws RDFException {
        try {
            HashSet<RDFNode[]> set = new HashSet<RDFNode[]>();
            StmtIterator i = this.m_model.listStatements(this.makeSelector(s, existentials));
            while (i.hasNext()) {
                com.hp.hpl.jena.rdf.model.Statement stmt = i.nextStatement();
                RDFNode[] datum = new RDFNode[existentials.length];
                int j = 0;
                if (Utilities.containsResource(existentials, s.getSubject())) {
                    datum[j++] = this.convertNode((com.hp.hpl.jena.rdf.model.RDFNode)stmt.getSubject());
                }
                if (Utilities.containsResource(existentials, s.getPredicate())) {
                    datum[j++] = this.convertNode((com.hp.hpl.jena.rdf.model.RDFNode)stmt.getPredicate());
                }
                if (Utilities.containsResource(existentials, s.getObject())) {
                    datum[j] = this.convertNode(stmt.getObject());
                }
                set.add(datum);
            }
            return set;
        }
        catch (com.hp.hpl.jena.rdf.model.RDFException e) {
            throw new RDFException("Jena error", (Exception)((Object)e));
        }
    }

    public Set queryMulti(Statement s, Resource[] existentials, RDFNode[][] hints) throws RDFException {
        try {
            HashSet<RDFNode[]> set = new HashSet<RDFNode[]>();
            StmtIterator i = this.m_model.listStatements(this.makeSelector(s, existentials, hints));
            while (i.hasNext()) {
                com.hp.hpl.jena.rdf.model.Statement stmt = i.nextStatement();
                RDFNode[] datum = new RDFNode[existentials.length];
                int j = 0;
                if (Utilities.containsResource(existentials, s.getSubject())) {
                    datum[j++] = this.convertNode((com.hp.hpl.jena.rdf.model.RDFNode)stmt.getSubject());
                }
                if (Utilities.containsResource(existentials, s.getPredicate())) {
                    datum[j++] = this.convertNode((com.hp.hpl.jena.rdf.model.RDFNode)stmt.getPredicate());
                }
                if (Utilities.containsResource(existentials, s.getObject())) {
                    datum[j] = this.convertNode(stmt.getObject());
                }
                set.add(datum);
            }
            return set;
        }
        catch (com.hp.hpl.jena.rdf.model.RDFException e) {
            throw new RDFException("Jena error", (Exception)((Object)e));
        }
    }

    public RDFNode extract(Resource subject, Resource predicate, RDFNode object) throws RDFException {
        try {
            boolean nullSubject = subject == null;
            boolean nullPredicate = predicate == null;
            boolean nullObject = object == null;
            StmtIterator i = this.m_model.listStatements(this.makeSelector(subject, predicate, object));
            if (!i.hasNext()) {
                return null;
            }
            com.hp.hpl.jena.rdf.model.Statement s = i.nextStatement();
            if (nullSubject) {
                return this.convertNode((com.hp.hpl.jena.rdf.model.RDFNode)s.getSubject());
            }
            if (nullPredicate) {
                return this.convertNode((com.hp.hpl.jena.rdf.model.RDFNode)s.getPredicate());
            }
            return this.convertNode(s.getObject());
        }
        catch (com.hp.hpl.jena.rdf.model.RDFException e) {
            throw new RDFException("Jena error", (Exception)((Object)e));
        }
    }

    public RDFNode[] queryExtract(Statement[] query, Resource[] variables, Resource[] existentials) throws RDFException {
        QueryEngine qe = this.prepareQuery(query, variables, existentials);
        QueryResults qr = qe.exec();
        if (qr.hasNext()) {
            ResultBinding rb = (ResultBinding)qr.next();
            RDFNode[] datum = new RDFNode[variables.length];
            int i = 0;
            while (i < datum.length) {
                Object o = rb.get(variables[i].getURI());
                datum[i] = o instanceof com.hp.hpl.jena.rdf.model.Literal ? new Literal(((com.hp.hpl.jena.rdf.model.Literal)o).getString()) : this.convertNode((com.hp.hpl.jena.rdf.model.RDFNode)o);
                ++i;
            }
            qe.abort();
            qe.close();
            return datum;
        }
        qe.close();
        return null;
    }

    public boolean contains(Statement s) throws RDFException {
        try {
            return this.m_model.contains((com.hp.hpl.jena.rdf.model.Resource)this.convertNode(s.getSubject(), false), (Property)this.convertNode(s.getPredicate(), true), this.convertNode(s.getObject(), false));
        }
        catch (com.hp.hpl.jena.rdf.model.RDFException e) {
            throw new RDFException("Jena error", (Exception)((Object)e));
        }
    }

    public Resource getStatementID(Statement s) throws RDFException {
        return null;
    }

    public Resource[] getAuthors(Statement s) throws RDFException {
        return null;
    }

    public Resource[] getAuthors(Resource id) throws RDFException {
        return null;
    }

    public Statement getStatement(Resource id) throws RDFException {
        return null;
    }

    public Resource[] getAuthoredStatementIDs(Resource author) throws RDFException {
        return null;
    }

    public Statement[] getAuthoredStatements(Resource author) throws RDFException {
        return null;
    }

    public int size() throws RDFException {
        try {
            return (int)this.m_model.size();
        }
        catch (com.hp.hpl.jena.rdf.model.RDFException e) {
            throw new RDFException("Jena error", (Exception)((Object)e));
        }
    }

    public Iterator iterator() throws RDFException {
        return null;
    }

    public boolean supportsEnumeration() {
        return false;
    }

    public boolean supportsAuthoring() {
        return false;
    }

    public void replace(Resource subject, Resource predicate, RDFNode object, RDFNode newValue) throws RDFException {
        try {
            this.m_model.remove(this.m_model.listStatements(this.makeSelector(subject, predicate, object)));
            this.m_model.add(this.convertStatement(new Statement(subject == null ? (Resource)newValue : subject, predicate == null ? (Resource)newValue : predicate, object == null ? newValue : object)));
        }
        catch (com.hp.hpl.jena.rdf.model.RDFException e) {
            throw new RDFException("Jena error", (Exception)((Object)e));
        }
    }
}

