/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.rdf;

import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.IRDFEventSource;
import edu.mit.lcs.haystack.rdf.LocalRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;
import edu.mit.lcs.haystack.server.service.IPersistent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class FederationRDFContainer
implements IRDFContainer,
IRDFEventSource,
IPersistent {
    static Logger s_logger;
    ArrayList m_sources = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ledu.mit.lcs.haystack.server.service.ServiceManager;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("[ ");
        Iterator i = this.m_sources.iterator();
        while (i.hasNext()) {
            Source s = (Source)i.next();
            sb.append(s.m_rdfc);
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    public void addSource(IRDFContainer src, int priority) {
        if (src == null) {
            throw new IllegalArgumentException("src parameter cannot be null");
        }
        this.m_sources.add(new Source(src, priority));
        Collections.sort(this.m_sources, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Source)o1).m_priority - ((Source)o2).m_priority;
            }
        });
    }

    public void add(Statement s) throws RDFException {
        ((Source)this.m_sources.get((int)0)).m_rdfc.add(s);
    }

    public void add(Resource subject, Resource predicate, RDFNode object) throws RDFException {
        this.add(new Statement(subject, predicate, object));
    }

    public void add(IRDFContainer c) throws RDFException {
        ((Source)this.m_sources.get((int)0)).m_rdfc.add(c);
    }

    public void remove(Statement pattern, Resource[] existentials) throws RDFException {
        Iterator i = this.m_sources.iterator();
        while (i.hasNext()) {
            Source src = (Source)i.next();
            src.m_rdfc.remove(pattern, existentials);
        }
    }

    public Set query(Statement[] query, Resource[] variables, Resource[] existentials) throws RDFException {
        if (this.m_sources.size() == 1) {
            return ((Source)this.m_sources.get((int)0)).m_rdfc.query(query, variables, existentials);
        }
        ArrayList sources = this.buildSourceList(query, existentials = Utilities.combineResourceArrays(variables, existentials));
        if (sources.size() == 1) {
            return ((Source)sources.get((int)0)).m_rdfc.query(query, variables, existentials);
        }
        return this.queryInternal(query, variables, existentials, query.length == 1 ? this.m_sources : sources, null);
    }

    public int querySize(Statement[] query, Resource[] variables, Resource[] existentials) throws RDFException {
        if (this.m_sources.size() == 1) {
            return ((Source)this.m_sources.get((int)0)).m_rdfc.querySize(query, variables, existentials);
        }
        return this.query(query, variables, existentials).size();
    }

    public Set queryMulti(Statement[] query, Resource[] variables, Resource[] existentials, RDFNode[][] hints) throws RDFException {
        if (this.m_sources.size() == 1) {
            return ((Source)this.m_sources.get((int)0)).m_rdfc.queryMulti(query, variables, existentials, hints);
        }
        ArrayList sources = this.buildSourceList(query, existentials = Utilities.combineResourceArrays(variables, existentials));
        if (sources.size() == 1) {
            return ((Source)sources.get((int)0)).m_rdfc.queryMulti(query, variables, existentials, hints);
        }
        return this.queryInternal(query, variables, existentials, query.length == 1 ? this.m_sources : sources, hints);
    }

    public Set query(Statement s, Resource[] existentials) throws RDFException {
        if (this.m_sources.size() == 1) {
            return ((Source)this.m_sources.get((int)0)).m_rdfc.query(s, existentials);
        }
        return this.query(new Statement[]{s}, existentials, existentials);
    }

    public Set queryMulti(Statement s, Resource[] existentials, RDFNode[][] hints) throws RDFException {
        if (this.m_sources.size() == 1) {
            return ((Source)this.m_sources.get((int)0)).m_rdfc.queryMulti(s, existentials, hints);
        }
        return this.queryInternal(new Statement[]{s}, existentials, existentials, this.m_sources, hints);
    }

    public RDFNode extract(Resource subject, Resource predicate, RDFNode object) throws RDFException {
        Iterator i = this.m_sources.iterator();
        while (i.hasNext()) {
            Source src = (Source)i.next();
            RDFNode rdfn = src.m_rdfc.extract(subject, predicate, object);
            if (rdfn == null) continue;
            return rdfn;
        }
        return null;
    }

    public RDFNode[] queryExtract(Statement[] query, Resource[] variables, Resource[] existentials) throws RDFException {
        ArrayList sources = this.buildSourceList(query, existentials);
        Iterator i = sources.iterator();
        while (i.hasNext()) {
            Source src = (Source)i.next();
            RDFNode[] rdfn = src.m_rdfc.queryExtract(query, variables, existentials);
            if (rdfn == null) continue;
            return rdfn;
        }
        if (sources.size() == 1) {
            return null;
        }
        Set s = this.queryInternal(query, variables, existentials, sources, null);
        if (s.isEmpty()) {
            return null;
        }
        return (RDFNode[])s.iterator().next();
    }

    public boolean contains(Statement s) throws RDFException {
        Iterator i = this.m_sources.iterator();
        while (i.hasNext()) {
            Source src = (Source)i.next();
            if (!src.m_rdfc.contains(s)) continue;
            return true;
        }
        return false;
    }

    public Resource getStatementID(Statement s) throws RDFException {
        return s.getMD5HashResource();
    }

    public Resource[] getAuthors(Statement s) throws RDFException {
        return null;
    }

    public Resource[] getAuthors(Resource id) throws RDFException {
        return null;
    }

    public Statement getStatement(Resource id) throws RDFException {
        Iterator i = this.m_sources.iterator();
        while (i.hasNext()) {
            Source src = (Source)i.next();
            Statement s = src.m_rdfc.getStatement(id);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public Resource[] getAuthoredStatementIDs(Resource author) throws RDFException {
        return null;
    }

    public Statement[] getAuthoredStatements(Resource author) throws RDFException {
        return null;
    }

    public int size() throws RDFException {
        return 0;
    }

    public Iterator iterator() throws RDFException {
        return null;
    }

    public boolean supportsEnumeration() {
        return false;
    }

    public boolean supportsAuthoring() {
        return false;
    }

    public void replace(Resource subject, Resource predicate, RDFNode object, RDFNode newValue) throws RDFException {
        boolean nullObj;
        boolean nullPred;
        boolean nullSubj = subject == null;
        if ((nullSubj ? 1 : 0) + ((nullPred = predicate == null) ? 1 : 0) + ((nullObj = object == null) ? 1 : 0) != 1) {
            throw new RDFException("replace expects exactly one null parameter");
        }
        Resource wildcard = Utilities.generateWildcardResource(1);
        this.remove(new Statement(nullSubj ? wildcard : subject, nullPred ? wildcard : predicate, nullObj ? wildcard : object), new Resource[]{wildcard});
        this.add(new LocalRDFContainer(new Statement[]{new Statement(nullSubj ? (Resource)newValue : subject, nullPred ? (Resource)newValue : predicate, nullObj ? newValue : object)}));
    }

    public void addRDFListener(Resource rdfListener, Resource subject, Resource predicate, RDFNode object, Resource cookie) throws RDFException {
        Iterator i = this.m_sources.iterator();
        while (i.hasNext()) {
            IRDFEventSource rdfes;
            Source src = (Source)i.next();
            try {
                rdfes = (IRDFEventSource)((Object)src.m_rdfc);
            }
            catch (Exception e) {
                continue;
            }
            rdfes.addRDFListener(rdfListener, subject, predicate, object, cookie);
        }
    }

    public void removeRDFListener(Resource cookie) throws RDFException {
        Iterator i = this.m_sources.iterator();
        while (i.hasNext()) {
            IRDFEventSource rdfes;
            Source src = (Source)i.next();
            try {
                rdfes = (IRDFEventSource)((Object)src.m_rdfc);
            }
            catch (Exception e) {
                continue;
            }
            rdfes.removeRDFListener(cookie);
        }
    }

    protected ArrayList buildSourceList(Statement[] query, Resource[] existentials) {
        ArrayList<Source> sources;
        HashSet<Resource> predicates = new HashSet<Resource>();
        boolean anonPredicate = false;
        int i = 0;
        while (!anonPredicate && i < query.length) {
            Resource predicate = query[i].getPredicate();
            predicates.add(predicate);
            if (Utilities.containsResource(existentials, predicate)) {
                anonPredicate = true;
            }
            ++i;
        }
        if (anonPredicate) {
            sources = this.m_sources;
        } else {
            sources = new ArrayList<Source>();
            Iterator i2 = this.m_sources.iterator();
            while (i2.hasNext()) {
                Source src = (Source)i2.next();
                if (src.m_predicates.isEmpty()) {
                    sources.add(src);
                    continue;
                }
                HashSet<Resource> set = new HashSet<Resource>();
                set.addAll(predicates);
                set.retainAll(src.m_predicates);
                if (set.isEmpty()) continue;
                sources.add(src);
            }
        }
        return sources;
    }

    protected Set queryInternal(Statement[] query, Resource[] variables, Resource[] existentials, ArrayList sources, RDFNode[][] va) throws RDFException {
        HashSet currentResults = new HashSet();
        HashMap currentHints = new HashMap();
        ArrayList currentVariables = new ArrayList();
        HashSet<Statement> queryList = new HashSet<Statement>();
        queryList.addAll(Arrays.asList(query));
        while (!queryList.isEmpty()) {
            Resource[] existentials2;
            int nBestScore = 0;
            Statement pattern = null;
            if (queryList.size() == 1) {
                pattern = (Statement)queryList.iterator().next();
                queryList.clear();
            } else {
                Iterator i = queryList.iterator();
                while (i.hasNext()) {
                    int nScore;
                    Statement s = (Statement)i.next();
                    Resource subject = s.getSubject();
                    Resource predicate = s.getPredicate();
                    RDFNode object = s.getObject();
                    ArrayList subject0 = (ArrayList)currentHints.get(subject);
                    ArrayList predicate0 = (ArrayList)currentHints.get(predicate);
                    ArrayList object0 = (ArrayList)currentHints.get(object);
                    int n = !Utilities.containsResource(existentials, subject) ? 30000 : (nScore = subject0 != null && subject0.size() > 0 ? 30000 / subject0.size() : -1);
                    nScore += !Utilities.containsResource(existentials, predicate) ? 10000 : (predicate0 != null && predicate0.size() > 0 ? 10000 / predicate0.size() : -1);
                    if (pattern != null && (nScore += !Utilities.containsResource(existentials, object) ? 30000 : (object0 != null && object0.size() > 0 ? 30000 / object0.size() : -1)) <= nBestScore) continue;
                    pattern = s;
                    nBestScore = nScore;
                }
                queryList.remove(pattern);
            }
            ArrayList<RDFNode> currentQueryVars = new ArrayList<RDFNode>();
            if (Utilities.containsResource(existentials, pattern.getSubject())) {
                currentQueryVars.add(pattern.getSubject());
            }
            if (Utilities.containsResource(existentials, pattern.getPredicate()) && !currentQueryVars.contains(pattern.getPredicate())) {
                currentQueryVars.add(pattern.getPredicate());
            }
            if (Utilities.containsResource(existentials, pattern.getObject()) && !currentQueryVars.contains(pattern.getObject())) {
                currentQueryVars.add(pattern.getObject());
            }
            HashSet newResults = new HashSet();
            Iterator j = sources.iterator();
            if (va == null) {
                existentials2 = new Resource[currentQueryVars.size()];
                currentQueryVars.toArray(existentials2);
                va = new RDFNode[existentials2.length][];
                int x = 0;
                while (x < existentials2.length) {
                    Resource index = existentials2[x];
                    ArrayList vec = (ArrayList)currentHints.get(index);
                    if (vec == null) {
                        va[x] = null;
                    } else {
                        va[x] = new RDFNode[vec.size()];
                        vec.toArray(va[x]);
                    }
                    ++x;
                }
            } else {
                existentials2 = existentials;
            }
            while (j.hasNext()) {
                Set s;
                Source src = (Source)j.next();
                try {
                    s = src.m_rdfc.queryMulti(pattern, existentials2, va);
                }
                catch (UnsupportedOperationException ue) {
                    s = src.m_rdfc.query(pattern, existentials2);
                }
                if (s == null) {
                    return null;
                }
                newResults.addAll(s);
            }
            va = null;
            HashSet<RDFNode> s2 = new HashSet<RDFNode>();
            s2.addAll(currentQueryVars);
            s2.addAll(currentVariables);
            ArrayList<RDFNode> newVariables = new ArrayList<RDFNode>();
            newVariables.addAll(s2);
            j = newVariables.iterator();
            while (j.hasNext()) {
                Object index = j.next();
                ArrayList v = new ArrayList();
                currentHints.put(index, v);
            }
            if (currentVariables.isEmpty()) {
                j = newResults.iterator();
                while (j.hasNext()) {
                    RDFNode[] datum1 = (RDFNode[])j.next();
                    int l = 0;
                    while (l < newVariables.size()) {
                        Resource var = (Resource)newVariables.get(l);
                        ArrayList al = (ArrayList)currentHints.get(var);
                        al.add(datum1[l]);
                        ++l;
                    }
                }
                currentVariables = currentQueryVars;
                currentResults = newResults;
                continue;
            }
            HashSet<RDFNode[]> newResults2 = new HashSet<RDFNode[]>();
            j = newResults.iterator();
            while (j.hasNext()) {
                RDFNode[] datum1 = (RDFNode[])j.next();
                Iterator k = currentResults.iterator();
                block10: while (k.hasNext()) {
                    Resource var;
                    RDFNode[] datum2 = (RDFNode[])k.next();
                    RDFNode[] newDatum = new RDFNode[newVariables.size()];
                    int l = 0;
                    while (l < newVariables.size()) {
                        var = (Resource)newVariables.get(l);
                        int newIndex = currentQueryVars.indexOf(var);
                        int oldIndex = currentVariables.indexOf(var);
                        if (newIndex == -1 && oldIndex >= 0) {
                            newDatum[l] = datum2[oldIndex];
                        } else if (oldIndex == -1 && newIndex >= 0) {
                            newDatum[l] = datum1[newIndex];
                        } else if (oldIndex >= 0 && newIndex >= 0) {
                            if (!datum1[newIndex].equals(datum2[oldIndex])) continue block10;
                            newDatum[l] = datum1[newIndex];
                        }
                        ++l;
                    }
                    newResults2.add(newDatum);
                    l = 0;
                    while (l < newVariables.size()) {
                        var = (Resource)newVariables.get(l);
                        ArrayList al = (ArrayList)currentHints.get(var);
                        al.add(newDatum[l]);
                        ++l;
                    }
                }
            }
            currentResults = newResults2;
            currentVariables = newVariables;
        }
        HashSet<RDFNode[]> results = new HashSet<RDFNode[]>();
        HashSet<List<RDFNode>> arrayedResults = new HashSet<List<RDFNode>>();
        Iterator l = currentResults.iterator();
        while (l.hasNext()) {
            RDFNode[] datum1 = (RDFNode[])l.next();
            RDFNode[] datum2 = new RDFNode[variables.length];
            int j = 0;
            while (j < variables.length) {
                int k = currentVariables.indexOf(variables[j]);
                datum2[j] = k == -1 ? null : datum1[k];
                ++j;
            }
            List<RDFNode> l2 = Arrays.asList(datum2);
            if (arrayedResults.contains(l2)) continue;
            arrayedResults.add(l2);
            results.add(datum2);
        }
        return results;
    }

    public Resource getServiceResource() {
        IRDFContainer rdfc = ((Source)this.m_sources.get((int)0)).m_rdfc;
        if (rdfc instanceof IPersistent) {
            return ((IPersistent)rdfc).getServiceResource();
        }
        return null;
    }

    class Source {
        IRDFContainer m_rdfc;
        int m_priority;
        HashSet m_predicates = new HashSet();

        Source(IRDFContainer rdfc, int priority) {
            this.m_rdfc = rdfc;
            this.m_priority = priority;
        }
    }
}

