/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.tokenizer;

import java.io.IOException;
import java.io.Reader;

class CharIterator {
    static int m_bufferSize = 10;
    char[] m_chars = new char[m_bufferSize];
    int m_count;
    Reader m_reader;
    boolean m_eof;
    int m_offset;

    public CharIterator(Reader reader, int offset) {
        this.m_reader = reader;
        this.m_offset = offset;
    }

    public final int getOffset() {
        return this.m_offset;
    }

    public final char getChar() {
        return this.getChar(0);
    }

    public final char getChar(int ahead) {
        this.fetchSeveralChars(ahead + 1);
        if (this.m_count > ahead) {
            return this.m_chars[ahead];
        }
        return '\u0000';
    }

    public final void swallow() {
        this.swallow(1);
    }

    public final void swallow(int count) {
        this.fetchSeveralChars(count);
        if (count >= this.m_count) {
            this.m_offset += this.m_count;
            this.m_count = 0;
        } else {
            int i = 0;
            while (i < this.m_count - count) {
                this.m_chars[i] = this.m_chars[i + count];
                ++i;
            }
            this.m_count -= count;
            this.m_offset += count;
        }
    }

    public final boolean isEOF() {
        return this.m_eof;
    }

    final void fetchSeveralChars(int count) {
        if (count > this.m_count && !this.m_eof) {
            count = Math.min(m_bufferSize, count);
            int more = count - this.m_count;
            try {
                int actualMore = this.m_reader.read(this.m_chars, this.m_count, more);
                if (actualMore < more) {
                    this.m_eof = true;
                }
                this.m_count += actualMore;
            }
            catch (IOException e) {
                this.m_eof = true;
            }
        }
    }
}

