/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.query;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.query.AdenineConditionHandler;
import edu.mit.lcs.haystack.adenine.query.AndConditionHandler;
import edu.mit.lcs.haystack.adenine.query.Condition;
import edu.mit.lcs.haystack.adenine.query.ConditionSet;
import edu.mit.lcs.haystack.adenine.query.IConditionHandler;
import edu.mit.lcs.haystack.adenine.query.IQueryEngine;
import edu.mit.lcs.haystack.adenine.query.OrConditionHandler;
import edu.mit.lcs.haystack.adenine.query.RDFContainsConditionHandler;
import edu.mit.lcs.haystack.adenine.query.RDFPredicateConditionHandler;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class DefaultQueryEngine
implements IQueryEngine {
    IRDFContainer m_source;

    public DefaultQueryEngine() {
        this.m_source = null;
    }

    public DefaultQueryEngine(IRDFContainer rdfc) {
        this.m_source = rdfc;
    }

    public IConditionHandler resolveConditionHandler(DynamicEnvironment denv, Condition c) {
        if (c.getFunction().equals(AdenineConstants.or)) {
            return new OrConditionHandler();
        }
        if (c.getFunction().equals(AdenineConstants.and)) {
            return new AndConditionHandler();
        }
        if (c.getFunction().equals(AdenineConstants.contains)) {
            return new RDFContainsConditionHandler();
        }
        if (Utilities.isType(c.getFunction(), AdenineConstants.ConditionHandler, denv.getSource())) {
            return new AdenineConditionHandler();
        }
        return new RDFPredicateConditionHandler();
    }

    public void constructVariableList(Condition c, Resource[] existentials, HashSet currentQueryVars) {
        Iterator j = c.getParameterIterator();
        while (j.hasNext()) {
            Object o = j.next();
            if (o instanceof Resource && Utilities.containsResource(existentials, (Resource)o)) {
                currentQueryVars.add((Resource)o);
                continue;
            }
            if (!(o instanceof ConditionSet)) continue;
            Iterator i = ((ConditionSet)o).iterator();
            while (i.hasNext()) {
                this.constructVariableList((Condition)i.next(), existentials, currentQueryVars);
            }
        }
    }

    public Set query(DynamicEnvironment denv, ConditionSet query, boolean and, Resource[] variables, Resource[] existentials) throws AdenineException {
        RDFNode[][] hints = new RDFNode[existentials.length][];
        int t = 0;
        while (t < existentials.length) {
            hints[t] = null;
            ++t;
        }
        return this.query(denv, query, and, variables, existentials, hints);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set query(DynamicEnvironment denv, ConditionSet query, boolean and, Resource[] variables, Resource[] existentials, RDFNode[][] hints) throws AdenineException {
        IRDFContainer poppedSource = null;
        if (this.m_source != null) {
            poppedSource = denv.getSource();
            denv.setSource(this.m_source);
        }
        try {
            Set currentResults = new HashSet();
            Hashtable assoc = new Hashtable();
            if (hints.length == existentials.length) {
                int t = 0;
                while (t < hints.length) {
                    if (hints[t] != null) {
                        RDFNode[] arr = hints[t];
                        HashSet<RDFNode> set = new HashSet<RDFNode>();
                        int tt = 0;
                        while (tt < arr.length) {
                            set.add(arr[tt]);
                            ++tt;
                        }
                        assoc.put(existentials[t].toString(), set);
                    }
                    ++t;
                }
            }
            ArrayList currentVariables = new ArrayList();
            Iterator i = query.iterator();
            while (i.hasNext()) {
                Condition pattern = (Condition)i.next();
                ArrayList currentQueryVars = new ArrayList();
                HashSet hs = new HashSet();
                this.constructVariableList(pattern, existentials, hs);
                currentQueryVars.addAll(hs);
                Resource[] existentials2 = new Resource[currentQueryVars.size()];
                currentQueryVars.toArray(existentials2);
                RDFNode[][] va = new RDFNode[existentials2.length][];
                int x = 0;
                while (x < existentials2.length) {
                    String index = existentials2[x].toString();
                    HashSet set = (HashSet)assoc.get(index);
                    if (set == null) {
                        va[x] = null;
                    } else {
                        va[x] = new RDFNode[set.size()];
                        int y = 0;
                        Iterator iter = set.iterator();
                        while (iter.hasNext()) {
                            va[x][y++] = (RDFNode)iter.next();
                        }
                    }
                    ++x;
                }
                Set newResults = this.resolveConditionHandler(denv, pattern).resolveCondition(denv, this, pattern, existentials2, va);
                if (currentVariables.isEmpty()) {
                    currentVariables = currentQueryVars;
                    currentResults = newResults;
                } else {
                    HashSet s2 = new HashSet();
                    s2.addAll(currentQueryVars);
                    s2.addAll(currentVariables);
                    ArrayList newVariables = new ArrayList();
                    newVariables.addAll(s2);
                    currentResults = and ? this.mergeAnd(currentResults, newResults, currentVariables, currentQueryVars, newVariables) : this.mergeOr(currentResults, newResults, currentVariables, currentQueryVars, newVariables);
                    currentVariables = newVariables;
                }
                if (!and) continue;
                if (currentResults == null || currentResults.size() == 0) {
                    HashSet hashSet = new HashSet();
                    Object var23_35 = null;
                    if (poppedSource == null) return hashSet;
                    denv.setSource(poppedSource);
                    return hashSet;
                }
                assoc = new Hashtable();
                int j = 0;
                while (j < currentVariables.size()) {
                    String index = currentVariables.get(j).toString();
                    HashSet<RDFNode> values = new HashSet<RDFNode>();
                    Iterator k = currentResults.iterator();
                    while (k.hasNext()) {
                        RDFNode[] datum = (RDFNode[])k.next();
                        if (datum[j] == null) continue;
                        values.add(datum[j]);
                    }
                    assoc.put(index, values);
                    ++j;
                }
            }
            HashSet<RDFNode[]> results = new HashSet<RDFNode[]>();
            int[] varIndices = new int[variables.length];
            int j = 0;
            while (j < variables.length) {
                varIndices[j] = currentVariables.indexOf(variables[j]);
                ++j;
            }
            Iterator l = currentResults.iterator();
            while (l.hasNext()) {
                RDFNode[] datum1 = (RDFNode[])l.next();
                RDFNode[] datum2 = new RDFNode[variables.length];
                int j2 = 0;
                while (j2 < variables.length) {
                    datum2[j2] = varIndices[j2] == -1 ? null : datum1[varIndices[j2]];
                    ++j2;
                }
                results.add(datum2);
            }
            HashSet<RDFNode[]> hashSet = results;
            Object var23_36 = null;
            if (poppedSource == null) return hashSet;
            denv.setSource(poppedSource);
            return hashSet;
        }
        catch (Throwable throwable) {
            Object var23_37 = null;
            if (poppedSource == null) throw throwable;
            denv.setSource(poppedSource);
            throw throwable;
        }
    }

    private Set mergeAnd(Set currentResults, Set newResults, ArrayList currentVariables, ArrayList currentQueryVars, ArrayList newVariables) {
        int commonCount = 0;
        int oldOnlyCount = 0;
        int newOnlyCount = 0;
        int[] commonVariables = new int[newVariables.size()];
        int[] commonVarsOldPos = new int[newVariables.size()];
        int[] commonVarsNewPos = new int[newVariables.size()];
        int[] oldOnlyVariables = new int[newVariables.size()];
        int[] oldOnlyVarsPos = new int[newVariables.size()];
        int[] newOnlyVariables = new int[newVariables.size()];
        int[] newOnlyVarsPos = new int[newVariables.size()];
        HashSet<RDFNode[]> newResults2 = new HashSet<RDFNode[]>();
        int t = 0;
        while (t < newVariables.size()) {
            Resource var = (Resource)newVariables.get(t);
            int newIndex = currentQueryVars.indexOf(var);
            int oldIndex = currentVariables.indexOf(var);
            if (newIndex == -1 && oldIndex >= 0) {
                oldOnlyVarsPos[oldOnlyCount] = oldIndex;
                oldOnlyVariables[oldOnlyCount] = t;
                ++oldOnlyCount;
            } else if (oldIndex == -1 && newIndex >= 0) {
                newOnlyVarsPos[newOnlyCount] = newIndex;
                newOnlyVariables[newOnlyCount] = t;
                ++newOnlyCount;
            } else if (oldIndex >= 0 && newIndex >= 0) {
                commonVarsOldPos[commonCount] = oldIndex;
                commonVarsNewPos[commonCount] = newIndex;
                commonVariables[commonCount] = t;
                ++commonCount;
            }
            ++t;
        }
        Iterator j = newResults.iterator();
        while (j.hasNext()) {
            RDFNode[] datum1 = (RDFNode[])j.next();
            Iterator k = currentResults.iterator();
            block2: while (k.hasNext()) {
                RDFNode[] datum2 = (RDFNode[])k.next();
                int i = 0;
                while (i < commonCount) {
                    if (!datum1[commonVarsNewPos[i]].equals(datum2[commonVarsOldPos[i]])) continue block2;
                    ++i;
                }
                RDFNode[] newDatum = new RDFNode[newVariables.size()];
                int i2 = 0;
                while (i2 < commonCount) {
                    newDatum[commonVariables[i2]] = datum1[commonVarsNewPos[i2]];
                    ++i2;
                }
                i2 = 0;
                while (i2 < newOnlyCount) {
                    newDatum[newOnlyVariables[i2]] = datum1[newOnlyVarsPos[i2]];
                    ++i2;
                }
                i2 = 0;
                while (i2 < oldOnlyCount) {
                    newDatum[oldOnlyVariables[i2]] = datum2[oldOnlyVarsPos[i2]];
                    ++i2;
                }
                newResults2.add(newDatum);
            }
        }
        return newResults2;
    }

    private Set mergeOr(Set currentResults, Set newResults, ArrayList currentVariables, ArrayList currentQueryVars, ArrayList newVariables) {
        int commonCount = 0;
        int oldOnlyCount = 0;
        int newOnlyCount = 0;
        int[] commonVariables = new int[newVariables.size()];
        int[] commonVarsOldPos = new int[newVariables.size()];
        int[] commonVarsNewPos = new int[newVariables.size()];
        int[] oldOnlyVariables = new int[newVariables.size()];
        int[] oldOnlyVarsPos = new int[newVariables.size()];
        int[] newOnlyVariables = new int[newVariables.size()];
        int[] newOnlyVarsPos = new int[newVariables.size()];
        RDFNode[][] newResults1 = new RDFNode[newResults.size()][];
        RDFNode[][] newResults2 = new RDFNode[currentResults.size()][];
        int[] hash1 = new int[newResults.size()];
        int[] hash2 = new int[currentResults.size()];
        HashSet<RDFNode[]> finalResult = new HashSet<RDFNode[]>();
        int t = 0;
        while (t < newVariables.size()) {
            Resource var = (Resource)newVariables.get(t);
            int newIndex = currentQueryVars.indexOf(var);
            int oldIndex = currentVariables.indexOf(var);
            if (newIndex == -1 && oldIndex >= 0) {
                oldOnlyVarsPos[oldOnlyCount] = oldIndex;
                oldOnlyVariables[oldOnlyCount] = t;
                ++oldOnlyCount;
            } else if (oldIndex == -1 && newIndex >= 0) {
                newOnlyVarsPos[newOnlyCount] = newIndex;
                newOnlyVariables[newOnlyCount] = t;
                ++newOnlyCount;
            } else if (oldIndex >= 0 && newIndex >= 0) {
                commonVarsOldPos[commonCount] = oldIndex;
                commonVarsNewPos[commonCount] = newIndex;
                commonVariables[commonCount] = t;
                ++commonCount;
            }
            ++t;
        }
        int count = 0;
        Iterator j = newResults.iterator();
        while (j.hasNext()) {
            RDFNode node;
            int hash = 0;
            RDFNode[] datum1 = (RDFNode[])j.next();
            RDFNode[] newDatum = new RDFNode[newVariables.size()];
            int i = 0;
            while (i < commonCount) {
                newDatum[commonVariables[i]] = node = datum1[commonVarsNewPos[i]];
                hash += node.hashCode();
                ++i;
            }
            i = 0;
            while (i < newOnlyCount) {
                newDatum[newOnlyVariables[i]] = node = datum1[newOnlyVarsPos[i]];
                hash += node.hashCode();
                ++i;
            }
            i = 0;
            while (i < oldOnlyCount) {
                newDatum[oldOnlyVariables[i]] = null;
                ++i;
            }
            hash1[count] = hash;
            newResults1[count++] = newDatum;
            finalResult.add(newDatum);
        }
        count = 0;
        Iterator k = currentResults.iterator();
        while (k.hasNext()) {
            RDFNode node;
            int hash = 0;
            RDFNode[] datum2 = (RDFNode[])k.next();
            RDFNode[] newDatum = new RDFNode[newVariables.size()];
            int i = 0;
            while (i < commonCount) {
                newDatum[commonVariables[i]] = node = datum2[commonVarsOldPos[i]];
                hash += node.hashCode();
                ++i;
            }
            i = 0;
            while (i < newOnlyCount) {
                newDatum[newOnlyVariables[i]] = null;
                ++i;
            }
            i = 0;
            while (i < oldOnlyCount) {
                newDatum[oldOnlyVariables[i]] = node = datum2[oldOnlyVarsPos[i]];
                hash += node.hashCode();
                ++i;
            }
            hash2[count] = hash;
            newResults2[count++] = newDatum;
        }
        int t2 = 0;
        while (t2 < newResults2.length) {
            block17: {
                int tt = 0;
                while (tt < newResults1.length) {
                    if (hash2[t2] != hash1[tt] || !Arrays.equals(newResults2[t2], newResults1[tt])) {
                        ++tt;
                        continue;
                    }
                    break block17;
                }
                finalResult.add(newResults2[t2]);
            }
            ++t2;
        }
        return finalResult;
    }
}

