/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.query;

import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.functions.DeserializeFunction;
import edu.mit.lcs.haystack.adenine.interpreter.ISerializable;
import edu.mit.lcs.haystack.adenine.query.Condition;
import edu.mit.lcs.haystack.rdf.DAMLListIterator;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ConditionSet
implements ISerializable,
Serializable {
    protected ArrayList m_conditions = new ArrayList();

    public ConditionSet() {
    }

    public ConditionSet(Resource res, IRDFContainer source) {
        Resource conditions = Utilities.getResourceProperty(res, AdenineConstants.conditions, source);
        if (conditions != null) {
            DAMLListIterator i = ListUtilities.accessDAMLList(conditions, source);
            while (i.hasNext()) {
                Resource condition = (Resource)i.next();
                ArrayList<Object> al = new ArrayList<Object>();
                DAMLListIterator j = ListUtilities.accessDAMLList(condition, source);
                Resource function = (Resource)j.next();
                while (j.hasNext()) {
                    Object o = j.next();
                    al.add(DeserializeFunction.deserialize((Resource)o, source));
                }
                Condition c = new Condition(function, al);
                this.m_conditions.add(c);
            }
        }
    }

    public Condition get(int x) {
        return (Condition)this.m_conditions.get(x);
    }

    public int count() {
        return this.m_conditions.size();
    }

    public Iterator iterator() {
        return this.m_conditions.iterator();
    }

    public void addAll(ConditionSet cs) {
        this.m_conditions.addAll(cs.m_conditions);
    }

    public void add(Condition c) {
        this.m_conditions.add(c);
    }

    public void remove(Condition c) {
        this.m_conditions.remove(c);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("%{ ");
        Iterator i = this.m_conditions.iterator();
        while (i.hasNext()) {
            Condition c = (Condition)i.next();
            sb.append(c.getFunction());
            sb.append(" ");
            Iterator j = c.getParameterIterator();
            while (j.hasNext()) {
                Object o = j.next();
                if (o instanceof Resource) {
                    String uri = ((Resource)o).getURI();
                    if (uri.indexOf("urn:haystack:wildcard:") == 0) {
                        sb.append("?");
                        sb.append(uri.substring("urn:haystack:wildcard:".length()));
                    } else {
                        sb.append(o);
                    }
                } else {
                    sb.append(o);
                }
                sb.append(" ");
            }
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public RDFNode serialize(IRDFContainer rdfc) throws RDFException, AdenineException {
        Resource res = Utilities.generateUniqueResource();
        rdfc.add(new Statement(res, Constants.s_rdf_type, AdenineConstants.ConditionSet));
        Iterator i = this.m_conditions.iterator();
        ArrayList<Resource> al = new ArrayList<Resource>();
        while (i.hasNext()) {
            Condition c = (Condition)i.next();
            ArrayList<RDFNode> al2 = new ArrayList<RDFNode>();
            al2.add(c.getFunction());
            Iterator j = c.getParameterIterator();
            while (j.hasNext()) {
                al2.add(ConditionSet.extractNode(j.next(), rdfc));
            }
            al.add(ListUtilities.createDAMLList(al2.iterator(), rdfc));
        }
        rdfc.add(new Statement(res, AdenineConstants.conditions, ListUtilities.createDAMLList(al.iterator(), rdfc)));
        return res;
    }

    public static RDFNode extractNode(Object o, IRDFContainer rdfc) throws AdenineException, RDFException {
        try {
            if (o instanceof Collection) {
                return ListUtilities.createDAMLList(((Collection)o).iterator(), rdfc);
            }
            if (o instanceof Literal) {
                Resource res = Utilities.generateUniqueResource();
                rdfc.add(new Statement(res, Constants.s_rdf_type, AdenineConstants.Literal));
                rdfc.add(new Statement(res, AdenineConstants.literal, (Literal)o));
                return res;
            }
            if (o instanceof Resource) {
                Resource res = Utilities.generateUniqueResource();
                rdfc.add(new Statement(res, Constants.s_rdf_type, AdenineConstants.Resource));
                rdfc.add(new Statement(res, AdenineConstants.resource, (Resource)o));
                return res;
            }
            if (o instanceof String) {
                return new Literal((String)o);
            }
            if (o == null) {
                return new Literal("null");
            }
            if (o instanceof ISerializable) {
                return ((ISerializable)o).serialize(rdfc);
            }
            return new Literal(o.toString());
        }
        catch (ClassCastException cce) {
            throw new AdenineException("Type error", cce);
        }
    }
}

