/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.parser2.constructs;

import edu.mit.lcs.haystack.adenine.constructs.IFunctionVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IAttributeVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ICodeBlockVisitor;
import edu.mit.lcs.haystack.adenine.parser2.IConstructParser;
import edu.mit.lcs.haystack.adenine.parser2.IConstructVisitor;
import edu.mit.lcs.haystack.adenine.parser2.NullAttributeVisitor;
import edu.mit.lcs.haystack.adenine.parser2.NullCodeBlockVisitor;
import edu.mit.lcs.haystack.adenine.parser2.ParserUtilities;
import edu.mit.lcs.haystack.adenine.parser2.SyntaxException;
import edu.mit.lcs.haystack.adenine.tokenizer.GenericToken;
import edu.mit.lcs.haystack.adenine.tokenizer.ITokenIterator;
import edu.mit.lcs.haystack.adenine.tokenizer.IndentToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Location;
import edu.mit.lcs.haystack.adenine.tokenizer.NewLineToken;
import edu.mit.lcs.haystack.adenine.tokenizer.SymbolToken;
import edu.mit.lcs.haystack.adenine.tokenizer.Token;

public class FunctionParser
implements IConstructParser {
    public Location parseConstruct(ITokenIterator tIterator, IConstructVisitor constructVisitor, IndentToken indentToken) {
        IFunctionVisitor visitor = constructVisitor instanceof IFunctionVisitor ? (IFunctionVisitor)constructVisitor : new IFunctionVisitor(){
            IConstructVisitor m_constructVisitor;

            public IAttributeVisitor onAttribute(SymbolToken semicolonT) {
                return new NullAttributeVisitor(this.m_constructVisitor);
            }

            public void onFunction(GenericToken functionKeyword, GenericToken name) {
            }

            public void onParameter(GenericToken parameter) {
            }

            public ICodeBlockVisitor onBody() {
                return new NullCodeBlockVisitor(this.m_constructVisitor);
            }

            public void start(Location startLocation) {
                this.m_constructVisitor.start(startLocation);
            }

            public void end(Location endLocation) {
                this.m_constructVisitor.end(endLocation);
            }

            public void onException(Exception exception) {
                this.m_constructVisitor.onException(exception);
            }

            public IFunctionVisitor init(IConstructVisitor constructVisitor) {
                this.m_constructVisitor = constructVisitor;
                return this;
            }
        }.init(constructVisitor);
        visitor.start(tIterator.getLocation());
        Token token = tIterator.getToken();
        Location endLocation = null;
        if (token instanceof GenericToken && ((GenericToken)token).getContent().equals("function")) {
            GenericToken function = (GenericToken)token;
            tIterator.swallow();
            ParserUtilities.skipWhitespacesAndComments(tIterator);
            token = tIterator.getToken();
            if (token instanceof GenericToken || token instanceof SymbolToken) {
                visitor.onFunction(function, ParserUtilities.parseCompoundGenericToken(tIterator, token));
                ParserUtilities.skipWhitespacesAndComments(tIterator);
                while ((token = tIterator.getToken()) != null) {
                    if (token instanceof NewLineToken) {
                        tIterator.swallow();
                    } else {
                        if (token instanceof GenericToken || token instanceof SymbolToken) {
                            visitor.onParameter(ParserUtilities.parseCompoundGenericToken(tIterator, token));
                            ParserUtilities.skipWhitespacesAndComments(tIterator);
                            continue;
                        }
                        visitor.onException(new SyntaxException("Expected parameter", tIterator.getLocation()));
                        ParserUtilities.skipToNextLine(tIterator);
                    }
                    break;
                }
            } else {
                visitor.onException(new SyntaxException("Expected function name", tIterator.getLocation()));
                ParserUtilities.skipToNextLine(tIterator);
            }
            endLocation = tIterator.getLocation();
            ParserUtilities.skipWhitespacesCommentsAndNewLines(tIterator);
            token = tIterator.getToken();
            if (token instanceof IndentToken && indentToken.isOuterLevelOf((IndentToken)token)) {
                endLocation = ParserUtilities.parseCodeBlock(tIterator, visitor.onBody(), (IndentToken)token);
            }
        } else {
            visitor.onException(new SyntaxException("Expected function keyword", tIterator.getLocation()));
            ParserUtilities.skipToNextLine(tIterator);
        }
        if (endLocation == null) {
            endLocation = tIterator.getLocation();
        }
        visitor.end(endLocation);
        return endLocation;
    }
}

