/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.parser;

import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.SyntaxException;
import edu.mit.lcs.haystack.adenine.parser.Token;

public class LiteralToken
extends Token {
    public LiteralToken(int line) {
        this.m_line = line;
    }

    public int processToken(String str, int i) throws AdenineException {
        while (i < str.length()) {
            char ch;
            if ((ch = str.charAt(i++)) == '\"') {
                return i;
            }
            if (ch == '\\') {
                if (i == str.length()) {
                    throw new SyntaxException("Unfinished escape sequence", this.m_line);
                }
                ch = LiteralToken.processEscapeSequence(str.charAt(i++));
            }
            this.m_token = String.valueOf(this.m_token) + ch;
        }
        throw new SyntaxException("Unclosed quotation", this.m_line);
    }

    public String toString() {
        return "\"" + this.m_token + "\"";
    }

    public static String unescapeString(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public String prettyPrint(int tablevel) {
        return "\"" + LiteralToken.unescapeString(this.m_token) + "\"";
    }

    public static char processEscapeSequence(char ch) {
        switch (ch) {
            case 'n': {
                return '\n';
            }
            case 'b': {
                return '\b';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
        }
        return ch;
    }
}

