/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.interpreter;

import com.sun.tools.javac.Main;
import edu.mit.lcs.haystack.Constants;
import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.compiler.Compiler;
import edu.mit.lcs.haystack.adenine.compiler.ExistentialExpression;
import edu.mit.lcs.haystack.adenine.functions.AddFunction;
import edu.mit.lcs.haystack.adenine.functions.AndFunction;
import edu.mit.lcs.haystack.adenine.functions.AppendFunction;
import edu.mit.lcs.haystack.adenine.functions.ApplyFunction;
import edu.mit.lcs.haystack.adenine.functions.AskFunction;
import edu.mit.lcs.haystack.adenine.functions.BitAndFunction;
import edu.mit.lcs.haystack.adenine.functions.ConnectFunction;
import edu.mit.lcs.haystack.adenine.functions.ContainsFunction;
import edu.mit.lcs.haystack.adenine.functions.DeserializeFunction;
import edu.mit.lcs.haystack.adenine.functions.DivideFunction;
import edu.mit.lcs.haystack.adenine.functions.EqualityFunction;
import edu.mit.lcs.haystack.adenine.functions.ExtractFunction;
import edu.mit.lcs.haystack.adenine.functions.FederatingQueryEngineFunction;
import edu.mit.lcs.haystack.adenine.functions.ForkFunction;
import edu.mit.lcs.haystack.adenine.functions.GtFunction;
import edu.mit.lcs.haystack.adenine.functions.InequalityFunction;
import edu.mit.lcs.haystack.adenine.functions.InstanceOfFunction;
import edu.mit.lcs.haystack.adenine.functions.LengthFunction;
import edu.mit.lcs.haystack.adenine.functions.ListFunction;
import edu.mit.lcs.haystack.adenine.functions.LtFunction;
import edu.mit.lcs.haystack.adenine.functions.MinusFunction;
import edu.mit.lcs.haystack.adenine.functions.MultiplyFunction;
import edu.mit.lcs.haystack.adenine.functions.NewFunction;
import edu.mit.lcs.haystack.adenine.functions.NotFunction;
import edu.mit.lcs.haystack.adenine.functions.OrFunction;
import edu.mit.lcs.haystack.adenine.functions.PlusFunction;
import edu.mit.lcs.haystack.adenine.functions.PrintDataFunction;
import edu.mit.lcs.haystack.adenine.functions.PrintFunction;
import edu.mit.lcs.haystack.adenine.functions.PrintListFunction;
import edu.mit.lcs.haystack.adenine.functions.PrintSetFunction;
import edu.mit.lcs.haystack.adenine.functions.QueryExtractFunction;
import edu.mit.lcs.haystack.adenine.functions.QueryFunction;
import edu.mit.lcs.haystack.adenine.functions.QuerySizeFunction;
import edu.mit.lcs.haystack.adenine.functions.ReifyFunction;
import edu.mit.lcs.haystack.adenine.functions.RemoveFunction;
import edu.mit.lcs.haystack.adenine.functions.ReplaceFunction;
import edu.mit.lcs.haystack.adenine.functions.SetFunction;
import edu.mit.lcs.haystack.adenine.functions.SortFunction;
import edu.mit.lcs.haystack.adenine.functions.XMLDOMFunction;
import edu.mit.lcs.haystack.adenine.interpreter.AdenineClassLoaderManager;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.ContinuationException;
import edu.mit.lcs.haystack.adenine.interpreter.DebugDisplay;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.JavaMethodWrapper;
import edu.mit.lcs.haystack.adenine.interpreter.Message;
import edu.mit.lcs.haystack.adenine.interpreter.UnknownInstructionException;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.adenine.parser.Block;
import edu.mit.lcs.haystack.adenine.parser.Parser;
import edu.mit.lcs.haystack.proxy.IServiceAccessor;
import edu.mit.lcs.haystack.proxy.ProxyManager;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.ListUtilities;
import edu.mit.lcs.haystack.rdf.Literal;
import edu.mit.lcs.haystack.rdf.RDFException;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Statement;
import edu.mit.lcs.haystack.rdf.URIGenerator;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Category;

public class Interpreter {
    HashMap m_instructionHandlers = new HashMap(100);
    IRDFContainer m_source;
    IRDFContainer m_instructionSource;
    IServiceAccessor m_sa;
    IRDFContainer m_target = null;
    ArrayList m_callStack = new ArrayList();
    DebugDisplay m_debugDisplay = null;
    Resource m_currentMethod = null;
    int m_stepDepth = Integer.MAX_VALUE;
    static AdenineClassLoaderManager s_loaderManager;
    public static final Category s_logger;
    public static Environment s_defaultEnvironment;
    static ArrayList s_numberClassOrder;
    static ArrayList s_numberConverters;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Ledu.mit.lcs.haystack.adenine.interpreter.Interpreter;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Category.getInstance((Class)clazz);
        s_defaultEnvironment = new Environment();
        s_defaultEnvironment.setValue("add", new AddFunction());
        s_defaultEnvironment.setValue("ask", new AskFunction());
        s_defaultEnvironment.setValue("query", new QueryFunction());
        s_defaultEnvironment.setValue("remove", new RemoveFunction());
        s_defaultEnvironment.setValue("replace", new ReplaceFunction());
        s_defaultEnvironment.setValue("deserialize", new DeserializeFunction());
        s_defaultEnvironment.setValue("extract", new ExtractFunction());
        s_defaultEnvironment.setValue("apply", new ApplyFunction());
        s_defaultEnvironment.setValue("length", new LengthFunction());
        s_defaultEnvironment.setValue("queryExtract", new QueryExtractFunction());
        s_defaultEnvironment.setValue("querySize", new QuerySizeFunction());
        s_defaultEnvironment.setValue("connect", new ConnectFunction());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Ledu.mit.lcs.haystack.rdf.Utilities;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_defaultEnvironment.setValue("UniqueResource", new JavaMethodWrapper(clazz2, "generateUniqueResource"));
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("[Ledu.mit.lcs.haystack.rdf.Utilities;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_defaultEnvironment.setValue("UnknownResource", new JavaMethodWrapper(clazz3, "generateUnknownResource"));
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("[Ledu.mit.lcs.haystack.rdf.PackageFilterRDFContainer;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_defaultEnvironment.setValue("PackageFilterRDFContainer", clazz4);
        s_defaultEnvironment.setValue("==", new EqualityFunction());
        s_defaultEnvironment.setValue("!=", new InequalityFunction());
        s_defaultEnvironment.setValue("!", new NotFunction());
        s_defaultEnvironment.setValue("append", new AppendFunction());
        s_defaultEnvironment.setValue("String", new AppendFunction());
        s_defaultEnvironment.setValue("contains", new ContainsFunction());
        s_defaultEnvironment.setValue("+", new PlusFunction());
        s_defaultEnvironment.setValue("*", new MultiplyFunction());
        s_defaultEnvironment.setValue("&", new BitAndFunction());
        s_defaultEnvironment.setValue("-", new MinusFunction());
        s_defaultEnvironment.setValue("/", new DivideFunction());
        s_defaultEnvironment.setValue("lt", new LtFunction());
        s_defaultEnvironment.setValue("gt", new GtFunction());
        s_defaultEnvironment.setValue("List", new ListFunction());
        s_defaultEnvironment.setValue("Set", new SetFunction());
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("[Ljava.util.HashMap;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_defaultEnvironment.setValue("Map", clazz5);
        s_defaultEnvironment.setValue("fork", new ForkFunction());
        s_defaultEnvironment.setValue("new", new NewFunction());
        s_defaultEnvironment.setValue("null", null);
        s_defaultEnvironment.setValue("and", new AndFunction());
        s_defaultEnvironment.setValue("or", new OrFunction());
        s_defaultEnvironment.setValue("true", new Boolean(true));
        s_defaultEnvironment.setValue("false", new Boolean(false));
        s_defaultEnvironment.setValue("instanceOf", new InstanceOfFunction());
        s_defaultEnvironment.setValue("print", new PrintFunction());
        s_defaultEnvironment.setValue("sort", new SortFunction());
        s_defaultEnvironment.setValue("reify", new ReifyFunction());
        Class<?> clazz6 = class$4;
        if (clazz6 == null) {
            try {
                clazz6 = class$4 = Class.forName("[Ledu.mit.lcs.haystack.rdf.Literal;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_defaultEnvironment.setValue("Literal", clazz6);
        Class<?> clazz7 = class$5;
        if (clazz7 == null) {
            try {
                clazz7 = class$5 = Class.forName("[Ljava.lang.Integer;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_defaultEnvironment.setValue("Integer", clazz7);
        Class<?> clazz8 = class$6;
        if (clazz8 == null) {
            try {
                clazz8 = class$6 = Class.forName("[Ledu.mit.lcs.haystack.rdf.Resource;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_defaultEnvironment.setValue("Resource", clazz8);
        Class<?> clazz9 = class$7;
        if (clazz9 == null) {
            try {
                clazz9 = class$7 = Class.forName("[Ledu.mit.lcs.haystack.adenine.interpreter.Message;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_defaultEnvironment.setValue("Message", clazz9);
        Class<?> clazz10 = class$8;
        if (clazz10 == null) {
            try {
                clazz10 = class$8 = Class.forName("[Ledu.mit.lcs.haystack.rdf.Statement;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_defaultEnvironment.setValue("Statement", clazz10);
        Class<?> clazz11 = class$9;
        if (clazz11 == null) {
            try {
                clazz11 = class$9 = Class.forName("[Ledu.mit.lcs.haystack.rdf.LocalRDFContainer;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_defaultEnvironment.setValue("LocalRDFContainer", clazz11);
        Class<?> clazz12 = class$10;
        if (clazz12 == null) {
            try {
                clazz12 = class$10 = Class.forName("[Ledu.mit.lcs.haystack.adenine.query.DefaultQueryEngine;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_defaultEnvironment.setValue("DefaultQueryEngine", clazz12);
        s_defaultEnvironment.setValue("FederatingQueryEngine", new FederatingQueryEngineFunction());
        s_defaultEnvironment.setValue("XMLDOM", new XMLDOMFunction());
        s_defaultEnvironment.setValue("printset", new PrintSetFunction());
        s_defaultEnvironment.setValue("printlist", new PrintListFunction());
        s_defaultEnvironment.setValue("printdata", new PrintDataFunction());
        s_numberClassOrder = new ArrayList();
        Class<?> clazz13 = class$11;
        if (clazz13 == null) {
            try {
                clazz13 = class$11 = Class.forName("[Ljava.lang.Byte;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_numberClassOrder.add(clazz13);
        Class<?> clazz14 = class$12;
        if (clazz14 == null) {
            try {
                clazz14 = class$12 = Class.forName("[Ljava.lang.Short;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_numberClassOrder.add(clazz14);
        Class<?> clazz15 = class$5;
        if (clazz15 == null) {
            try {
                clazz15 = class$5 = Class.forName("[Ljava.lang.Integer;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_numberClassOrder.add(clazz15);
        Class<?> clazz16 = class$13;
        if (clazz16 == null) {
            try {
                clazz16 = class$13 = Class.forName("[Ljava.lang.Long;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_numberClassOrder.add(clazz16);
        Class<?> clazz17 = class$14;
        if (clazz17 == null) {
            try {
                clazz17 = class$14 = Class.forName("[Ljava.lang.Float;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_numberClassOrder.add(clazz17);
        Class<?> clazz18 = class$15;
        if (clazz18 == null) {
            try {
                clazz18 = class$15 = Class.forName("[Ljava.lang.Double;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_numberClassOrder.add(clazz18);
        s_numberConverters = new ArrayList();
        s_numberConverters.add(new INumberConverter(){

            public Object convertNumber(Number n) {
                return new Byte(n.byteValue());
            }
        });
        s_numberConverters.add(new INumberConverter(){

            public Object convertNumber(Number n) {
                return new Short(n.shortValue());
            }
        });
        s_numberConverters.add(new INumberConverter(){

            public Object convertNumber(Number n) {
                return new Integer(n.intValue());
            }
        });
        s_numberConverters.add(new INumberConverter(){

            public Object convertNumber(Number n) {
                return new Long(n.longValue());
            }
        });
        s_numberConverters.add(new INumberConverter(){

            public Object convertNumber(Number n) {
                return new Float(n.floatValue());
            }
        });
        s_numberConverters.add(new INumberConverter(){

            public Object convertNumber(Number n) {
                return new Double(n.doubleValue());
            }
        });
    }

    public static List upgradeNumberCollection(List l) {
        Iterator i = l.iterator();
        int max = -1;
        while (i.hasNext()) {
            Object o = i.next();
            if (o == null) {
                return l;
            }
            Class<?> c = o.getClass();
            int n = s_numberClassOrder.indexOf(c);
            if (n == -1) {
                return l;
            }
            if (n <= max) continue;
            max = n;
        }
        if (max == -1) {
            return l;
        }
        ArrayList<Object> newList = new ArrayList<Object>();
        i = l.iterator();
        INumberConverter nc = (INumberConverter)s_numberConverters.get(max);
        while (i.hasNext()) {
            newList.add(nc.convertNumber((Number)i.next()));
        }
        return newList;
    }

    public static int getLineNumber(Resource res, IRDFContainer source) {
        String strLine = Utilities.getLiteralProperty(res, AdenineConstants.line, source);
        if (strLine != null) {
            try {
                return Integer.parseInt(strLine);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static VariableFrame generateJavaBlock(IExpression body, StringBuffer buffer, VariableFrame parentFrame, ConstantTable ct) throws AdenineException {
        return Interpreter.generateJavaBlock(null, body, buffer, parentFrame, null, ct, true);
    }

    public static VariableFrame generateJavaBlock(String ident, IExpression body, StringBuffer buffer, VariableFrame parentFrame, String varName, ConstantTable ct, boolean generateVariables) throws AdenineException {
        StringBuffer buffer2 = new StringBuffer();
        VariableFrame frame = new VariableFrame();
        frame.m_parentFrame = parentFrame;
        if (varName != null) {
            frame.m_variables.add(varName);
        }
        if (ident == null) {
            ident = Interpreter.generateIdentifier();
            buffer.append("Object ");
            buffer.append(ident);
            buffer.append(";\n");
        }
        body.generateJava(ident, buffer2, frame, ct);
        if (generateVariables) {
            Iterator i = frame.m_variables.iterator();
            while (i.hasNext()) {
                String ident2 = (String)i.next();
                if (ident2.equals(varName)) continue;
                buffer.append("Object ");
                buffer.append(frame.resolveVariableName(ident2));
                buffer.append(" = null;\n");
            }
        }
        buffer.append(buffer2);
        return frame;
    }

    public static String generateIdentifier() {
        return "__anon" + Utilities.generateUniqueIdentifier() + "__";
    }

    public static final boolean isTrue(Object condition) {
        return condition != null && (condition instanceof Literal && ((Literal)condition).getContent().compareToIgnoreCase("true") != 0 || condition instanceof Number && ((Number)condition).intValue() != 0 || condition instanceof Boolean && (Boolean)condition != false || !(condition instanceof Number) && !(condition instanceof Boolean));
    }

    public void setTarget(IRDFContainer rdfc) {
        this.m_target = rdfc;
    }

    public void setServiceAccessor(IServiceAccessor sa) {
        this.m_sa = sa;
    }

    public Interpreter(IRDFContainer rdfc) {
        this.m_source = rdfc;
        this.m_instructionSource = rdfc;
        this.m_sa = new ProxyManager(this.m_source, null);
        s_loaderManager = AdenineClassLoaderManager.getInstance();
        try {
            Set s = this.m_instructionSource.query(new Statement[]{new Statement(Utilities.generateWildcardResource(1), Constants.s_rdf_type, AdenineConstants.INSTRUCTION_HANDLER), new Statement(Utilities.generateWildcardResource(1), Constants.s_haystack_javaImplementation, Utilities.generateWildcardResource(2)), new Statement(Utilities.generateWildcardResource(1), AdenineConstants.INSTRUCTION_DOMAIN, Utilities.generateWildcardResource(4)), new Statement(Utilities.generateWildcardResource(2), Constants.s_haystack_className, Utilities.generateWildcardResource(3))}, new Resource[]{Utilities.generateWildcardResource(3), Utilities.generateWildcardResource(4)}, Utilities.generateWildcardResourceArray(4));
            Iterator i = s.iterator();
            while (i.hasNext()) {
                RDFNode[] a = (RDFNode[])i.next();
                Literal l = (Literal)a[0];
                Resource res = (Resource)a[1];
                try {
                    IInstructionHandler ih = (IInstructionHandler)Class.forName(l.getContent()).newInstance();
                    ih.initialize(this);
                    this.addInstructionHandler(res, ih);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            s_logger.error((Object)"Unknown error", (Throwable)e);
        }
    }

    public IRDFContainer getRootRDFContainer() {
        return this.m_instructionSource;
    }

    public void addInstructionHandler(Resource resInstructionHandler, IInstructionHandler handler) {
        this.m_instructionHandlers.put(resInstructionHandler, handler);
    }

    public IInstructionHandler determineInstructionHandler(Resource resInstruction) throws AdenineException {
        try {
            Resource res = (Resource)this.m_instructionSource.queryExtract(new Statement[]{new Statement(resInstruction, Constants.s_rdf_type, Utilities.generateWildcardResource(1)), new Statement(Utilities.generateWildcardResource(2), AdenineConstants.INSTRUCTION_DOMAIN, Utilities.generateWildcardResource(1))}, Utilities.generateWildcardResourceArray(2), Utilities.generateWildcardResourceArray(1))[0];
            IInstructionHandler ih = (IInstructionHandler)this.m_instructionHandlers.get(res);
            if (ih == null) {
                throw new UnknownInstructionException("ins " + resInstruction + " " + res + " " + res.toString());
            }
            return ih;
        }
        catch (UnknownInstructionException uie) {
            throw uie;
        }
        catch (Exception e) {
            Resource res = Utilities.getResourceProperty(resInstruction, Constants.s_rdf_type, this.m_instructionSource);
            s_logger.error((Object)"Unknown error", (Throwable)e);
            throw new UnknownInstructionException(res == null ? "uri " + resInstruction.toString() : res.toString(), e);
        }
    }

    public IExpression compileInstruction(Resource resInstruction) throws AdenineException {
        ArrayList<IExpression> al = new ArrayList<IExpression>();
        do {
            IInstructionHandler ih = this.determineInstructionHandler(resInstruction);
            try {
                al.add(ih.generateExpression(resInstruction));
            }
            catch (AdenineException ae) {
                String strLine;
                if (ae.m_line == -1 && (strLine = Utilities.getLiteralProperty(resInstruction, AdenineConstants.line, this.m_source)) != null) {
                    try {
                        ae.m_line = Integer.parseInt(strLine);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                throw ae;
            }
        } while ((resInstruction = Utilities.getResourceProperty(resInstruction, AdenineConstants.next, this.m_source)) != null);
        if (al.size() == 1) {
            return (IExpression)al.get(0);
        }
        return new IExpression(){
            ArrayList m_al;

            IExpression init(ArrayList al2) {
                this.m_al = al2;
                return this;
            }

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) throws AdenineException {
                Iterator i = this.m_al.iterator();
                while (i.hasNext()) {
                    IExpression exp = (IExpression)i.next();
                    exp.generateJava(targetVar, buffer, frame, ct);
                }
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                Iterator i = this.m_al.iterator();
                Object o = null;
                while (i.hasNext()) {
                    o = ((IExpression)i.next()).evaluate(env, denv);
                }
                return o;
            }
        }.init(al);
    }

    public Object runInstruction(Resource resInstruction, Environment env, DynamicEnvironment denv) throws AdenineException {
        Object o;
        do {
            ArrayList oldCallStack = (ArrayList)this.m_callStack.clone();
            this.m_callStack.add(resInstruction);
            IInstructionHandler ih = this.determineInstructionHandler(resInstruction);
            if (this.m_debugDisplay != null && !ih.isConstantExpression() && this.m_stepDepth > this.m_callStack.size()) {
                int choice = this.m_debugDisplay.displayStatus(this.m_callStack, env, denv, null);
                switch (choice) {
                    case 5: {
                        try {
                            this.m_instructionSource.remove(new Statement(this.m_currentMethod, AdenineConstants.debug, Utilities.generateWildcardResource(1)), Utilities.generateWildcardResourceArray(1));
                        }
                        catch (RDFException rDFException) {
                            // empty catch block
                        }
                    }
                    case 4: {
                        this.m_debugDisplay.dispose();
                        this.m_debugDisplay = null;
                        break;
                    }
                    case 1: {
                        this.m_stepDepth = this.m_callStack.size() + 1;
                        break;
                    }
                    case 0: {
                        this.m_stepDepth = Integer.MAX_VALUE;
                    }
                }
            }
            try {
                o = ih.evaluate(resInstruction, env, denv);
            }
            catch (ContinuationException ce) {
                throw ce;
            }
            catch (AdenineException ae) {
                ae.addToStackTrace(resInstruction, this.m_instructionSource);
                this.m_callStack = oldCallStack;
                throw ae;
            }
            catch (NullPointerException npe) {
                AdenineException ae = new AdenineException("Null pointer exception", npe);
                ae.addToStackTrace(resInstruction, this.m_instructionSource);
                throw ae;
            }
            catch (Exception e) {
                AdenineException ae = new AdenineException("Unknown exception", e);
                ae.addToStackTrace(resInstruction, this.m_instructionSource);
                throw ae;
            }
            this.m_callStack = oldCallStack;
        } while ((resInstruction = Utilities.getResourceProperty(resInstruction, AdenineConstants.next, this.m_instructionSource)) != null);
        return o;
    }

    public Environment createInitialEnvironment() {
        return (Environment)s_defaultEnvironment.clone();
    }

    public static String filterSymbols(String str) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            switch (ch) {
                case '=': {
                    sb.append("_eq");
                    break;
                }
                case '+': {
                    sb.append("_pl");
                    break;
                }
                case '&': {
                    sb.append("_an");
                    break;
                }
                case '-': {
                    sb.append("_mi");
                    break;
                }
                case '*': {
                    sb.append("_ti");
                    break;
                }
                case '!': {
                    sb.append("_ba");
                    break;
                }
                case '_': {
                    sb.append("_un");
                    break;
                }
                case ':': {
                    sb.append("_co");
                    break;
                }
                case '/': {
                    sb.append("_sl");
                    break;
                }
                case '\\': {
                    sb.append("_bs");
                    break;
                }
                case '.': {
                    sb.append("_do");
                    break;
                }
                case '?': {
                    sb.append("_qu");
                    break;
                }
                case '#': {
                    sb.append("_ha");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String escapeString(String str) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\'': {
                    sb.append("\\'");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public void compileMethodToJava(Resource resMethod, String path) throws AdenineException {
        try {
            String[] output = this.convertMethodToJava(resMethod);
            File file = new File(path, String.valueOf(output[0]) + ".java");
            FileOutputStream fos = new FileOutputStream(file);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(fos));
            pw.write(output[1]);
            pw.close();
            fos.close();
            String[] args = new String[]{"-sourcepath", path, "-d", path, "-classpath", System.getProperty("java.class.path"), "-nowarn", file.getAbsolutePath()};
            if (Main.compile(args) == 0) {
                File subclass;
                this.m_instructionSource.add(new Statement(resMethod, Constants.s_haystack_JavaClass, new Literal(output[0])));
                s_loaderManager.updateClass(new File(path, String.valueOf(output[0]) + ".class"), output[0]);
                int t = 1;
                while ((subclass = new File(path, String.valueOf(output[0]) + "$" + t + ".class")).exists()) {
                    s_loaderManager.updateClass(subclass, String.valueOf(output[0]) + "$" + t);
                    ++t;
                }
            } else {
                new File(path, String.valueOf(output[0]) + ".class").delete();
            }
        }
        catch (Exception e) {
            throw new AdenineException("Compilation error", e);
        }
    }

    public Collection compileMethodsToJava(Collection methods, String path) {
        ArrayList<String> params = new ArrayList<String>();
        ArrayList<Resource> successful = new ArrayList<Resource>();
        ArrayList<String> successfulFiles = new ArrayList<String>();
        params.add("-sourcepath");
        params.add(path);
        params.add("-d");
        params.add(path);
        params.add("-classpath");
        params.add(System.getProperty("java.class.path"));
        params.add("-nowarn");
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Resource resMethod = (Resource)i.next();
            try {
                String[] output = this.convertMethodToJava(resMethod);
                File file = new File(path, String.valueOf(output[0]) + ".java");
                FileOutputStream fos = new FileOutputStream(file);
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(fos));
                pw.write(output[1]);
                pw.close();
                fos.close();
                params.add(file.getAbsolutePath());
                successful.add(resMethod);
                successfulFiles.add(output[0]);
            }
            catch (Exception e) {
                s_logger.info((Object)("Could not compile method " + resMethod + " to Java"), (Throwable)e);
            }
        }
        if (params.size() <= 7) {
            return new HashSet();
        }
        String[] args = new String[params.size()];
        params.toArray(args);
        try {
            Iterator i2;
            if (Main.compile(args) == 0) {
                i = successful.iterator();
                i2 = successfulFiles.iterator();
                while (i.hasNext()) {
                    File subclass;
                    Resource resMethod = (Resource)i.next();
                    String filename = (String)i2.next();
                    this.m_instructionSource.add(new Statement(resMethod, Constants.s_haystack_JavaClass, new Literal(filename)));
                    s_loaderManager.updateClass(new File(path, String.valueOf(filename) + ".class"), filename);
                    int t = 1;
                    while ((subclass = new File(path, String.valueOf(filename) + "$" + t + ".class")).exists()) {
                        s_loaderManager.updateClass(subclass, String.valueOf(filename) + "$" + t);
                        ++t;
                    }
                }
                return successful;
            }
            i2 = successfulFiles.iterator();
            while (i2.hasNext()) {
                String filename = (String)i2.next();
                new File(path, String.valueOf(filename) + ".class").delete();
            }
        }
        catch (Exception e) {
            s_logger.info((Object)"Error invoking Java compiler", (Throwable)e);
        }
        return new HashSet();
    }

    public String[] convertMethodToJava(Resource resMethod) throws AdenineException {
        String methodName = Interpreter.filterSymbols(resMethod.getURI());
        StringBuffer sb = new StringBuffer();
        sb.append("import edu.mit.lcs.haystack.rdf.*;\nimport edu.mit.lcs.haystack.adenine.*;\n");
        sb.append("import edu.mit.lcs.haystack.adenine.interpreter.*;\nimport edu.mit.lcs.haystack.adenine.instructions.*;\n");
        sb.append("import edu.mit.lcs.haystack.adenine.query.*;\n");
        sb.append("import java.util.*;\n");
        sb.append("import edu.mit.lcs.haystack.Constants;\n");
        Resource resStart = Utilities.getResourceProperty(resMethod, AdenineConstants.start, this.m_instructionSource);
        IExpression exp = this.compileInstruction(resStart);
        sb.append("public class ");
        sb.append(methodName);
        sb.append(" extends CompiledMethod {\npublic void initializeParameters(Message msg) {\nint i = 0;\nObject[] parameters = msg.m_values;\n");
        VariableFrame frame = new VariableFrame();
        StringBuffer sb2 = new StringBuffer();
        Iterator i = ListUtilities.accessDAMLList(Utilities.getResourceProperty(resMethod, AdenineConstants.PARAMETERS, this.m_instructionSource), this.m_instructionSource);
        while (i.hasNext()) {
            Resource resVarName = (Resource)i.next();
            String varName = Utilities.getLiteralProperty(resVarName, AdenineConstants.name, this.m_instructionSource);
            frame.m_variables.add(varName);
            sb.append("if (i < parameters.length) {\n");
            sb.append(frame.resolveVariableName(varName));
            sb.append(" = parameters[i++];\n}\n");
            sb2.append("Object ");
            sb2.append(frame.resolveVariableName(varName));
            sb2.append(";\n");
        }
        Resource[] namedParameters = Utilities.getResourceProperties(resMethod, AdenineConstants.namedParameter, this.m_instructionSource);
        int j = 0;
        while (j < namedParameters.length) {
            Resource paramName = Utilities.getResourceProperty(namedParameters[j], AdenineConstants.parameterName, this.m_instructionSource);
            String varName = Utilities.getIndirectProperty(namedParameters[j], AdenineConstants.parameterVariable, AdenineConstants.name, this.m_instructionSource).getContent();
            frame.m_variables.add(varName);
            sb.append(frame.resolveVariableName(varName));
            sb.append(" = msg.getNamedValue(new Resource(\"" + paramName.getURI() + "\"));\n");
            sb2.append("Object ");
            sb2.append(frame.resolveVariableName(varName));
            sb2.append(";\n");
            ++j;
        }
        sb.append("}\n");
        sb.append(sb2);
        sb.append("protected Message doInvoke() throws RDFException, AdenineException {\n");
        StringBuffer sb3 = new StringBuffer();
        ConstantTable ct = new ConstantTable();
        VariableFrame vf2 = Interpreter.generateJavaBlock("out", exp, sb3, frame, null, ct, false);
        sb.append("Object out;\n");
        sb.append(sb3);
        sb.append("return new Message(out);\n}\n");
        i = frame.m_defaultEnvironmentVariables.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            Object function = Interpreter.s_defaultEnvironment.m_bindings.get(name);
            frame.m_variables.add(name);
            sb.append("static Object ");
            sb.append(frame.resolveVariableName(name));
            sb.append(" = Interpreter.s_defaultEnvironment.getValue(\"");
            sb.append(name);
            sb.append("\");\n");
        }
        i = vf2.m_variables.iterator();
        while (i.hasNext()) {
            String ident2 = (String)i.next();
            sb.append("Object ");
            sb.append(vf2.resolveVariableName(ident2));
            sb.append(" = null;\n");
        }
        sb.append(ct.generateConstantTable());
        sb.append("}\n");
        return new String[]{methodName, sb.toString()};
    }

    public Object callMethod(Resource resMethod, Object[] arguments) throws AdenineException {
        DynamicEnvironment denv = new DynamicEnvironment();
        IRDFContainer rdfcOut = this.m_target == null ? this.m_source : this.m_target;
        denv.setSource(this.m_source);
        denv.setTarget(rdfcOut);
        denv.setServiceAccessor(this.m_sa);
        return this.callMethod(resMethod, arguments, denv);
    }

    public Message callMethod(Resource resMethod, Message msg) throws AdenineException {
        DynamicEnvironment denv = new DynamicEnvironment();
        IRDFContainer rdfcOut = this.m_target == null ? this.m_source : this.m_target;
        denv.setSource(this.m_source);
        denv.setTarget(rdfcOut);
        denv.setServiceAccessor(this.m_sa);
        return this.callMethod(resMethod, msg, denv);
    }

    public Object callMethod(Resource resMethod, Object[] arguments, DynamicEnvironment denv) throws AdenineException {
        return this.callMethod(resMethod, new Message(arguments), denv).getPrimaryValueChecked();
    }

    /*
     * Exception decompiling
     */
    public Message callMethod(Resource resMethod, Message message, DynamicEnvironment denv) throws AdenineException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [7 : 612->615)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object eval(String str, HashMap prefixes, Environment env, DynamicEnvironment denv) throws Exception {
        Compiler compiler = new Compiler(this.m_source);
        Block b = Parser.blockify(Parser.tokenize(new StringReader(str)));
        ExistentialExpression ee = compiler.compileBlock(b, prefixes);
        if (ee == null) {
            return null;
        }
        Resource res = (Resource)ee.generate(new URIGenerator(), this.m_instructionSource);
        if (res == null) {
            return null;
        }
        return this.runInstruction(res, env, denv);
    }

    interface INumberConverter {
        public Object convertNumber(Number var1);
    }
}

