/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.interpreter;

import edu.mit.lcs.haystack.adenine.interpreter.Cell;
import edu.mit.lcs.haystack.adenine.interpreter.UnboundIdentifierException;
import java.util.HashMap;

public class Environment
implements Cloneable {
    HashMap m_bindings = new HashMap(100);

    public Object getValue(String name) {
        return this.getCell(name).getValue();
    }

    public Object getValueChecked(String name) throws UnboundIdentifierException {
        if (!this.isBound(name)) {
            throw new UnboundIdentifierException(name);
        }
        return this.getCell(name).getValue();
    }

    public Cell getCell(String name) {
        return (Cell)this.m_bindings.get(name);
    }

    public void setCell(String name, Cell c) {
        this.m_bindings.put(name, c);
    }

    public void setValue(String name, Object o) {
        if (!this.isBound(name)) {
            this.setCell(name, new Cell(o));
        } else {
            Cell c = this.getCell(name);
            c.setValue(o);
        }
    }

    public void unbind(String name) {
        this.m_bindings.remove(name);
    }

    public boolean isBound(String name) {
        return this.m_bindings.containsKey(name);
    }

    public void allocateCell(String name) {
        this.m_bindings.put(name, new Cell());
    }

    public Object clone() {
        Environment e = new Environment();
        e.m_bindings = (HashMap)this.m_bindings.clone();
        return e;
    }
}

