/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.interpreter;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.SWTConsole;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.content.ContentClient;
import edu.mit.lcs.haystack.proxy.IServiceAccessor;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

class DebugDisplay {
    Interpreter m_interpreter;
    Shell m_shell;
    SashForm m_sashForm;
    ToolBar m_toolbar;
    SWTConsole m_console;
    Text m_status;
    StyledText m_source;
    static final int STEP_INTO = 0;
    static final int STEP_OVER = 1;
    static final int STEP_OUT = 2;
    static final int CONTINUE = 3;
    static final int STOP_DEBUGGING = 4;
    static final int UNMARK = 5;

    DebugDisplay(Interpreter i) {
        this.m_interpreter = i;
        Display display = Display.getDefault();
        this.m_shell = new Shell(display);
        this.m_shell.setText("Adenine Debugger");
        this.m_sashForm = new SashForm((Composite)this.m_shell, 512);
        this.m_toolbar = new ToolBar((Composite)this.m_shell, 0x800000);
        this.m_shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent ce) {
                Point tb = DebugDisplay.this.m_toolbar.computeSize(-1, -1);
                Rectangle r = DebugDisplay.this.m_shell.getClientArea();
                DebugDisplay.this.m_toolbar.setBounds(0, 0, r.width, tb.y);
                DebugDisplay.this.m_sashForm.setBounds(0, tb.y, r.width, r.height - tb.y);
            }
        });
        this.m_status = new Text((Composite)this.m_sashForm, 514);
        this.m_status.setEditable(false);
        this.m_source = new StyledText((Composite)this.m_sashForm, 514);
        this.m_source.setEditable(false);
        Font font = new Font((Device)display, "Courier New", 8, 0);
        this.m_source.setFont(font);
        this.m_console = new SWTConsole((Composite)this.m_sashForm, i.getRootRDFContainer());
        ToolItem ti = new ToolItem(this.m_toolbar, 0);
        ti.setText("Step Into");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                throw new Event(0);
            }
        });
        ti = new ToolItem(this.m_toolbar, 0);
        ti.setText("Step Over");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                throw new Event(1);
            }
        });
        ti = new ToolItem(this.m_toolbar, 0);
        ti.setText("Stop Debugging");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                throw new Event(4);
            }
        });
        ti = new ToolItem(this.m_toolbar, 0);
        ti.setText("Unmark As Debuggable");
        ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                throw new Event(5);
            }
        });
    }

    void dumpEnvironment(Environment env, StringBuffer sb) {
        Iterator i = env.m_bindings.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = env.getValue(key);
            sb.append("\t[");
            sb.append(key);
            sb.append("] ");
            sb.append(value);
            sb.append("\n");
        }
    }

    void dumpStackTrace(ArrayList stack, StringBuffer sb) {
        ListIterator i = stack.listIterator(stack.size());
        while (i.hasPrevious()) {
            Resource res = (Resource)i.previous();
            String description = AdenineException.describeInstruction(res, this.m_interpreter.getRootRDFContainer());
            sb.append("\t");
            sb.append(description);
            sb.append("\n");
        }
    }

    int displayStatus(ArrayList stack, Environment env, DynamicEnvironment denv, AdenineException ae) {
        IRDFContainer rdfc = this.m_interpreter.getRootRDFContainer();
        this.m_console.setEnvironment(env);
        this.m_console.setDynamicEnvironment(denv);
        this.m_shell.open();
        StringBuffer sb = new StringBuffer();
        sb.append("Current method:\n\t");
        sb.append(this.m_interpreter.m_currentMethod);
        sb.append("\n\nStack trace:\n");
        this.dumpStackTrace(stack, sb);
        sb.append("\nEnvironment:\n");
        this.dumpEnvironment(env, sb);
        sb.append("\nDynamic environment:\n");
        this.dumpEnvironment(denv, sb);
        this.m_status.setText(sb.toString());
        Resource resTop = (Resource)stack.get(stack.size() - 1);
        String source = null;
        try {
            source = ContentClient.getContentClient((Resource)Utilities.getResourceProperty(resTop, AdenineConstants.source, rdfc), (IRDFContainer)rdfc, (IServiceAccessor)this.m_interpreter.m_sa).getContentAsString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (source != null) {
            this.m_source.setText(source);
            int line = Interpreter.getLineNumber(resTop, rdfc);
            if (line != -1) {
                int offset = this.m_source.getOffsetAtLine(--line);
                int endOffset = line >= this.m_source.getLineCount() - 1 ? this.m_source.getCharCount() : this.m_source.getOffsetAtLine(line + 1);
                this.m_source.setSelection(offset, endOffset);
                this.m_source.showSelection();
            }
        } else {
            this.m_source.setText("No source available");
        }
        try {
            Display d = this.m_shell.getDisplay();
            while (!this.m_shell.isDisposed()) {
                if (d.readAndDispatch()) continue;
                d.sleep();
            }
        }
        catch (Event e) {
            this.m_shell.setVisible(false);
            return e.m_status;
        }
        return 4;
    }

    void dispose() {
        if (!this.m_shell.isDisposed()) {
            this.m_shell.dispose();
        }
    }

    class Event
    extends RuntimeException {
        int m_status;

        Event(int s) {
            this.m_status = s;
        }
    }
}

