/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.interpreter;

import edu.mit.lcs.haystack.adenine.interpreter.AdenineClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

public class AdenineClassLoaderManager {
    HashMap m_classNameToClassLoader = new HashMap();
    HashSet m_excludes = new HashSet();
    AdenineClassLoader m_currentLoader = new AdenineClassLoader(this.getClass().getClassLoader());
    String m_precompilePath = new File(System.getProperty("edu.mit.lcs.haystack.precompile", ".")).getAbsolutePath();
    private static AdenineClassLoaderManager s_instance = null;

    private AdenineClassLoaderManager() {
    }

    public static AdenineClassLoaderManager getInstance() {
        if (s_instance == null) {
            s_instance = new AdenineClassLoaderManager();
        }
        return s_instance;
    }

    public void updateClass(File file, String className) {
        throw new RuntimeException("This method is deprecated");
    }

    public ClassLoader updateClass(byte[] bytes, String className) {
        if (this.m_currentLoader.hasClass(className)) {
            this.m_currentLoader = new AdenineClassLoader(this.getClass().getClassLoader());
        }
        this.m_classNameToClassLoader.put(className, this.m_currentLoader);
        this.m_currentLoader.loadDefineClass(bytes, className);
        try {
            FileOutputStream fos = new FileOutputStream(this.makeFileFromClassName(className));
            fos.write(bytes);
            fos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.m_currentLoader;
    }

    public synchronized Class getClass(String className) {
        Class<?> klass;
        block6: {
            klass = null;
            ClassLoader loader = (ClassLoader)this.m_classNameToClassLoader.get(className);
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            try {
                klass = loader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {
                if (this.m_excludes.contains(className)) break block6;
                try {
                    File f = this.makeFileFromClassName(className);
                    FileInputStream fis = new FileInputStream(f);
                    int length = (int)f.length();
                    byte[] bytes = new byte[length];
                    int i = 0;
                    int j = 0;
                    while (i < length && j != -1) {
                        j = fis.read(bytes, i, length - i);
                        i += j;
                    }
                    fis.close();
                    this.m_classNameToClassLoader.put(className, this.m_currentLoader);
                    this.m_currentLoader.loadDefineClass(bytes, className);
                    klass = this.m_currentLoader.loadClass(className);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.m_excludes.add(className);
                }
            }
        }
        return klass;
    }

    File makeFileFromClassName(String className) throws IOException {
        return new File(this.m_precompilePath, String.valueOf(className) + ".class");
    }
}

