/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;

public class ResourceInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return true;
    }

    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        return Utilities.getResourceProperty(res, AdenineConstants.resource, this.m_source);
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new ResourceExpression(res);
    }

    public class ResourceExpression
    implements IExpression {
        Resource m_res;

        public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) {
            buffer.append(targetVar);
            buffer.append(" = ");
            buffer.append(ct.getConstantName("new Resource(\"" + Interpreter.escapeString(this.m_res.getURI()) + "\")"));
            buffer.append(";\n");
        }

        ResourceExpression(Resource res2) {
            this.m_res = Utilities.getResourceProperty(res2, AdenineConstants.resource, ResourceInstruction.this.m_source);
        }

        public Resource getResource() {
            return this.m_res;
        }

        public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
            return this.m_res;
        }
    }
}

