/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.lcs.haystack.adenine.instructions;

import edu.mit.lcs.haystack.adenine.AdenineConstants;
import edu.mit.lcs.haystack.adenine.AdenineException;
import edu.mit.lcs.haystack.adenine.interpreter.ConstantTable;
import edu.mit.lcs.haystack.adenine.interpreter.DynamicEnvironment;
import edu.mit.lcs.haystack.adenine.interpreter.Environment;
import edu.mit.lcs.haystack.adenine.interpreter.IExpression;
import edu.mit.lcs.haystack.adenine.interpreter.IInstructionHandler;
import edu.mit.lcs.haystack.adenine.interpreter.Interpreter;
import edu.mit.lcs.haystack.adenine.interpreter.VariableFrame;
import edu.mit.lcs.haystack.rdf.IRDFContainer;
import edu.mit.lcs.haystack.rdf.RDFNode;
import edu.mit.lcs.haystack.rdf.Resource;
import edu.mit.lcs.haystack.rdf.Utilities;

public class RDFNodeInstruction
implements IInstructionHandler {
    IRDFContainer m_source;
    Interpreter m_interpreter;

    public void initialize(Interpreter interpreter) {
        this.m_interpreter = interpreter;
        this.m_source = interpreter.getRootRDFContainer();
    }

    public boolean isConstantExpression() {
        return true;
    }

    public Object evaluate(Resource res, Environment env, DynamicEnvironment denv) throws AdenineException {
        return Utilities.getProperty(res, AdenineConstants.rdfNode, this.m_source);
    }

    public IExpression generateExpression(Resource res) throws AdenineException {
        return new IExpression(){
            RDFNode m_rdfNode;

            public void generateJava(String targetVar, StringBuffer buffer, VariableFrame frame, ConstantTable ct) {
                buffer.append(targetVar);
                buffer.append(" = ");
                StringBuffer sb2 = new StringBuffer();
                if (this.m_rdfNode instanceof Resource) {
                    sb2.append("new Resource(\"");
                } else {
                    sb2.append("new Literal(\"");
                }
                sb2.append(Interpreter.escapeString(this.m_rdfNode.getContent()));
                sb2.append("\")");
                buffer.append(ct.getConstantName(sb2.toString()));
                buffer.append(";\n");
            }

            IExpression init(Resource res2) {
                this.m_rdfNode = Utilities.getProperty(res2, AdenineConstants.rdfNode, RDFNodeInstruction.this.m_source);
                return this;
            }

            public Object evaluate(Environment env, DynamicEnvironment denv) throws AdenineException {
                return this.m_rdfNode;
            }
        }.init(res);
    }
}

